eval 'exec perl -S $0 $*'
                if $runnning_under_some_shell;

#========================================================================
# Program Name: kmigrate - Update Objects from one revision to the next
# Purposed:	long description goes here
#
# RCS ID:	Khoros: $Id$
# RCS Log:	$Log$
#========================================================================

# Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.


if (! defined $ENV{'KHOROS_TOOLBOX'})
{
   die "The KHOROS_TOOLBOX environment variable must be set.\n";
}

$notfound = 1;
foreach $toolbox_file (sort split(/:/, $ENV{'KHOROS_TOOLBOX'}))
{
   open(TBS,"<$toolbox_file") || do
   {
      warn "Can not open $toolbox_file.  Please check to make sure your\n";
      die  "KHOROS_TOOLBOX environment variable points to existing files.\n";
   };

   while (<TBS>)
   {
      chop($_);
      @line = split(':',$_);
      if ($line[0] eq "SUPPORT")
      {
         if ( $notfound )
         {
            $support_path = $line[1];
            $notfound = 0;
         }
         else
         {
            warn "The SUPPORT toolbox is defined twice.  Please check your\n";
            warn "KHOROS_TOOLBOX environment variable and the file(s)\n";
            warn "pointed to by it and make sure that all toolboxes are\n";
            die  "only defined once.\n";
         }
      }
   }
}

if ( $notfound )
{
   print "The SUPPORT toolbox is not defined in any of the files pointed to\n";
   die   "by the environment variable KHOROS_TOOLBOX.\n";
}


@INC = ("$support_path/repos/perl", @INC);
require "khoros.pl";
require "kutils.pl";

#-- Command line arguments
$whatis = 'Update Toolboxes and Objects from one revision to the next';
@clui_args  = (
        '[tb]',     'toolbox',      'name of toolbox',
	'[i]',      'itbl',         'input table',
	'[verbose]', '',	    'Print verbose output',
);

#-- initialize Khoros perl lib
&khoros'initialize("MIGRATION",$whatis,@clui_args);

&khoros'parse_args(@ARGV);                   # parse the command-line

#-- End of Template Code
$allprint = 0;
$allprint = 1 if $khoros'seenswitch{'verbose'};

#-- make sure this points to toolbox kmigrate is currently in
$curtb = "MIGRATION";
@toolboxes = &khoros'get_toolbox_list();

$curtbpath = &khoros'toolbox_path("$curtb");
$table_path = "$curtbpath/objects/script/kmigrate/misc/migrate.cmd";
$table_path = $khoros'argval{'i'} if $khoros'seenswitch{'i'};

die "Cannot open table file '$table_path\n" unless -r $table_path;

#-- Sort lines into correct order to apply patch (sorted by old version value).
@datacom = split(/\n/, `cat $table_path`);
die "Cannot open table file '$table_path\n" if ($? != 0);
@data = grep(!/^#/, @datacom);
$i=0;
foreach (@data)
{
   push(@datakeys, (split(/[\t ]/))[0]);
   push(@datakeys2, $i);
   $i++;
}
@miglines = @data[sort byoldver $[..$#data];

#-- Now split line into component parts
foreach (@miglines)
{
   ($oldver, $newver, $objlist, $cmd, @rest) = (split(/[\t ]+/));
   $cmd1 = &khoros'fullpath($cmd);
   $cmd2 = join(' ', @rest);
   $command = "$cmd1 $cmd2";
   push(@oldvers, $oldver);
   push(@newvers, $newver);
   push(@objlists, $objlist);
   push(@commands, $command);
}

#-- Use migration toolbox version to indicate the current Khoros version
chop ($curver = `kecho -tb migration -echo version`);
die "Cannot get current version of Khoros\n" if ($? != 0 || (! $curver));
push(@oldvers, $oldver);
push(@oldvers, $oldver);
push(@newvers, $curver);
push(@newvers, $curver);
push(@objlists, "*");
push(@objlists, "*::*");
push(@commands, "kset -tb %tbname% -version %curver%");
push(@commands, "kset -tb %tbname% -oname %oname% -version %curver%");
$i=0;
foreach $oldver (@oldvers)
{
   $alltbs = 0;
   $allobjs = 0;
   $anyobjs = 0;
   $objlist = $objlists[$i];
   ($tbstr, $objstr) = split(/::/, $objlist);
   $alltbs = 1 if $tbstr =~ /^\*$/;
   $allobjs = 1 if $objstr =~ /^\*$/;
   $anyobjs = 1 if $objstr =~ /.+/;
   ($commandname, @rest) = split(/[ \t]+/, $commands[$i]);
   $commandname =~ s/(.*\/)?(.+)/$2/;
   @toolop = $alltbs == 1 ? @toolboxes : split(/,/, $tbstr);
   print "Checking for objects to update to '$curver' with command '$commandname'\n";
   foreach $tbname (@toolop)
   {
      $toolbox = "\L$tbname";
      $TOOLBOX = "\U$tbname";
      next unless (grep(/^$TOOLBOX$/i, @toolboxes));
      $tbpath  = $khoros'toolboxPath{$TOOLBOX};
      chop($tbver = `kecho -tb $TOOLBOX -echo version`);
      if ($? != 0 || ( ! $tbver))
      {
	 print "Cannot get version for toolbox '$TOOLBOX'\n";
         next;
      }
      if ( $anyobjs == 0 && (&verval($curver) == &verval($tbver)) )
      {
         print "Toolbox '$TOOLBOX' is up to date.  Skipping....\n" if $allprint == 1;
         next;
      }
#-- Handle each sub-object in the toolbox as per the user's request
      elsif  ( $anyobjs == 1)
      {
	 @onames = split(/\s/, `kecho -tb $tbname -echo objects`);
         if ($? != 0 )
         {
	    print "Cannot get a list of object names for toolbox '$TOOLBOX'\n";
            next;
         }
         @onameop = $allobjs == 1 ? @onames : split(/,/, $objstr);
	 $checkit = 1;
	 foreach $oname (@onameop)
	 {
	    next unless (grep(/^$oname$/, @onames));
	    chop($over = `kecho -tb $tbname -oname $oname -echo version`);
            if ($? != 0 || (! $over))
            {
	       print "Cannot get version for oname '$oname'\n";
	       next;
            }
	    if (&verval($curver) == &verval($over))
	    {
	       print "Object '$oname' is up to date.  Skipping....\n" if $allprint == 1;
	       next;
	    }
	    if ($checkit == 1)
	    {
	       print "Checking for objects to update to '$curver' in toolbox '$TOOLBOX'\n";
	       $checkit = 0;
	    }
	    print "Object '$oname' is at version '$over'.  Updating....\n";
	    $command = $commands[$i];
	    $command =~ s/%tbname%/$toolbox/g;
	    $command =~ s/%oname%/$oname/g;
	    $command =~ s/%curver%/$curver/g;
	    print "$command\n" if ($allprint == 1);
#	    $retval = 0;
            $retval = system($command);
	    if ($retval != 0)
	    {
	       print "Cannot run command '$command' on object '$oname'\n";
	       next;
	    }
	 }
	 next;
      }
      print "Toolbox '$TOOLBOX' is at version '$tbver'.  Updating....\n";
      $command = &khoros'fullpath($commands[$i]);
      $command =~ s/%tbname%/$toolbox/g;
      $command =~ s/%curver%/$curver/g;
      print "$command\n" if ($allprint == 1); 
#      $retval = 0;
      $retval = system($command);
      if ($retval != 0)
      {
	 print "Cannot run command '$command' on toolbox '$tbname'\n";
	 next;
      }
   }
   $i++;
}

# ========================================================================
# Routine Name: byoldver - sort compare function for old version
#
# Purpose:      This function takes is used directly by the sort
#		routine to determine the ordering of the lines in
#		the migration table.  It sorts first by old version,
#		then by order of appearence in the file.
# ========================================================================
sub byoldver
{
   if (&verval($datakeys[$a]) ==  &verval($datakeys[$b]))
   {
      $datakeys2[$a] <=> $datakeys2[$b];
   }
   else
   {
      &verval($datakeys[$a]) <=> &verval($datakeys[$b]);
   }
}

# ========================================================================
# Routine Name: verval - convert a version string into a numerical value
#
# Purpose:      This function turns a 2.x.xx.xx string into a integer
#		2xxxxx, so it can be use in integer comparison.  If the
#		user leaves off parts of the number (eg 2.0 instead of
#		2.0.0.0) it will insert 0's as necessary.
#
# Input:        toolbox - name of the toolbox.
# ========================================================================
sub verval
{
   local($inver) = @_;
   $inver =~ s/\.//g;
   while ($inver < 200000)
   {
      $inver = $inver * 10;
   }
   $inver;
}
