: # use perl
        eval 'exec perl -S $0 "$@"'
                if $runnning_under_some_shell;
#========================================================================
#
# Program Name: kfixpane - pane UIS file fixer-upper
# Purposed:     Fix a pane file to be the standard cantat format
#
# RCS ID:       Khoros: $Id$
# RCS Log:      $Log$
#========================================================================

# Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.

@khoros_toolbox = ('KHOROS_TOOLBOX');
if (! eval("\$toolboxes = \$ENV{\"KHOROS_TOOLBOX\"}"))
{
   die "The KHOROS_TOOLBOX environment variable must be set.\n";
}

$notfound = 1;
@toolbox_list = split(':', $toolboxes);
foreach $toolbox_file (sort(@toolbox_list))
{
   if ( ! open(TBS,"<$toolbox_file"))
   {
      print "Can not open $toolbox_file.  Please check to make sure your\n";
      die   "KHOROS_TOOLBOX environment variable points to existing files.\n";
   }

   while(<TBS>)
   {
      chop($_);
      @line = split(':',$_);
      if ($line[0] eq "SUPPORT")
      {
         if ( $notfound )
         {
            $support_path = $line[1];
            $notfound = 0;
         }
         else
         {
            print "The SUPPORT toolbox is defined twice.  Please check your\n";
            print "KHOROS_TOOLBOX environment variable and the file(s)\n";
            print "pointed to by it and make sure that all toolboxes are\n";
            die   "only defined once.\n";
         }
      }
   }
}

if ( $notfound )
{
   print "The SUPPORT toolbox is not defined in any of the files pointed to\n";
   die   "by the environment variable KHOROS_TOOLBOX.\n";
}
@INC = ("$support_path/repos/perl", @INC);
require "khoros.pl";

#
# kfixpane.pl
#
# A perl script which 'fixes up' Khoros pane UIS files
# to ensure they conform to Khoros style guide and guidelines.
#
# This is kind of kludgey right now, since writing it revealed
# a few deficiencies in the definition of what it is supposed to do.
# watch this space :-)
#
# neilb 5-feb-94


$whatis	= 'fix up pane UIS files';

@kfixpane_args = (
	'tb',		'toolbox',		'name of toolbox',
	'oname',	'object',		'name of object',
	'type',		'object-type',		'type of object',
	'[short-desc]',	'short-description',	'object\'s short description',
	'[backup]',	'back-extension',	'extension for back files',
	'[rpath]',	'-Rpath',		'binary path',
	'[help]',	'help-path',		'path to help file',
	'-',		'pane1 .. paneN',	'pane files to update'
);

# initialize Khoros perl lib
&khoros'initialize("SUPPORT",$whatis,@kfixpane_args);

@panefiles	= &khoros'parse_args(@ARGV);	# parse command line args
$toolbox	= &khoros'get_tb_name;		# get toolbox name
$TOOLBOX	= "\U$toolbox";

$ObjectName	= $khoros'argval{'oname'};
$ObjectType	= 'xvroutine';
$shortDesc	= $khoros'argval{'short-desc'};
$runPath	= $khoros'argval{'rpath'};
$helpPath	= $khoros'argval{'help'};
$bak		= $khoros'argval{'backup'} || 'bak';

die "You must specify at least one pane file on the command line.\n"
							if @panefiles < 1;

&FixPane(shift(@panefiles)) while @panefiles > 0;

# ------------------------------------------------------------
# FixPane()
#	This routine takes a pane file path and fixes it up,
#	invoking the various passes.
# ------------------------------------------------------------
sub FixPane
{
	local($filename) = @_;

	unless (&FirstPass($filename)) {
		print STDERR "First pass failed :-(\n";
		exit 1;
	}

	# always do the second pass, if first pass was successful
	&SecondPass($filename);
}

# ------------------------------------------------------------
# FirstPass()
#	Scan the specified file set flags according to what
#	we find.
# ------------------------------------------------------------
sub FirstPass
{
	local($filename) = @_;

	# initialize flags -- you hain't seen nuthin yet!
	$seenRun = $seenHelp = $seenQuit = $seenOptionsMenu =
					$seenOptionsButton = 0;
	open(PANE,"< $filename") || do {
		print STDERR "Unable to read $filename\n";
		return 0;
	};
	while (<PANE>) {
		if (/^#\s*do\s*not\s*auto\s*update/i) {
			print STDERR "\"do not auto update\" ";
			print STDERR "directive seen -- ";
			print STDERR "file will not be modified.\n";
			exit 0;
		}
		$seenOptionsButton= 1 if /^\s*-a[^']+'Options'/;
		$seenOptionsMenu= 1 if /^\s*-D[^']+'Options'\s*_gui_options/;
		$seenQuit	= 1 if /^\s*-Q/;
		$seenHelp	= 1 if /^\s*-H[^']+.*help\d*\s*$/;
		$seenRun	= 1 if /^\s*-R/;
	}
	close PANE;
	$needUpdate = (!$seenOptionsMenu || !$seenQuit || !$seenHelp ||
			!$seenRun);
	return 1;
}

# ------------------------------------------------------------
# SecondPass()
#	This routine assumes that the first pass has run successfully,
#	and that the various state variables have been set.
#	This routine should not be called if the pane was ok.
# ------------------------------------------------------------
sub SecondPass
{
	local($filename) = @_;
	local($newfilename) = "$filename.new";
	local($ingroup,$inmenu);

	# open the pane we're gonna convert
	open(PANE,"< $filename") || do {
		print STDERR "kfixpane: can't read $filename [2nd [pass]\n";
		return 0;
	};

	# open a <pane>.new file for the updated pane
	open(NEWPANE,"> $newfilename") || do {
		print STDERR "kfixpane: can't write $newfilename\n";
		print STDERR "                 $filename won't be updated.\n";
		close PANE;
		return 0;
	};

	$ingroup = $inmenu = 0;
	# iterate over the original pane
	while (<PANE>) {

		# do we want to ignore the line?
		# ----------------------------------------

		# get rid of options button -- we're gonna put in a menu (-D)
		next if /^\s*-a[^']+'Options'.*options\s*$/;

		# ignore the copyright line, we add one to the options menu
		next if /^\s*-H[^']+'([^']+)'.*copyright\s*$/ &&
					$1 =~ /^copyright/ii && $inmenu == 0;

		$ingroup++ if /^\s*-[CBKT]/;
		$ingroup-- if /^\s*-E/ && $ingroup > 0;
		$inmenu++ if /^\s*-D/;
		$inmenu-- if /^\s*-E/ && $inmenu > 0;

		# check whether we need to modify the line
		# ----------------------------------------

		if (/^(\s*-M)\s+(\d+)\s+(\d+)\s+(\S+)\s+\+([^+]+)\+\S+\s+'([^']+)'\s+(.*)\s*$/) {
			$shortDesc = $6 unless $shortDesc ne "";
			$_ = "$1 $2 $3 $4 +$5+0 '$shortDesc' $7\n";
		}

		# make sure the -Q says 'Close'
		if ( /^(\s*-Q)\s+(\d+)\s+(\d+)\s+\S+\s+'([^']+)'\s*$/ ) {
			$_ = "$1 $2 $3 5x1+47+0 'Close'\n";

			# old kludgey approach.  ok, more kludgey :-)
			# $_ = "$1'Close'\n" if $2 ne 'Close';
		}

		# make sure the -R says 'Run'
		if (/^(\s*-R)\s+(\d+)\s+(\d+)\s+(\d+)\s+\S+\s+'[^']+'\s+('[^']+')\s+(.*)\s*$/) {
			if ($runPath ne "") {
				$_ = "$1 $2 $3 $4 5x1+35+0 'Run' $5 $runPath\n";
			} else {
				$_ = "$1 $2 $3 $4 5x1+35+0 'Run' $5 $6\n";
			}

			# $_ = "$1'Run'$3\n" if $2 ne 'Run';
		}

		# make sure the -H says 'Help'
		if (/^(\s*-H)\s+(\d+)\s+\S+\s+'[^']+'\s+'([^']+)'\s+(\S+)\s+(.*help\d*)$/) {
			if ($helpPath ne "") {
				$_ = "$1 $2 5x1+41+0 'Help' '$3' $helpPath $5\n";
			} else {
				$_ = "$1 $2 5x1+41+0 'Help' '$3' $4 $5\n";
			}

			# $_ = "$1'Help'$3\n" if $2 ne 'Help';
		}

		# get the geometry right on -I and -O lines
		if ( /^(\s*-[IO])\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+[^x]+x[^+]+\+[^+]+\+(\S+)\s+(.*)$/ ) {
			$_ = "$1 $2 $3 $4 $5 $6 $7 52x1+0+$8 $9\n" unless
								$ingroup;
		}

		# get the right geometry on -P lines
		if ( /^(\s*-F)\s+(\S+)\s+/ ) {
			$_ = "-F $2 1 0 52x1+0+0 +0+0 'Cantata' cantata\n";
		}

		# get the right geometry on -P lines
		if ( /^(\s*-M)\s+(\d+)\s+(\d+)\s+\S+\s+\S+\s+(.*)$/ ) {
			$_ = "$1 1 1 52x1+0+0 +1+0 $4\n";
		}

		# get the right geometry on -P lines
		if ( /^(\s*-P)\s+(\d+)\s+(\d+)\s+\S+\s+(.*)$/ ) {
			$_ = "$1 $2 $3 52x1+0+1 $4\n";
		}

		# print out the line
		print NEWPANE;

		# after printing the line, are there any lines which need
		# need to be added?
		&AddMissingLines() if /^\s*-P/;
	}
	close PANE;
	close NEWPANE;

	rename($filename,"$filename.$bak") || do {
		print STDERR "Couldn't rename $filename to $filename.$bak\n";
		print STDERR "The updated pane is in $newfilename\n";
		return 0;
	};

	rename($newfilename,$filename) || do {
		print STDERR "Couldn't rename $newfilename to $filename\n";
		print STDERR "The updated pane is in $newfilename\n";
		return 0;
	};

	return 1;
}

# ------------------------------------------------------------
# AddMissingLines()
#	This routine adds any lines which do not exist in the
#	original pane file.
#
#	This routine is ugly, but does the work.  A few things need
#	to be resolved before cleaning this up.
# ------------------------------------------------------------
sub AddMissingLines
{
	$indent = '      ';
	$ObjectPath = "\$$TOOLBOX/objects/$ObjectType/$ObjectName";

	# do we need to add a QUIT button (-Q line)?
	print NEWPANE "$indent-Q 1 0 5x1+47+0 'Close'\n" unless $seenQuit;

	# do we need to add a RUN button (-R line)?
	# we'll assume not! ;-)
	# unless ($seenRun) {
	#	print NEWPANE "$indent-R 1 0 1 5x1+35+0 'Run' ";
	#	print NEWPANE "'execute $ObjectName' ";
	#	if ($runPath ne "") {
	#		print NEWPANE "$runPath\n";
	#	} else {
	#		print NEWPANE "\$${TOOLBOX}BIN/$ObjectName\n";
	#	}
	# }

	# do we need to add a HELP button (-H line)?
	unless ($seenHelp) {
		print NEWPANE "$indent-H 1 5x1+41+0 'Help' ";
		print NEWPANE "'help page for $ObjectName' ";
		if ($helpPath ne "") {
			print NEWPANE "$helpPath\n";
		} else {
			print NEWPANE "$ObjectPath/help help\n";
		}
	}

	# do we need to add an options menu?
	unless ($seenOptionsMenu) {
		print NEWPANE "$indent-D 1 0 9x1+0+0 'Options' _gui_options\n";
		print NEWPANE "$indent  -H 1 6x1+0+0 'Copyright' '(C)' ";
		print NEWPANE	"\$$TOOLBOX/repos/copyright/Copyright ";
		print NEWPANE	"copyright\n";
		print NEWPANE "$indent-E\n";
	}
}
