 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kdarwin
   >>>> 
   >>>>    Written By: Steven Jorgensen
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kdarwin_h_
#define _kdarwin_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <migration.h>

/* -include_includes */
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$MIGRATION/objects/kroutine/kdarwin/uis/kdarwin.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Toolbox object to hold the new software object (required string)
 */
char	*tb_string;	/* Toolbox object to hold the new software object STRING */
int	 tb_flag;   	/* Toolbox object to hold the new software object FLAG */

/*
 *  Software object name to use the for the converted vroutine (required string)
 */
char	*oname_string;	/* Software object name to use the for the converted vroutine STRING */
int	 oname_flag;   	/* Software object name to use the for the converted vroutine FLAG */

/*
 *  Category Name used in Cantata (required string)
 */
char	*cat_string;	/* Category Name used in Cantata STRING */
int	 cat_flag;   	/* Category Name used in Cantata FLAG */

/*
 *  Subcategory Name used in Cantata (required string)
 */
char	*subcat_string;	/* Subcategory Name used in Cantata STRING */
int	 subcat_flag;   	/* Subcategory Name used in Cantata FLAG */

/*
 *  The short description of the object (required string)
 */
char	*description_string;	/* The short description of the object STRING */
int	 description_flag;   	/* The short description of the object FLAG */

/*
 *  Icon Name used for glyph in Cantata (required string)
 */
char	*icon_string;	/* Icon Name used for glyph in Cantata STRING */
int	 icon_flag;   	/* Icon Name used for glyph in Cantata FLAG */

/*----- required ME group ----*/
	/*---- nested optional MI group ----*/
/*
 *  Khoros 1.0 Prog filename to get program code and documentation information from (optional infile)
 */
char	*prog_file;	/* Khoros 1.0 Prog filename to get program code and documentation information from FILENAME */
int	 prog_flag;	/* Khoros 1.0 Prog filename to get program code and documentation information from FLAG */

/*
 *  Khoros 1.0 Pane Filename to get program uis information from (optional infile)
 */
char	*pane_file;	/* Khoros 1.0 Pane Filename to get program uis information from FILENAME */
int	 pane_flag;	/* Khoros 1.0 Pane Filename to get program uis information from FLAG */

	/*-- nested optional MI group end --*/

/*
 *  Khoros 1.0 conf filename to use to get paths for *.pane and *.prog (optional infile)
 */
char	*conf_file;	/* Khoros 1.0 conf filename to use to get paths for *.pane and *.prog FILENAME */
int	 conf_flag;	/* Khoros 1.0 conf filename to use to get paths for *.pane and *.prog FLAG */

/*-- required ME group end ---*/

/*
 *  Library object to put the vroutine l*.c file into (optional string)
 */
char	*lname_string;	/* Library object to put the vroutine l*.c file into STRING */
int	 lname_flag;   	/* Library object to put the vroutine l*.c file into FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kdarwin_get_args PROTO((kform *));
void kdarwin_usage_additions PROTO((void));
void kdarwin_free_args PROTO((int, kaddr));

/* -include_routines */
int uis_replace_update PROTO((kobject, char *));
int uis_cantata_update PROTO((kobject, char *));
kobject ghost_it PROTO((kobject));
int kfix_it PROTO((char *));
int protoize_it PROTO((kobject, kobject));
/* -include_routines_end */

#endif
