#! /bin/sh

echo "running test1.sh for mscalar_XXX ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb MATRIX -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1: mscalar_add
# ------------------------------------------------------------------------
test_num=1
descr="mscalar_add"
cat <<EOF > $tmpdir/ascii.$$
1 0 0
0 2 0
0 0 4
EOF
mscalar_add -i1 $tmpdir/ascii.$$ -real 1.0 -o $tmpdir/out.$$
cat <<EOF > $tmpdir/ascii.$$
2 1 1
1 3 1
1 1 5
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  2: mscalar_sub
# ------------------------------------------------------------------------
test_num=2
descr="mscalar_sub"
cat <<EOF > $tmpdir/ascii.$$
1 0 0
0 2 0
0 0 4
EOF
mscalar_sub -i1 $tmpdir/ascii.$$ -real 1.0 -o $tmpdir/out.$$
cat <<EOF > $tmpdir/ascii.$$
0 -1 -1
-1 1 -1
-1 -1 3
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$


# ------------------------------------------------------------------------
# Test  3: mscalar_mul
# ------------------------------------------------------------------------
test_num=3
descr="mscalar_mul"
cat <<EOF > $tmpdir/ascii.$$
1 0 0
0 2 0
0 0 4
EOF
mscalar_mul -i1 $tmpdir/ascii.$$ -real 2.5 -o $tmpdir/out.$$
cat <<EOF > $tmpdir/ascii.$$
2.5 0 0
0 5 0
0 0 10
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  4: mscalar_div
# ------------------------------------------------------------------------
test_num=4
descr="mscalar_div"
cat <<EOF > $tmpdir/ascii.$$
2.5 0 -2.5
0 5 0
0 0 10
EOF
mscalar_div -i1 $tmpdir/ascii.$$ -real 2.5 -o $tmpdir/out.$$
cat <<EOF > $tmpdir/ascii.$$
1 0 -1 
0 2 0
0 0 4
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  5: mscalar_abs
# ------------------------------------------------------------------------
test_num=5
descr="mscalar_abs"
cat <<EOF > $tmpdir/ascii.$$
2.5 0 -2.5
0.031 5 -1
-5.3e10 0 10
EOF
mscalar_abs -i $tmpdir/ascii.$$ -o $tmpdir/out.$$
cat <<EOF > $tmpdir/ascii.$$
2.5 0 2.5
0.031 5 1
5.3e10 0 10
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  6: mscalar_pow
# ------------------------------------------------------------------------
test_num=6
descr="mscalar_pow"
cat <<EOF > $tmpdir/ascii.$$
1 2 3
.5 .1 0
-1 2.0e4 -.5
EOF
mscalar_pow -i1 $tmpdir/ascii.$$ -real 2 -o $tmpdir/out.$$
cat <<EOF > $tmpdir/ascii.$$
1 4 9
.25 .01 0
1 4.0e8 .25
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  7: mscalar_recip
# ------------------------------------------------------------------------
test_num=7
descr="mscalar_recip"
cat <<EOF > $tmpdir/ascii.$$
1 2 3
.5 .1 -1.0e-10
-1 2.0e4 -.5
EOF
mscalar_recip -i $tmpdir/ascii.$$ -o $tmpdir/out.$$
cat <<EOF > $tmpdir/ascii.$$
1 .5 .3333333333333
2 10 -1e10
-1 5.0e-5 -2
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  8: mscalar_sqrt
# ------------------------------------------------------------------------
test_num=8
descr="mscalar_sqrt"
cat <<EOF > $tmpdir/ascii.$$
1 4.4 9
0.5 0 100
.11111111111 2 169
EOF
mscalar_sqrt -i $tmpdir/ascii.$$ -o $tmpdir/out.$$
cat <<EOF > $tmpdir/ascii.$$
1 2.0976177 3
.70710678 0 10
.33333333333 1.4142136 13
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$


exit $status

