#! /bin/sh

echo "running test1.sh for mpow ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb MATRIX -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1: real, power of zero
# ------------------------------------------------------------------------
test_num=1
descr="real, power of zero"
cat <<EOF > $tmpdir/ascii.$$
1 1 1
0 2 0
3 0 4
EOF
mpow -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -pow 0
cat <<EOF > $tmpdir/ascii.$$
1 1 1
1 1 1
1 1 1
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  2: real, power of one
# ------------------------------------------------------------------------
test_num=2
descr="real, power of one"
cat <<EOF > $tmpdir/ascii.$$
1 1 1
0 2 0
3 0 4
EOF
mpow -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -pow 1
cat <<EOF > $tmpdir/ascii.$$
1 1 1
0 2 0
3 0 4
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  3: real, power of two
# ------------------------------------------------------------------------
test_num=3
descr="real, power of two"
cat <<EOF > $tmpdir/ascii.$$
1 1 1
0 2 0
3 0 4
EOF
mpow -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -pow 2
cat <<EOF > $tmpdir/ascii.$$
4 3 5
0 4 0
15 3 19
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  4: real, power of ten
# ------------------------------------------------------------------------
test_num=4
descr="real, power of ten"
cat <<EOF > $tmpdir/ascii.$$
1 1 3
4 2 -2
-3 0 4
EOF
mpow -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -pow 10
cat <<EOF > $tmpdir/ascii.$$
      154247       53553        9451
      -12600     -132418     -333918
       66153      113406      239302
EOF
report $test_num "$tmpdir/out.$$" "$tmpdir/ascii.$$" "$descr"
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$



exit $status

