 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Library Routine for mexchg
   >>>> 
   >>>>  Private: 
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 	lmexchg
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"

/* -library_includes */
/* -library_includes_end */


/****************************************************************
* 
*  Routine Name: lmexchg - exchange rows and/or columns of a matrix
* 
*       Purpose: lmexchg can exchange one pair of rows and one pair
*                of columns of a matrix. If only a column exchange is
*                desired, then the indices of the rows to be exchanged be
*                set to the same value (i.e. exchange a row with itself).
*                Likewise if only a row exchange is desired, set the
*                column indices to the same number.
*
*                Row exchanges are done before column exchanges.
*
*                The exchange operation will take place across all planes
*                of (DxTxE) data. The actual data is copied as (for a row
*                exchange) a WxDxTxE hyperplane. It is implicitly assumed
*                that this hyperplane will easily fit in memory. Columns
*                are copied as HxDxTxE hyperplanes under the same assumption.
*
*         Input: in_obj - input matrix object
*                r1 - index of first row to be exchanged
*                r2 - index of second row to be exchanged
*                c1 - index of first column to be exchanged
*                c2 - index of second column to be exchanged
*
*        Output: kobject out_obj - output matrix object
*
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: Restrictions on data or input as applicable
*    Written By: Scott Wilson
*          Date: Apr 08, 1995
*      Verified: 
*  Side Effects: 
* Modifications: 
****************************************************************/
/* -library_def */
int lmexchg( kobject in_obj, int r1, int r2, int c1, int c2, kobject out_obj)
/* -library_def_end */

/* -library_code */
{
        char *lib = "kmatrix", *rtn = "lmexchg";
        double *rvec=NULL,*cvec=NULL,*tcvec=NULL;
        kdcomplex *rvecZ=NULL,*cvecZ=NULL,*tcvecZ=NULL;
        int type,itype,otype;
        int w,h,d,t,e;
        klist *objlist=NULL;

        /* Make sure we have valid objects */
        if (in_obj == KOBJECT_INVALID)
          {
            kerror(lib, rtn, "Bogus input object");
            return(FALSE);
          }
        if (out_obj == KOBJECT_INVALID)
          {
            kerror(lib, rtn, "Bogus output object");
            return(FALSE);
          }

        /* Reference the input object to avoid side effects, then add the
           references to the list of goodies to be autmatically free'd on
           error. */
        KCALL((in_obj = kpds_reference_object(in_obj)));
        objlist = klist_add(objlist,in_obj,"KOBJECT");

        /* Figure out if we should act real or complex */
        KCALL(kpds_get_attribute(in_obj,KPDS_VALUE_DATA_TYPE,&type));
        if (type == KCOMPLEX || type == KDCOMPLEX )
          {
            itype = KDCOMPLEX;
            otype = KDCOMPLEX;
          }
        else
          {
            itype = KDOUBLE;
            otype = KDOUBLE;
          }

        /* Constrain the input data to double real or double complex for read */
        KCALL(kpds_set_attribute(in_obj,KPDS_VALUE_DATA_TYPE, itype));

        /* See what size the data is */
        KCALL(kpds_get_attribute(in_obj,KPDS_VALUE_SIZE,&w,&h,&d,&t,&e));

        /* Set the output object size and data type, and copy the value data */
        if (!kpds_query_value(out_obj)) KCALL(kpds_create_value(out_obj));
        KCALL(kpds_set_attributes(out_obj,
                             KPDS_VALUE_SIZE,w,h,d,t,e,
                             KPDS_VALUE_DATA_TYPE,otype,NULL));
        KCALL((out_obj = kpds_reference_object(out_obj)));
        objlist = klist_add(objlist,out_obj,"KOBJECT");
        KCALL(kpds_copy_value_data(in_obj,out_obj,TRUE));

        /* Do the row exchange */
        KCALL(kpds_set_attribute(in_obj,KPDS_VALUE_REGION_SIZE,w,1,d,t,e));
        KCALL(kpds_set_attribute(out_obj,KPDS_VALUE_REGION_SIZE,w,1,d,t,e));
        if (otype == KDOUBLE)
          {
            KCALL(!((rvec=(double *)kmalloc(w*d*t*e*sizeof(double))) == NULL));
            KCALL(kpds_set_attribute(in_obj,KPDS_VALUE_POSITION,0,r1,0,0,0));
            rvec = (double *)kpds_get_data(in_obj,KPDS_VALUE_REGION,(kaddr)rvec);
            KCALL(kpds_set_attribute(out_obj,KPDS_VALUE_POSITION,0,r2,0,0,0));
            KCALL(kpds_put_data(out_obj,KPDS_VALUE_REGION,(kaddr)rvec));

            KCALL(kpds_set_attribute(in_obj,KPDS_VALUE_POSITION,0,r2,0,0,0));
            rvec = (double *)kpds_get_data(in_obj,KPDS_VALUE_REGION,(kaddr)rvec);
            KCALL(kpds_set_attribute(out_obj,KPDS_VALUE_POSITION,0,r1,0,0,0));
            KCALL(kpds_put_data(out_obj,KPDS_VALUE_REGION,(kaddr)rvec));
            kfree(rvec);
          }
        else
          {
            KCALL(!((rvecZ=(kdcomplex *)kmalloc(w*d*t*e*sizeof(kdcomplex))) == NULL));
            KCALL(kpds_set_attribute(in_obj,KPDS_VALUE_POSITION,0,r1,0,0,0));
            rvecZ = (kdcomplex *)kpds_get_data(in_obj,KPDS_VALUE_REGION,(kaddr)rvecZ);
            KCALL(kpds_set_attribute(out_obj,KPDS_VALUE_POSITION,0,r2,0,0,0));
            KCALL(kpds_put_data(out_obj,KPDS_VALUE_REGION,(kaddr)rvecZ));

            KCALL(kpds_set_attribute(in_obj,KPDS_VALUE_POSITION,0,r2,0,0,0));
            rvecZ = (kdcomplex *)kpds_get_data(in_obj,KPDS_VALUE_REGION,(kaddr)rvecZ);
            KCALL(kpds_set_attribute(out_obj,KPDS_VALUE_POSITION,0,r1,0,0,0));
            KCALL(kpds_put_data(out_obj,KPDS_VALUE_REGION,(kaddr)rvecZ));
            kfree(rvecZ);
          }

        /* Do the column exchange */
        KCALL(kpds_set_attribute(out_obj,KPDS_VALUE_REGION_SIZE,1,h,d,t,e));
        if (otype == KDOUBLE)
          {
            KCALL(!((cvec=(double *)kmalloc(h*d*t*e*sizeof(double))) == NULL));
            KCALL(!((tcvec=(double *)kmalloc(h*d*t*e*sizeof(double))) == NULL));
            KCALL(kpds_set_attribute(out_obj,KPDS_VALUE_POSITION,c1,0,0,0,0));
            cvec = (double *)kpds_get_data(out_obj,KPDS_VALUE_REGION,(kaddr)cvec);
            KCALL(kpds_set_attribute(out_obj,KPDS_VALUE_POSITION,c2,0,0,0,0));
            tcvec = (double *)kpds_get_data(out_obj,KPDS_VALUE_REGION,(kaddr)tcvec);
            KCALL(kpds_set_attribute(out_obj,KPDS_VALUE_POSITION,c2,0,0,0,0));
            KCALL(kpds_put_data(out_obj,KPDS_VALUE_REGION,(kaddr)cvec));
            KCALL(kpds_set_attribute(out_obj,KPDS_VALUE_POSITION,c1,0,0,0,0));
            KCALL(kpds_put_data(out_obj,KPDS_VALUE_REGION,(kaddr)tcvec));
            kfree(cvec);
            kfree(tcvec);
          }
        else
          {
            KCALL(!((cvecZ=(kdcomplex *)kmalloc(h*d*t*e*sizeof(kdcomplex))) == NULL));
            KCALL(!((tcvecZ=(kdcomplex *)kmalloc(h*d*t*e*sizeof(kdcomplex))) == NULL));
            KCALL(kpds_set_attribute(out_obj,KPDS_VALUE_POSITION,c1,0,0,0,0));
            cvecZ = (kdcomplex *)kpds_get_data(out_obj,KPDS_VALUE_REGION,(kaddr)cvecZ);
            KCALL(kpds_set_attribute(out_obj,KPDS_VALUE_POSITION,c2,0,0,0,0));
            tcvecZ = (kdcomplex *)kpds_get_data(out_obj,KPDS_VALUE_REGION,(kaddr)tcvecZ);
            KCALL(kpds_set_attribute(out_obj,KPDS_VALUE_POSITION,c2,0,0,0,0));
            KCALL(kpds_put_data(out_obj,KPDS_VALUE_REGION,(kaddr)cvecZ));
            KCALL(kpds_set_attribute(out_obj,KPDS_VALUE_POSITION,c1,0,0,0,0));
            KCALL(kpds_put_data(out_obj,KPDS_VALUE_REGION,(kaddr)tcvecZ));
            kfree(cvecZ);
            kfree(tcvecZ);
          }

        (void)klist_free(objlist, (kfunc_void)lkcall_free);

	return TRUE;
}
/* -library_code_end */
