 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for mrcsum
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "mrcsum.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Compute Row or Column Sums for a Matrix
|
|       Purpose: main program for mrcsum
|
|         Input:
|		char *clui_info->i_file; {Input matrix object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		int clui_info->scale_toggle; {scale by 1, 1/N or 1/(N-1)}
|		int clui_info->scale_flag; {TRUE if -scale specified}
|
|		char *clui_info->or_file; {Row sum output object}
|		int   clui_info->or_flag; {TRUE if -or specified}
|
|		char *clui_info->oc_file; {Column sum output object}
|		int   clui_info->oc_flag; {TRUE if -oc specified}
|
|        Output:
|       Returns:
|
|    Written By: Scott Wilson
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
kobject in_obj = NULL;
kobject rowsum_obj = NULL;
kobject colsum_obj = NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "MATRIX");
	kexit_handler(mrcsum_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "MATRIX", "mrcsum",
		mrcsum_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	mrcsum_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((in_obj = kpds_open_input_object(clui_info->i_file))
                == KOBJECT_INVALID)
        {
           kerror("mrcsum","main", "Cannot open input object.");
           kexit(KEXIT_FAILURE);
        }
 
       if (clui_info->or_flag != 0)
         {
           if ((rowsum_obj = kpds_open_output_object(clui_info->or_file))
                     == KOBJECT_INVALID)
             {
                kerror("mrcsum","main", "Cannot open output object.");
                kexit(KEXIT_FAILURE);
             }
           if (!kpds_copy_object_attr(in_obj, rowsum_obj))
             {
               kerror("mrcsum","main",
               "Unable to copy attributes from input to rowsum output object.");
               kexit(KEXIT_FAILURE);
             }
         }

       if (clui_info->oc_flag != 0)
         {
           if ((colsum_obj = kpds_open_output_object(clui_info->oc_file))
                     == KOBJECT_INVALID)
             {
                kerror("mrcsum","main", "Cannot open output object.");
                kexit(KEXIT_FAILURE);
             }
           if (!kpds_copy_object_attr(in_obj, colsum_obj))
             {
               kerror("mrcsum","main",
               "Unable to copy attributes from input to colsum output object.");
               kexit(KEXIT_FAILURE);
             }
         }
/* -main_before_lib_call_end */

/* -main_library_call */
        if (!lmrcsum(in_obj,clui_info->scale_toggle,
                            rowsum_obj,colsum_obj)) kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
       if (clui_info->or_flag != 0)
         {
            if (!kpds_set_attribute(rowsum_obj,KPDS_HISTORY,kpds_history_string()))
              {
                kerror("mrcsum", "main","Unable to set history on rowsum object");
                kexit(KEXIT_FAILURE);
              }
            kpds_close_object(rowsum_obj);
        }
       if (clui_info->oc_flag != 0)
         {
            if (!kpds_set_attribute(colsum_obj,KPDS_HISTORY,kpds_history_string()))
              {
                kerror("mrcsum", "main","Unable to set history on colsum object");
                kexit(KEXIT_FAILURE);
              }
            kpds_close_object(colsum_obj);
        }
        kpds_close_object(in_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: mrcsum_usage_additions
| 
|       Purpose: Prints usage additions in mrcsum_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname mrcsum
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void mrcsum_usage_additions(void)
{
	kfprintf(kstderr, "\tCompute Row or Column Sums for a Matrix\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: mrcsum_free_args
| 
|       Purpose: Frees CLUI struct allocated in mrcsum_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname mrcsum
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
mrcsum_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->or_file);
	kfree(clui_info->oc_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
