#! /bin/sh

# Replace oname and file.sh in the two lines below with the name 
# of the program you are testing and the file name of this test 
# (for example, test1.sh).

object_name="ifilt_design"
file_name="test1.sh"

# ---------------------------------------------------------------
# ADD TESTS BETWEEN the  "Add tests below this" and "End of test 
# suite" comment lines (line 60).
# ---------------------------------------------------------------

echo "running "$file_name" for "$object_name" ... process ($$)"

# report utility
# ---------------------------------------------------------------
# Usage:  report  test_num test_obj cntrl_obj test_descr tol
#
# The report function uses ksegcmp to compare the test output 
# data object ($2) against the correct result ($3), and reports 
# success or failure of the test.  If the result of ksegcmp is 
# false, status is set to 1.
#
# Input Arguments: test_num - test number
#                  test_obj - the object generated by the test
#                  cntrl_obj - known result to compare against
#                  test_descr - a string describing the test
#                  tol - tolerance allowed when comparing object 
#                        data values. Recommended tolerance 1e-5
# ---------------------------------------------------------------
report()
{
   test_num="$1"
   test_obj="$2"
   cntrl_obj="$3"
   test_descr="$4"
   tol="$5"

   ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol "$tol" -sat 1 -s -rt 1 -all
   if [ $? = 0 ]
   then
      echo "Passed:  Test  $test_num --> "$test_descr""
   else
      echo "FAILED:  Test  $test_num --> "$test_descr""
      status=1
   fi
}

# Initialize status to be success (ie. 0).  Upon failure, status 
# is initialized to 1.  Set the tmpdir variable.  Script will 
# use /tmp if $TMPDIR is not defined.
status=0
tmpdir=${TMPDIR:-/tmp}

# ---------------------------------------------------------------
#  Add tests below this
# ---------------------------------------------------------------

# -- test 01 ----------------------------------------------------
test_num=1
descr="-wsize 10 -hsize 10 -ideal -ucutoff 0.1 -lp"
# ifilt_design -o tst.01 -wsize 10 -hsize 10 -ideal -ucutoff 0.1 -lp
ifilt_design -o $tmpdir/tst.01.$$ -wsize 10 -hsize 10 -ideal -ucutoff 0.1 -lp
kstats -i $tmpdir/tst.01.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.01.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.01.$$ $tmpdir/stats.$$

# -- test 02 ----------------------------------------------------
test_num=2
descr="-wsize 10 -hsize 10 -ideal -lcutoff 0.4 -hp"
# ifilt_design -o tst.02 -wsize 10 -hsize 10 -ideal -lcutoff 0.4 -hp
ifilt_design -o $tmpdir/tst.02.$$ -wsize 10 -hsize 10 -ideal -lcutoff 0.4 -hp
kstats -i $tmpdir/tst.02.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.02.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.02.$$ $tmpdir/stats.$$

# -- test 03 ----------------------------------------------------
test_num=3
descr="-wsize 10 -hsize 10 -ideal -lcutoff 0.2 -ucutoff 0.3 -bp"
# ifilt_design -o tst.03 -wsize 10 -hsize 10 -ideal -lcutoff 0.2 -ucutoff 0.3 -bp
ifilt_design -o $tmpdir/tst.03.$$ -wsize 10 -hsize 10 -ideal -lcutoff 0.2 -ucutoff 0.3 -bp
kstats -i $tmpdir/tst.03.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.03.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.03.$$ $tmpdir/stats.$$

# -- test 04 ----------------------------------------------------
test_num=4
descr="-wsize 10 -hsize 10 -ideal -lcutoff 0.2 -ucutoff 0.3 -bs"
# ifilt_design -o tst.04 -wsize 10 -hsize 10 -ideal -lcutoff 0.2 -ucutoff 0.3 -bs
ifilt_design -o $tmpdir/tst.04.$$ -wsize 10 -hsize 10 -ideal -lcutoff 0.2 -ucutoff 0.3 -bs
kstats -i $tmpdir/tst.04.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.04.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.04.$$ $tmpdir/stats.$$

# -- test 05 ----------------------------------------------------
test_num=5
descr="-wsize 10 -hsize 10 -but -order 2 -ucutoff 0.1 -lp"
# ifilt_design -o tst.05 -wsize 10 -hsize 10 -but -order 2 -ucutoff 0.1 -lp
ifilt_design -o $tmpdir/tst.05.$$ -wsize 10 -hsize 10 -but -order 2 -ucutoff 0.1 -lp
kstats -i $tmpdir/tst.05.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.05.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.05.$$ $tmpdir/stats.$$

# -- test 06 ----------------------------------------------------
test_num=6
descr="-wsize 10 -hsize 10 -but -order 2 -lcutoff 0.4 -hp"
# ifilt_design -o tst.06 -wsize 10 -hsize 10 -but -order 2 -lcutoff 0.4 -hp
ifilt_design -o $tmpdir/tst.06.$$ -wsize 10 -hsize 10 -but -order 2 -lcutoff 0.4 -hp
kstats -i $tmpdir/tst.06.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.06.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.06.$$ $tmpdir/stats.$$

# -- test 07 ----------------------------------------------------
test_num=7
descr="-wsize 10 -hsize 10 -but -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp"
# ifilt_design -o tst.07 -wsize 10 -hsize 10 -but -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp
ifilt_design -o $tmpdir/tst.07.$$ -wsize 10 -hsize 10 -but -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp
kstats -i $tmpdir/tst.07.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.07.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.07.$$ $tmpdir/stats.$$

# -- test 08 ----------------------------------------------------
test_num=8
descr="-wsize 10 -hsize 10 -but -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs"
# ifilt_design -o tst.08 -wsize 10 -hsize 10 -but -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs
ifilt_design -o $tmpdir/tst.08.$$ -wsize 10 -hsize 10 -but -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs
kstats -i $tmpdir/tst.08.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.08.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.08.$$ $tmpdir/stats.$$

# -- test 09 ----------------------------------------------------
test_num=9
descr="-wsize 10 -hsize 10 -exp -order 2 -ucutoff 0.1 -lp"
# ifilt_design -o tst.09 -wsize 10 -hsize 10 -exp -order 2 -ucutoff 0.1 -lp
ifilt_design -o $tmpdir/tst.09.$$ -wsize 10 -hsize 10 -exp -order 2 -ucutoff 0.1 -lp
kstats -i $tmpdir/tst.09.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.09.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.09.$$ $tmpdir/stats.$$

# -- test 10 ----------------------------------------------------
test_num=10
descr="-wsize 10 -hsize 10 -exp -order 2 -lcutoff 0.4 -hp"
# ifilt_design -o tst.10 -wsize 10 -hsize 10 -exp -order 2 -lcutoff 0.4 -hp
ifilt_design -o $tmpdir/tst.10.$$ -wsize 10 -hsize 10 -exp -order 2 -lcutoff 0.4 -hp
kstats -i $tmpdir/tst.10.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.10.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.10.$$ $tmpdir/stats.$$

# -- test 11 ----------------------------------------------------
test_num=11
descr="-wsize 10 -hsize 10 -exp -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp"
# ifilt_design -o tst.11 -wsize 10 -hsize 10 -exp -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp
ifilt_design -o $tmpdir/tst.11.$$ -wsize 10 -hsize 10 -exp -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp
kstats -i $tmpdir/tst.11.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.11.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.11.$$ $tmpdir/stats.$$

# -- test 12 ----------------------------------------------------
test_num=12
descr="-wsize 10 -hsize 10 -exp -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs"
# ifilt_design -o tst.12 -wsize 10 -hsize 10 -exp -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs
ifilt_design -o $tmpdir/tst.12.$$ -wsize 10 -hsize 10 -exp -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs
kstats -i $tmpdir/tst.12.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.12.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.12.$$ $tmpdir/stats.$$

# -- test 13 ----------------------------------------------------
test_num=13
descr="-wsize 10 -hsize 10 -ch1 -order 2 -ucutoff 0.1 -lp"
# ifilt_design -o tst.13 -wsize 10 -hsize 10 -ch1 -order 2 -ucutoff 0.1 -lp
ifilt_design -o $tmpdir/tst.13.$$ -wsize 10 -hsize 10 -ch1 -order 2 -ucutoff 0.1 -lp
kstats -i $tmpdir/tst.13.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.13.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.13.$$ $tmpdir/stats.$$

# -- test 14 ----------------------------------------------------
test_num=14
descr="-wsize 10 -hsize 10 -ch1 -order 2 -lcutoff 0.4 -hp"
# ifilt_design -o tst.14 -wsize 10 -hsize 10 -ch1 -order 2 -lcutoff 0.4 -hp
ifilt_design -o $tmpdir/tst.14.$$ -wsize 10 -hsize 10 -ch1 -order 2 -lcutoff 0.4 -hp
kstats -i $tmpdir/tst.14.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.14.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.14.$$ $tmpdir/stats.$$

# -- test 15 ----------------------------------------------------
test_num=15
descr="-wsize 10 -hsize 10 -ch1 -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp"
# ifilt_design -o tst.15 -wsize 10 -hsize 10 -ch1 -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp
ifilt_design -o $tmpdir/tst.15.$$ -wsize 10 -hsize 10 -ch1 -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp
kstats -i $tmpdir/tst.15.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.15.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.15.$$ $tmpdir/stats.$$

# -- test 16 ----------------------------------------------------
test_num=16
descr="-wsize 10 -hsize 10 -ch1 -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs"
# ifilt_design -o tst.16 -wsize 10 -hsize 10 -ch1 -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs
ifilt_design -o $tmpdir/tst.16.$$ -wsize 10 -hsize 10 -ch1 -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs
kstats -i $tmpdir/tst.16.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.16.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.16.$$ $tmpdir/stats.$$

# -- test 17 ----------------------------------------------------
test_num=17
descr="-wsize 10 -hsize 10 -ch2 -order 2 -ucutoff 0.1 -lp"
# ifilt_design -o tst.17 -wsize 10 -hsize 10 -ch2 -order 2 -ucutoff 0.1 -lp
ifilt_design -o $tmpdir/tst.17.$$ -wsize 10 -hsize 10 -ch2 -order 2 -ucutoff 0.1 -lp
kstats -i $tmpdir/tst.17.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.17.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.17.$$ $tmpdir/stats.$$

# -- test 18 ----------------------------------------------------
test_num=18
descr="-wsize 10 -hsize 10 -ch2 -order 2 -lcutoff 0.4 -hp"
# ifilt_design -o tst.18 -wsize 10 -hsize 10 -ch2 -order 2 -lcutoff 0.4 -hp
ifilt_design -o $tmpdir/tst.18.$$ -wsize 10 -hsize 10 -ch2 -order 2 -lcutoff 0.4 -hp
kstats -i $tmpdir/tst.18.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.18.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.18.$$ $tmpdir/stats.$$

# -- test 19 ----------------------------------------------------
test_num=19
descr="-wsize 10 -hsize 10 -ch2 -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp"
# ifilt_design -o tst.19 -wsize 10 -hsize 10 -ch2 -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp
ifilt_design -o $tmpdir/tst.19.$$ -wsize 10 -hsize 10 -ch2 -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp
kstats -i $tmpdir/tst.19.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.19.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.19.$$ $tmpdir/stats.$$

# -- test 20 ----------------------------------------------------
test_num=20
descr="-wsize 10 -hsize 10 -ch2 -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs"
# ifilt_design -o tst.20 -wsize 10 -hsize 10 -ch2 -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs
ifilt_design -o $tmpdir/tst.20.$$ -wsize 10 -hsize 10 -ch2 -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs
kstats -i $tmpdir/tst.20.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.20.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.20.$$ $tmpdir/stats.$$

# -- test 21 ----------------------------------------------------
test_num=21
descr="-wsize 20 -hsize 10 -but -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp"
# ifilt_design -o tst.21 -wsize 20 -hsize 10 -but -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp
ifilt_design -o $tmpdir/tst.21.$$ -wsize 20 -hsize 10 -but -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp
kstats -i $tmpdir/tst.21.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.21.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.21.$$ $tmpdir/stats.$$

# -- test 22 ----------------------------------------------------
test_num=22
descr="-wsize 10 -hsize 20 -but -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs"
# ifilt_design -o tst.22 -wsize 10 -hsize 20 -but -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs
ifilt_design -o $tmpdir/tst.22.$$ -wsize 10 -hsize 20 -but -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs
kstats -i $tmpdir/tst.22.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.22.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.22.$$ $tmpdir/stats.$$

# -- test 23 ----------------------------------------------------
test_num=23
descr="-wsize 10 -hsize 10 -ideal -ucutoff 0.1 -lp"
# ifilt_design -pos 0 -o tst.23 -wsize 10 -hsize 10 -ideal -ucutoff 0.1 -lp
ifilt_design -pos 0 -o $tmpdir/tst.23.$$ -wsize 10 -hsize 10 -ideal -ucutoff 0.1 -lp
kstats -i $tmpdir/tst.23.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.23.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.23.$$ $tmpdir/stats.$$

# -- test 24 ----------------------------------------------------
test_num=24
descr="-wsize 10 -hsize 10 -ideal -lcutoff 0.4 -hp"
# ifilt_design -pos 0 -o tst.24 -wsize 10 -hsize 10 -ideal -lcutoff 0.4 -hp
ifilt_design -pos 0 -o $tmpdir/tst.24.$$ -wsize 10 -hsize 10 -ideal -lcutoff 0.4 -hp
kstats -i $tmpdir/tst.24.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.24.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.24.$$ $tmpdir/stats.$$

# -- test 25 ----------------------------------------------------
test_num=25
descr="-wsize 10 -hsize 10 -ideal -lcutoff 0.2 -ucutoff 0.3 -bp"
# ifilt_design -pos 0 -o tst.25 -wsize 10 -hsize 10 -ideal -lcutoff 0.2 -ucutoff 0.3 -bp
ifilt_design -pos 0 -o $tmpdir/tst.25.$$ -wsize 10 -hsize 10 -ideal -lcutoff 0.2 -ucutoff 0.3 -bp
kstats -i $tmpdir/tst.25.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.25.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.25.$$ $tmpdir/stats.$$

# -- test 26 ----------------------------------------------------
test_num=26
descr="-wsize 10 -hsize 10 -ideal -lcutoff 0.2 -ucutoff 0.3 -bs"
# ifilt_design -pos 0 -o tst.26 -wsize 10 -hsize 10 -ideal -lcutoff 0.2 -ucutoff 0.3 -bs
ifilt_design -pos 0 -o $tmpdir/tst.26.$$ -wsize 10 -hsize 10 -ideal -lcutoff 0.2 -ucutoff 0.3 -bs
kstats -i $tmpdir/tst.26.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.26.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.26.$$ $tmpdir/stats.$$

# -- test 27 ----------------------------------------------------
test_num=27
descr="-wsize 10 -hsize 10 -but -order 2 -ucutoff 0.1 -lp"
# ifilt_design -pos 0 -o tst.27 -wsize 10 -hsize 10 -but -order 2 -ucutoff 0.1 -lp
ifilt_design -pos 0 -o $tmpdir/tst.27.$$ -wsize 10 -hsize 10 -but -order 2 -ucutoff 0.1 -lp
kstats -i $tmpdir/tst.27.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.27.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.27.$$ $tmpdir/stats.$$

# -- test 28 ----------------------------------------------------
test_num=28
descr="-wsize 10 -hsize 10 -but -order 2 -lcutoff 0.4 -hp"
# ifilt_design -pos 0 -o tst.28 -wsize 10 -hsize 10 -but -order 2 -lcutoff 0.4 -hp
ifilt_design -pos 0 -o $tmpdir/tst.28.$$ -wsize 10 -hsize 10 -but -order 2 -lcutoff 0.4 -hp
kstats -i $tmpdir/tst.28.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.28.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.28.$$ $tmpdir/stats.$$

# -- test 29 ----------------------------------------------------
test_num=29
descr="-wsize 10 -hsize 10 -but -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp"
# ifilt_design -pos 0 -o tst.29 -wsize 10 -hsize 10 -but -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp
ifilt_design -pos 0 -o $tmpdir/tst.29.$$ -wsize 10 -hsize 10 -but -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp
kstats -i $tmpdir/tst.29.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.29.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.29.$$ $tmpdir/stats.$$

# -- test 30 ----------------------------------------------------
test_num=30
descr="-wsize 10 -hsize 10 -but -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs"
# ifilt_design -pos 0 -o tst.30 -wsize 10 -hsize 10 -but -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs
ifilt_design -pos 0 -o $tmpdir/tst.30.$$ -wsize 10 -hsize 10 -but -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs
kstats -i $tmpdir/tst.30.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.30.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.30.$$ $tmpdir/stats.$$

# -- test 31 ----------------------------------------------------
test_num=31
descr="-wsize 10 -hsize 10 -exp -order 2 -ucutoff 0.1 -lp"
# ifilt_design -pos 0 -o tst.31 -wsize 10 -hsize 10 -exp -order 2 -ucutoff 0.1 -lp
ifilt_design -pos 0 -o $tmpdir/tst.31.$$ -wsize 10 -hsize 10 -exp -order 2 -ucutoff 0.1 -lp
kstats -i $tmpdir/tst.31.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.31.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.31.$$ $tmpdir/stats.$$

# -- test 32 ----------------------------------------------------
test_num=32
descr="-wsize 10 -hsize 10 -exp -order 2 -lcutoff 0.4 -hp"
# ifilt_design -pos 0 -o tst.32 -wsize 10 -hsize 10 -exp -order 2 -lcutoff 0.4 -hp
ifilt_design -pos 0 -o $tmpdir/tst.32.$$ -wsize 10 -hsize 10 -exp -order 2 -lcutoff 0.4 -hp
kstats -i $tmpdir/tst.32.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.32.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.32.$$ $tmpdir/stats.$$

# -- test 33 ----------------------------------------------------
test_num=33
descr="-wsize 10 -hsize 10 -exp -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp"
# ifilt_design -pos 0 -o tst.33 -wsize 10 -hsize 10 -exp -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp
ifilt_design -pos 0 -o $tmpdir/tst.33.$$ -wsize 10 -hsize 10 -exp -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp
kstats -i $tmpdir/tst.33.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.33.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.33.$$ $tmpdir/stats.$$

# -- test 34 ----------------------------------------------------
test_num=34
descr="-wsize 10 -hsize 10 -exp -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs"
# ifilt_design -pos 0 -o tst.34 -wsize 10 -hsize 10 -exp -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs
ifilt_design -pos 0 -o $tmpdir/tst.34.$$ -wsize 10 -hsize 10 -exp -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs
kstats -i $tmpdir/tst.34.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.34.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.34.$$ $tmpdir/stats.$$

# -- test 35 ----------------------------------------------------
test_num=35
descr="-wsize 10 -hsize 10 -ch1 -order 2 -ucutoff 0.1 -lp"
# ifilt_design -pos 0 -o tst.35 -wsize 10 -hsize 10 -ch1 -order 2 -ucutoff 0.1 -lp
ifilt_design -pos 0 -o $tmpdir/tst.35.$$ -wsize 10 -hsize 10 -ch1 -order 2 -ucutoff 0.1 -lp
kstats -i $tmpdir/tst.35.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.35.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.35.$$ $tmpdir/stats.$$

# -- test 36 ----------------------------------------------------
test_num=36
descr="-wsize 10 -hsize 10 -ch1 -order 2 -lcutoff 0.4 -hp"
# ifilt_design -pos 0 -o tst.36 -wsize 10 -hsize 10 -ch1 -order 2 -lcutoff 0.4 -hp
ifilt_design -pos 0 -o $tmpdir/tst.36.$$ -wsize 10 -hsize 10 -ch1 -order 2 -lcutoff 0.4 -hp
kstats -i $tmpdir/tst.36.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.36.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.36.$$ $tmpdir/stats.$$

# -- test 37 ----------------------------------------------------
test_num=37
descr="-wsize 10 -hsize 10 -ch1 -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp"
# ifilt_design -pos 0 -o tst.37 -wsize 10 -hsize 10 -ch1 -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp
ifilt_design -pos 0 -o $tmpdir/tst.37.$$ -wsize 10 -hsize 10 -ch1 -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp
kstats -i $tmpdir/tst.37.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.37.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.37.$$ $tmpdir/stats.$$

# -- test 38 ----------------------------------------------------
test_num=38
descr="-wsize 10 -hsize 10 -ch1 -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs"
# ifilt_design -pos 0 -o tst.38 -wsize 10 -hsize 10 -ch1 -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs
ifilt_design -pos 0 -o $tmpdir/tst.38.$$ -wsize 10 -hsize 10 -ch1 -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs
kstats -i $tmpdir/tst.38.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.38.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.38.$$ $tmpdir/stats.$$

# -- test 39 ----------------------------------------------------
test_num=39
descr="-wsize 10 -hsize 10 -ch2 -order 2 -ucutoff 0.1 -lp"
# ifilt_design -pos 0 -o tst.39 -wsize 10 -hsize 10 -ch2 -order 2 -ucutoff 0.1 -lp
ifilt_design -pos 0 -o $tmpdir/tst.39.$$ -wsize 10 -hsize 10 -ch2 -order 2 -ucutoff 0.1 -lp
kstats -i $tmpdir/tst.39.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.39.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.39.$$ $tmpdir/stats.$$

# -- test 40 ----------------------------------------------------
test_num=40
descr="-wsize 10 -hsize 10 -ch2 -order 2 -lcutoff 0.4 -hp"
# ifilt_design -pos 0 -o tst.40 -wsize 10 -hsize 10 -ch2 -order 2 -lcutoff 0.4 -hp
ifilt_design -pos 0 -o $tmpdir/tst.40.$$ -wsize 10 -hsize 10 -ch2 -order 2 -lcutoff 0.4 -hp
kstats -i $tmpdir/tst.40.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.40.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.40.$$ $tmpdir/stats.$$

# -- test 41 ----------------------------------------------------
test_num=41
descr="-wsize 10 -hsize 10 -ch2 -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp"
# ifilt_design -pos 0 -o tst.41 -wsize 10 -hsize 10 -ch2 -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp
ifilt_design -pos 0 -o $tmpdir/tst.41.$$ -wsize 10 -hsize 10 -ch2 -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp
kstats -i $tmpdir/tst.41.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.41.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.41.$$ $tmpdir/stats.$$

# -- test 42 ----------------------------------------------------
test_num=42
descr="-wsize 10 -hsize 10 -ch2 -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs"
# ifilt_design -pos 0 -o tst.42 -wsize 10 -hsize 10 -ch2 -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs
ifilt_design -pos 0 -o $tmpdir/tst.42.$$ -wsize 10 -hsize 10 -ch2 -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs
kstats -i $tmpdir/tst.42.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.42.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.42.$$ $tmpdir/stats.$$

# -- test 43 ----------------------------------------------------
test_num=43
descr="-wsize 20 -hsize 10 -but -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp"
# ifilt_design -pos 0 -o tst.43 -wsize 20 -hsize 10 -but -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp
ifilt_design -pos 0 -o $tmpdir/tst.43.$$ -wsize 20 -hsize 10 -but -order 2 -lcutoff 0.2 -ucutoff 0.3 -bp
kstats -i $tmpdir/tst.43.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.43.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.43.$$ $tmpdir/stats.$$

# -- test 44 ----------------------------------------------------
test_num=44
descr="-wsize 10 -hsize 20 -but -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs"
# ifilt_design -pos 0 -o tst.44 -wsize 10 -hsize 20 -but -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs
ifilt_design -pos 0 -o $tmpdir/tst.44.$$ -wsize 10 -hsize 20 -but -order 2 -lcutoff 0.2 -ucutoff 0.3 -bs
kstats -i $tmpdir/tst.44.$$ -o $tmpdir/stats.$$
report $test_num "$tmpdir/stats.$$" "test1.results/tst.44.stats" "$descr" "1e-5"
/bin/rm -f $tmpdir/tst.44.$$ $tmpdir/stats.$$

# ---------------------------------------------------------------
#  End of test suite
# ---------------------------------------------------------------

exit $status
