 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for igradient
   >>>> 
   >>>>    Written By: Ramiro Jordan, Jeremy Worley
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 12, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _igradient_h_
#define _igradient_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <image.h>

/* -include_includes */
#include <kimage_proc/kimage_proc.h>
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$IMAGE/objects/kroutine/igradient/uis/igradient.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  input image filename (required infile)
 */
char	*i_file;	/* input image filename FILENAME */
int	 i_flag;	/* input image filename FLAG */

/*
 *  output image filename (required outfile)
 */
char	*o_file;	/* output image filename FILENAME */
int	 o_flag;	/* output image filename FLAG */

/*----- required ME group ----*/
/*
 *  Perform Roberts gradient operation (optional flag)
 */
int	 roberts_flag;  	/* Perform Roberts gradient operation FLAG */

/*
 *  Perform Sobel gradient operation (optional flag)
 */
int	 sobel_flag;  	/* Perform Sobel gradient operation FLAG */

/*
 *  Perform Prewitt gradient operation (optional flag)
 */
int	 prewitt_flag;  	/* Perform Prewitt gradient operation FLAG */

/*
 *  Perform Isotropic gradient operation (optional flag)
 */
int	 isotropic_flag;  	/* Perform Isotropic gradient operation FLAG */

/*-- required ME group end ---*/

/*
 *  Calculate gradient using absolute value or square root (optional logical)
 */
int	 abs_logic;	/* Calculate gradient using absolute value or square root LOGIC */
int	 abs_flag;  	/* Calculate gradient using absolute value or square root FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void igradient_get_args PROTO((kform *));
void igradient_usage_additions PROTO((void));
void igradient_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
