 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for igauss_func
   >>>> 
   >>>>    Written By: Ashish Malhotra
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _igauss_func_h_
#define _igauss_func_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <image.h>

/* -include_includes */
#include "kimage_proc/kimage_proc.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$IMAGE/objects/kroutine/igauss_func/uis/igauss_func.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Output file containing Gaussian data (required outfile)
 */
char	*o_file;	/* Output file containing Gaussian data FILENAME */
int	 o_flag;	/* Output file containing Gaussian data FLAG */

/*----- required ME group ----*/
	/*---- nested optional MI group ----*/
/*
 *  Width coordinate for peak of 2D Gaussian function (optional integer)
 */
int	 wpeak_int; 	/* Width coordinate for peak of 2D Gaussian function INT */
int	 wpeak_flag;	/* Width coordinate for peak of 2D Gaussian function FLAG */

/*
 *  Height coordinate for peak of 2D Gaussian function (optional integer)
 */
int	 hpeak_int; 	/* Height coordinate for peak of 2D Gaussian function INT */
int	 hpeak_flag;	/* Height coordinate for peak of 2D Gaussian function FLAG */

/*
 *  Variance of the 2D Gaussian function along width (optional double)
 */
double	 wvar_double;	/* Variance of the 2D Gaussian function along width DOUBLE */
int	 wvar_flag;   	/* Variance of the 2D Gaussian function along width FLAG */

/*
 *  Variance of the 2D Gaussian function along height (optional double)
 */
double	 hvar_double;	/* Variance of the 2D Gaussian function along height DOUBLE */
int	 hvar_flag;   	/* Variance of the 2D Gaussian function along height FLAG */

/*
 *  Correlation coefficient for 2D Gaussian function (optional double)
 */
double	 coeff_double;	/* Correlation coefficient for 2D Gaussian function DOUBLE */
int	 coeff_flag;   	/* Correlation coefficient for 2D Gaussian function FLAG */

/*
 *  Peak value of the 2D Gaussian function (optional double)
 */
double	 peakval_double;	/* Peak value of the 2D Gaussian function DOUBLE */
int	 peakval_flag;   	/* Peak value of the 2D Gaussian function FLAG */

	/*-- nested optional MI group end --*/

	/*---- nested optional MI group ----*/
/*
 *  Input file of parameters for multiple Gaussian functions (optional infile)
 */
char	*i_file;	/* Input file of parameters for multiple Gaussian functions FILENAME */
int	 i_flag;	/* Input file of parameters for multiple Gaussian functions FLAG */

/*
 *  Normalize amplitude of the Gaussian function (optional logical)
 */
int	 norm_logic;	/* Normalize amplitude of the Gaussian function LOGIC */
int	 norm_flag;  	/* Normalize amplitude of the Gaussian function FLAG */

	/*-- nested optional MI group end --*/

/*-- required ME group end ---*/

/*
 *  Width of output image (number of columns) (optional integer)
 */
int	 wsize_int; 	/* Width of output image (number of columns) INT */
int	 wsize_flag;	/* Width of output image (number of columns) FLAG */

/*
 *  Height of output image (number of rows) (optional integer)
 */
int	 hsize_int; 	/* Height of output image (number of rows) INT */
int	 hsize_flag;	/* Height of output image (number of rows) FLAG */

/*
 *  Data type of 2D Gaussian function data (Optional list)
 */
int	 type_list;	/* Data type of 2D Gaussian function data LIST INDEX */
char	 *type_label;	/* Data type of 2D Gaussian function data LIST LABEL */
int	 type_flag;	/* Data type of 2D Gaussian function data FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void igauss_func_get_args PROTO((kform *));
void igauss_func_usage_additions PROTO((void));
void igauss_func_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
