
/*********************************************************************

Copyright (C) 1993, Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus is is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory

  "this software is 100% hand-crafted by a human being in the USA"

*********************************************************************/

#ifndef __sort_trans_h
#define __sort_trans_h

typedef struct zbucket
{
    float z,r,g,b,a;
    struct zbucket *next;
} zbucket;
#define ONE_OVER_255 0.0039215686

#define MAX_BUCKET_DEPTH 8192

/* routines in abuffer.c */ 
int abuffer_active PROTO(());
int init_abuffer PROTO((int, int));
int deinit_abuffer PROTO((void));
int reset_abuffer PROTO(());
int abuf_read PROTO((int, int, float *));
int abuf_write PROTO((int, int, float));
int under_composite PROTO((float *, float *, float *, float *, float, float, float, float));

/* routines in sort_trans.c */
int init_bucket_zbuffer PROTO((int, int));
int clean_zbucket_buffer PROTO((int, int));
int free_bucket_zbuffer PROTO((int xsize,int ysize));
void add_zbucket_entry PROTO((int, int, float, float, float, float, float));
int composite_buckets PROTO(());

#endif

