
/*********************************************************************

Copyright (C) 1993, Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus is is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory

  "this software is 100% hand-crafted by a human being in the USA"

*********************************************************************/

#include <design.h>
#include <geometry.h>
#include "sort_trans.h"
#include "imaging.h"

static zbucket **bucket_zbuffer=NULL;
static int bxsize=0,bysize=0;

static int sort_zbuckets PROTO((zbucket **, int));
static int check_array PROTO((zbucket **, int, int, int));

int
free_bucket_zbuffer(int xsize,
		    int ysize)
{
    if (bucket_zbuffer != NULL)
	clean_zbucket_buffer(xsize,ysize);
    kfree(bucket_zbuffer);
    return(CHILL);
}

int
init_bucket_zbuffer(
int xsize,
int ysize)
{
    register zbucket **f;
    int i;

    bxsize = xsize;
    bysize = ysize;
    
    if (bucket_zbuffer != NULL)
	clean_zbucket_buffer(xsize,ysize);
    else
	bucket_zbuffer = (zbucket **)kmalloc(sizeof(zbucket *)*xsize*ysize);
    
    f = bucket_zbuffer;
    for (i=0;i<xsize*ysize;i++)
	*f++ = NULL;
	
    return(CHILL);
}

int
clean_zbucket_buffer(
int ix,
int iy)
{
    register zbucket **s,*l,*next;
    register int i;

    s = bucket_zbuffer;
    for (i=0;i<ix*iy;i++,s++)
    {
	if (s != NULL)
	{
	    l = *s;
	    while (l != NULL)
	    {
		next = l->next;
/*		free((char *)l); */
		kfree(l);
		l = next;
	    }
	    *s = NULL;
	}
    }
    return(CHILL);
}

void
add_zbucket_entry(int x,int y,float z,float r,float g,float b,float a)
{
    int offset;
    zbucket *t,**p,*list,*last;

    /**
      * here, we're going to add a zbucket thing into the bucketized
      * zbuffer.  we do the quickest thing possible, which is to
      * put the new entry at the beginning of the list.  later, we
      * sort them using a fairly quick sorting algorithm.
    **/
    
    offset = x+y*bxsize;
    p = bucket_zbuffer+offset;

    t = (zbucket *)kmalloc(sizeof(zbucket));
    if (t == NULL)
    {
	kfprintf(kstderr," out of memory for sorted transparency.\n");
	return;
    }

    t->next = *p;
    *p = t;

#if 0    
    /* find place to insert t in the list of entries. */
    list = *p;
    while ((list != NULL) && (list->z < z))
    {
	last = list;
	list = list->next;
    }
    if (list == *p)  /* start of list */
    {
	t->next = *p;
	*p = t;
    }
    else /* in the middle or end of the list */
    {
	t->next = list;
	last->next = t;
    }
#endif
    
    t->z = z;
    t->r = r;
    t->g = g;
    t->b = b;
    t->a = a;
    return;
}

#define BOGUS(a)  (((a) > 10.) ? 1 : (((a) < 0.) ? 1: 0))

static zbucket *s_list[MAX_BUCKET_DEPTH];

int
composite_buckets()
{
    /**
      * here, we're going to take the bucketized a/zbuffer and
      * blend that information in with the normal image.  the 
      * buckets were added in random z-order, thus must be sorted.
      * we keep a table of pointers, into the list, and then sort
      * the pointer list, rather than rearranging the list itself.
    **/
    register zbucket *list,**p;
    int i,j,nbuckets,l_offset;
    float r,g,b,a;
    float *pr,*pg,*pb,*pa;
    float fr,fg,fb,fa;
    float one = 1.;

    pr = &r;
    pg = &g;
    pb = &b;
    pa = &a;

    p = bucket_zbuffer;
#if 0
    kprintf(" compositing... \n");
#endif
    for (j=0;j<bysize;j++)
    {
	for (i=0;i<bxsize;i++,p++)
	{
	    if (*p != NULL)
	    {
		for (list = *p,l_offset=0;list != NULL; list = list->next,l_offset++)
		    s_list[l_offset] = list;  /* make table of pointers */

		/* now, sort the list of pointers */
		sort_zbuckets(s_list,l_offset); 
		check_array(s_list,l_offset,i,j);

		/* composite from near Z to far Z, breaking out of this
		   composite loop when the alpha exceeds a constant near 1.0 */

		r = g = b = a = 0.;
		for (nbuckets=0;nbuckets<l_offset;nbuckets++)
	        {
		    list = s_list[nbuckets];
		    under_composite(pr,pg,pb,pa,list->r,list->g,list->b,list->a);
		    if (a > 0.99)
			break;
		}
		
		if (BOGUS(r) || BOGUS(g) || BOGUS(b))
		    kfprintf(kstderr," bogus rgb at %d,%d:\t%g,%g,%g\n",i,j,r,g,b);
		/* now blend the composited transparency values with
		   the existing pixel map */

		read_dot(i,j,&fr,&fg,&fb);
		/* assume existing pixel has opacity of 1.0 */
		under_composite(pr,pg,pb,pa,fr,fg,fb,one);
		if (r > 1.)
		    r = 1.;
		else if (r < 0.)
		    r = 0;
		
		if (g > 1.)
		    g = 1.;
		else if (g < 0.)
		    g = 0;
		
		if (b > 1.)
		    b = 1.;
		else if (b < 0.)
		    b = 0;
		write_dot(i,j,r,g,b);
	    }
	}
    }
    return(CHILL);
}

static int
sort_zbuckets(
zbucket **blist,
int n)
{
    /**
      * Parameters:
      * vlist - pointer list to buckets to be sorted on increasing Z
      * n - count of buckets to be sorted.
      *
    **/
/*    int i,j,h,v; */
    int i,j,h;
    zbucket *v;
    int loops;
    
    /**
      * the following is a "shellsort" algorithm described in
      * "Algorithms" by Sedgewick.
    **/
    
    for (h=1,loops=0;h<=n;h=3*h+1,loops++)
	;
    
    for (h=h/3;;h=h/3)
    {
	for (i=h+1;i<=n;i++)
	{
/*	    v = vi[i-1]; */
	    v = *(blist+i-1);
	    j = i;
/*	    while ((j >= 1) && ((vlist+vi[j-h-1])->v[2] > (vlist+v)->v[2])) */
	    while ((j >= 1) && (((blist[j-h-1])->z > v->z)))
	    {
/*		vi[j-1] = vi[j-h-1]; */
		blist[j-1] = blist[j-h-1];
		j = j - h;
		if (j <= h)
		    break;
	    }
	    blist[j-1] = v;
/*	    vi[j-1] = v; */
		   
	}
	if (h == 1)
	    break;
    }
    return(CHILL);
}

static int
check_array(
zbucket **slist,
int l_offset,
int x,
int y)
{
    int i,status;
    for (i=0,status=CHILL;i<l_offset-1;i++)
    {
	if (slist[i]->z > slist[i+1]->z)
	{
	    status = WHACKED;
	    break;
	}
    }
    if (status != CHILL)
	kfprintf(kstderr," 'sorted list' ain't sorted at (x,y).\n",x,y);

    return(status);
}
    
