 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for rmonster
   >>>> 
   >>>>    Written By: 
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 15, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _rmonster_h_
#define _rmonster_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <geometry.h>
#include <xvinclude.h>
#include "form_info.h"

/* -include_includes */
#include "geometry/geometry.h"

#include "rmonster_objs.h"
#include "lights.h"
#include "imaging.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/**
  * the following is used in the rmonster code for dealing with
  * input.  it would be nice if this #define could be used in the
  * .pane and .form files, but it's not.  beware that there is a
  * change there (in the number of ports) will necessitate a change
  * here, and vice versa.
**/
#define NUMBER_RMONSTER_INPUT_OBJECT_PORTS 4
/* -include_defines_end */

#define PANEPATH "$GEOMETRY/objects/xvroutine/rmonster/uis/rmonster.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Alternate UIS file (optional infile)
 */
char	*form_file;	/* Alternate UIS file FILENAME */
int	 form_flag;	/* Alternate UIS file FLAG */

/*
 *  (x,y) position for automatic GUI placement */

int	 x_int;		/* x position INT */
int	 x_flag;	/* x position FLAG */

int	 y_int;		/* y position INT */
int	 y_flag;	/* y position FLAG */

/*
 *  Input file 1 (optional infile)
 */
char	*i1_file;	/* Input file 1 FILENAME */
int	 i1_flag;	/* Input file 1 FLAG */

/*
 *  Input file 2 (optional infile)
 */
char	*i2_file;	/* Input file 2 FILENAME */
int	 i2_flag;	/* Input file 2 FLAG */

/*
 *  Input file 3 (optional infile)
 */
char	*i3_file;	/* Input file 3 FILENAME */
int	 i3_flag;	/* Input file 3 FLAG */

/*
 *  Input file 4 (optional infile)
 */
char	*i4_file;	/* Input file 4 FILENAME */
int	 i4_flag;	/* Input file 4 FLAG */

/*
 *  viewing method for rendered image (Optional list)
 */
int	 view_list;	/* viewing method for rendered image LIST INDEX */
char	 *view_label;	/* viewing method for rendered image LIST LABEL */
int	 view_flag;	/* viewing method for rendered image FLAG */

/*
 *  width of rendered image (optional integer)
 */
int	 wsize_int; 	/* width of rendered image INT */
int	 wsize_flag;	/* width of rendered image FLAG */

/*
 *  height of rendered image (optional integer)
 */
int	 hsize_int; 	/* height of rendered image INT */
int	 hsize_flag;	/* height of rendered image FLAG */

/*
 *  compute view so all objects appear in the render window. (optional logical)
 */
int	 norm_logic;	/* compute view so all objects appear in the render window. LOGIC */
int	 norm_flag;  	/* compute view so all objects appear in the render window. FLAG */

/*
 *  Projection method to use when rendering (Optional list)
 */
int	 proj_list;	/* Projection method to use when rendering LIST INDEX */
char	 *proj_label;	/* Projection method to use when rendering LIST LABEL */
int	 proj_flag;	/* Projection method to use when rendering FLAG */

/*
 *  x component of eye position. (optional float)
 */
float	 eye_x_float;	/* x component of eye position. FLOAT */
int	 eye_x_flag;   	/* x component of eye position. FLAG */

/*
 *  x component of up vector. (optional float)
 */
float	 up_x_float;	/* x component of up vector. FLOAT */
int	 up_x_flag;   	/* x component of up vector. FLAG */

/*
 *  x component of initial look-at point. (optional float)
 */
float	 at_x_float;	/* x component of initial look-at point. FLOAT */
int	 at_x_flag;   	/* x component of initial look-at point. FLAG */

/*
 *  y component of eye position. (optional float)
 */
float	 eye_y_float;	/* y component of eye position. FLOAT */
int	 eye_y_flag;   	/* y component of eye position. FLAG */

/*
 *  y component of up vector. (optional float)
 */
float	 up_y_float;	/* y component of up vector. FLOAT */
int	 up_y_flag;   	/* y component of up vector. FLAG */

/*
 *  y component of initial look-at point. (optional float)
 */
float	 at_y_float;	/* y component of initial look-at point. FLOAT */
int	 at_y_flag;   	/* y component of initial look-at point. FLAG */

/*
 *  z component of eye position. (optional float)
 */
float	 eye_z_float;	/* z component of eye position. FLOAT */
int	 eye_z_flag;   	/* z component of eye position. FLAG */

/*
 *  z component of up vector. (optional float)
 */
float	 up_z_float;	/* z component of up vector. FLOAT */
int	 up_z_flag;   	/* z component of up vector. FLAG */

/*
 *  z component of initial look-at point. (optional float)
 */
float	 at_z_float;	/* z component of initial look-at point. FLOAT */
int	 at_z_flag;   	/* z component of initial look-at point. FLAG */

/*
 *  Location of front clip plane. (1 is look-at point, 0 is view point) (optional float)
 */
float	 hither_float;	/* Location of front clip plane. (1 is look-at point, 0 is view point) FLOAT */
int	 hither_flag;   	/* Location of front clip plane. (1 is look-at point, 0 is view point) FLAG */

/*
 *  Location of back clip plane. (0 is look-at point, 1 is view point) (optional float)
 */
float	 yon_float;	/* Location of back clip plane. (0 is look-at point, 1 is view point) FLOAT */
int	 yon_flag;   	/* Location of back clip plane. (0 is look-at point, 1 is view point) FLAG */

/*
 *  turns back clipping on or off. (optional logical)
 */
int	 bc_logic;	/* turns back clipping on or off. LOGIC */
int	 bc_flag;  	/* turns back clipping on or off. FLAG */

/*
 *  Output rendered image (optional outfile)
 */
char	*o_file;	/* Output rendered image FILENAME */
int	 o_flag;	/* Output rendered image FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
extern gui_info_struct *gui_info;

/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void rmonster_get_args PROTO((kform *));
void rmonster_usage_additions PROTO((void));
void rmonster_free_args PROTO((int, kaddr));

/* -include_routines */
void init_object_list_GUI PROTO((RenderMonster_Objects *));
void update_cameras_pane_GUI PROTO((RenderMonster_Cameras *));
int init_lights_pane PROTO((RenderMonster_Lights *));
int update_lights_gui PROTO((RenderMonster_Lights *));
int init_imaging_pane PROTO((RenderMonster_Imaging *));
void init_input_pane_GUI PROTO((clui_info_struct *,RenderMonster_Input *));
void update_object_pane PROTO((rmonsterobj *));
void update_transformation_pane PROTO((rmonsterobj *));

void init_output_pane_GUI PROTO((clui_info_struct *,RenderMonster_Output *));

/**
  * imaging output routines in output.c
**/
int init_image_output PROTO((int, int, int, char *));
int flush_output PROTO(());
int set_image_dims PROTO((int,int));
int get_image_dims PROTO((int *,int *));
int set_image_display_choice PROTO((int));
int get_image_display_choice PROTO((int *));
int set_do_display_mode PROTO((int));
int get_do_display_mode PROTO((int *));
int init_rmonster_output PROTO((int,int, int, int, char *));
int shutdown_rmonster_output PROTO((void));
int set_output_transport_name PROTO((char *));
int get_output_transport_name PROTO((char *));
int set_do_named_output PROTO((int));
int get_do_named_output PROTO((int *));
int init_render_buffers PROTO((void));
int init_output_object PROTO(());
int change_image_dims PROTO((int,int));
int change_image_width PROTO((int));
int change_image_height PROTO((int));

/**
  * input object handlers
**/
int init_object_list PROTO((clui_info_struct *));
int return_objects_names PROTO((char ***, int *));

/**
  * camera stuff
**/
int init_camera PROTO((clui_info_struct *));

/**
  * rendering
**/
int software_render_image PROTO(());

void init_transformations PROTO((RenderMonster_Transformations *));

/** 
  * clipping stuff
**/
int clip_line_persp PROTO((float *,float *,float *,float *,float *,float *,float *,int,int));
int clip_line_parallel PROTO((float *,float *,float *,float *,float *,float *,float *,int,int));

int reinit_output_object PROTO((int, int));
int ppmquant PROTO((float *, int, int, unsigned char *, unsigned char *, unsigned char *, unsigned char *));
int ppmdither PROTO((float *, int, int, unsigned char *, unsigned char *, unsigned char *, unsigned char *));
/* -include_routines_end */

#endif
