
/*********************************************************************

Copyright (C) 1995, Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus it is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory
                Berkeley, California 

  "this software is 100% hand-crafted by a human being in the USA"

*********************************************************************/

#include <design.h>
#include <geometry.h>
#include "rmonster.h"
#include "camera.h"
#include "imaging.h"

#define MAX_RENDERERS 4

static renderer_struct *avail_renderers[MAX_RENDERERS];
static int number_avail_renderers=0;

static renderer_struct software_renderer;
static renderer_struct native_renderer; /* the native hardware renderer */
static int active_renderer=0;

int
set_active_renderer(int i)
{
    if ((i >= 0) && (i < number_avail_renderers))
    {
	active_renderer=i;
	return(CHILL);
    }
    else
	return(WHACKED);
}

int
get_active_renderer()
{
    return(active_renderer);
}

static
renderer_struct *get_active_render_struct()
{
    int active;
    active=get_active_renderer();
    return(avail_renderers[active]);
}


int
have_graphics_hardware(renderer_struct *renderer)
{
    char *xdisp_name;
    Display *xdisp;
    int nexts;
    char **exts;
    int status;
    char *server_vendor;
    
    /**
      * determine if there is support for hardware rendering on this
      * platform.  if so, return TRUE, otherwise, return FALSE.
    **/

    xdisp_name = getenv("DISPLAY");
    xdisp = XOpenDisplay(xdisp_name);
    if (xdisp == NULL)  /* shouldn't ever happen...*/
    {
	fprintf(stderr," Hey bagel-brain, set $DISPLAY to something, ok?\n");
	kexit(0);
    }

    server_vendor = XServerVendor(xdisp);

    exts = XListExtensions(xdisp,&nexts);

    status = find_gfx_hardware(exts,nexts,server_vendor,
			       &(renderer->renderer_name[0]));  /* in machine.c */
    
    return(status);
}


void
identify_native_renderer()
{
    char *xdisp_name;
    Display *xdisp;
    Visual *visual;
    Screen *screen;
    int screen_no;
    int depth;
    
    /**
      * the purpose of this routine is to determine some information
      * about $DISPLAY, like whether or not is supports graphics
      * acceleration, etc.  .
    **/
    
    xdisp_name = getenv("DISPLAY");
    xdisp = XOpenDisplay(xdisp_name);
    screen = XDefaultScreenOfDisplay(xdisp);
    visual = XDefaultVisualOfScreen(screen);
/*    screen_no = ScreenNumberOfScreen(screen); */

    depth = XDefaultDepthOfScreen(screen);

    if (have_graphics_hardware(&native_renderer) == TRUE)
    {
	avail_renderers[number_avail_renderers] = &native_renderer;
	native_renderer.renderer_active = 1;
	number_avail_renderers++;

	/* find best visual to use. */

#if 0
	/* -- no renderers to init yet -- */ 
	/** the routine init_native_renderer() is present in
	  each of gl.c, xgl.c, ...etc. **/
	init_native_renderer(&native_renderer);
#endif
    }
}


void
identify_software_renderer()
{
    /**
      * the purpose of this routine is to determine some information
      * about $DISPLAY, like whether or not is supports graphics
      * acceleration, etc.
      *
      * this routine must be called prior to establishing any other
      * renderers.
    **/
    software_renderer.ndisplay_options = 5;
    software_renderer.selected_display_option = 0;  /* default is 3-3-2  */

    software_renderer.display_options_txt[0] = s332_STRING;
    software_renderer.display_options_txt[1] = s24BIT_STRING;
    software_renderer.display_options_txt[2] = sQUANT_STRING;
    software_renderer.display_options_txt[3] = sDITHER_STRING;
    software_renderer.display_options_txt[4] = sNODISPLAY_STRING;
    
    kstrcpy(software_renderer.renderer_name,"Software Renderer");
    
    software_renderer.renderer_active = 1;

    number_avail_renderers=1;
    avail_renderers[0] = &software_renderer;

    software_renderer.init_output_func = init_rmonster_output;
    software_renderer.render_func = software_render_image;
    software_renderer.shutdown_output_func = shutdown_rmonster_output;
    software_renderer.set_camera_func = software_set_camera;
}

int
get_all_renderers_info(int *n,
		       renderer_struct ***r)
{
    *n = number_avail_renderers;
    *r = avail_renderers;
    return(CHILL);
}

void
renderer_init_func (void)
{
    int w,h,img_display_choice,do_named_flag;
    char transport_name[128];
    renderer_struct *r;
    int (*fptr)();

    get_image_dims(&w,&h);
    get_image_display_choice(&img_display_choice);
    get_output_transport_name(transport_name);
    get_do_named_output(&do_named_flag);
    r = get_active_render_struct();

    fptr = r->init_output_func;
    (*fptr)(w,h,img_display_choice,do_named_flag,transport_name);
}

void
renderer_shutdown_func (void)
{
    renderer_struct *r;
    int (*fptr)();
    
    r = get_active_render_struct();

    fptr = r->shutdown_output_func;
    (*fptr)();
}

void
renderer_invoke_func (void)
{
    renderer_struct *r;
    int (*fptr)();
    
    r = get_active_render_struct();

    fptr = r->render_func;
    (*fptr)();
}
