
/*********************************************************************

Copyright (C) 1995, Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus it is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory
                Berkeley, California 

  "this software is 100% hand-crafted by a human being in the USA"

  this file contains silicon graphics GL specific code.  ifdef's
  surround the entire contents of the file.

*********************************************************************/


/*
 * Khoros: $Id$
 */
 
#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

#if defined(__sgi__) || defined(__sgi) || defined(_SGI)

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            File Title
   >>>>
   >>>>  Static:
   >>>>             _static_routines()
   >>>>  Public:
   >>>>             public_routines()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

/* #include "rmonster.h"*/
#include <stdio.h>
#include <stdlib.h>

#if 0

/* 
 * defines for view parameters.
 * NOTE: these were snarfed from kgeometry.h.  including the khoros
 * main include files won't work because there are definitions which
 * collide with those in the gl.h file.
 */
#define KPROJECTION_PERSPECTIVE 0
#define KPROJECTION_PARALLEL    1


#include <gl/gl.h>
#include "geometry/geom.h"
#include "rmonster_objs.h"
#include "imaging.h"
#include "rmatrix.h"


extern int have_any_transparent_objs PROTO((rmonsterobj *r));
static void gl_render_opaque_subtree PROTO((rmonsterobj *, matrix4x4 *, matrix4x4 *, int, int, int, vertex_3d *));
static int map_to_gl_renderprims PROTO((int));
static void gl_flush_output PROTO(());

#if 0
static void gl_render_transparent_subtree PROTO((rmonsterobj *, matrix4x4 *, matrix4x4 *, int, int, int, vertex_3d *));
#endif

static void gl_noprim PROTO(());
static void gl_polytri_dis PROTO(());
static void gl_polytri_con PROTO(());

static void gl_polyline_dis PROTO((rmonster_prim *,int,int,vertex_3d *,vertex_3d *,vertex_3d *,	float *,int,int,rmonsterobj *,int,int));

static void gl_polyline_con PROTO((rmonster_prim *,int,int,vertex_3d *,vertex_3d *,vertex_3d *,	float *,int,int,rmonsterobj *,int,int));

static void gl_qmesh PROTO(());
static void gl_omesh PROTO(());
static void gl_polyhedron PROTO(());
static void gl_sphere PROTO(());
static void gl_dirpoint PROTO(());
static void gl_text PROTO(());

#define NO_PRIM 0
#define POLYTRI_DIS 1
#define POLYTRI_CON 2
#define POLYLIN_DIS 3
#define POLYLIN_CON 4
#define QMESH 5
#define OMESH 6
#define PHEDRON 7
#define SPHERE 8
#define DIRPT 9
#define TEXT 10

static void (*gl_primfuncs[])() =
{
    gl_noprim,
    gl_polytri_dis,
    gl_polytri_con,
    gl_polyline_dis,
    gl_polyline_con,
    gl_qmesh,
    gl_omesh,
    gl_polyhedron,
    gl_sphere,
    gl_dirpoint,
    gl_text
};

/*-----------------------------------------------------------
|
|  Routine Name: function_name - short description of function
|
|       Purpose: This should be a complete description that anyone
|                could understand;  it should have acceptable grammar
|                and correct spelling.
|
|         Input: argument1 - explanation
|                argument2 - explanation
|                argument3 - explanation
|
|        Output: argument4 - explanation
|                argument5 - explanation
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By:
|          Date: 
| Modifications:
|
------------------------------------------------------------*/

static long gl_win_id = -1;

int gl_init_func();
int gl_clear_window();
int gl_shutdown_func();
int gl_camera_func();

int
gl_init_func(int width,
	     int height,
	     int img_disp_choice,
	     int do_named_output,
	     char *name)
{
    
    prefsize(width,height);
    foreground();
    gl_win_id = winopen("RenderMonster(tm) - GL");

    mmode(MVIEWING);
    drawmode(NORMALDRAW);

    zbuffer(TRUE);
    zclear();

    RGBmode();
    gconfig();
    
    gl_clear_window();

    gl_camera_func();
    viewport(0,width-1,0,height-1);  /* use the whole window */

}

int
gl_clear_window()
{
    float bg[3];
    get_background_color(bg,bg+1,bg+2);
    c3f(bg);
    clear();
}

int
gl_shutdown_func()
{
    if (gl_win_id != -1)
	winclose(gl_win_id);
    gexit();
}

int
gl_render_func()
{
    /* see also: software_render_image in render.c */
    rmonsterobj *r;
    matrix4x4 xfrm,view;
    vertex_3d trans_vec;
    int i,j,have_transparent_objs;
    int w,h;
    int projection;
    Matrix I;

    for (i=0;i<4;i++)
	for (j=0;j<4;j++)
	    if (i==j)
		I[i][j] = 1.;
            else
		I[i][j] = 0.;


    
    loadmatrix(I); 

#if 0
				/* need to rework cursor code */
    show_render_cursor();
#endif
    
/*    clear_framebuffer(); */
    setlinestyle(0);		/* default is single pixel wide solid lines */
    gl_camera_func();
    gl_clear_window();

    get_image_dims(&w,&h);
    
    identity_4x4(&xfrm);
    get_view_xform(&view);
#if 0
    reset_zbuffer();
    reset_abuffer();
    init_bucket_zbuffer(w,h);
#endif
    get_projection(&projection);
    r = get_root_object();

    have_transparent_objs = have_any_transparent_objs(r);

    trans_vec.v[0] = trans_vec.v[1] = trans_vec.v[2] = 0.;

    /* render the opaque objects first */
    gl_render_opaque_subtree(r,&xfrm,&view,w,h,projection,&trans_vec); 
    
    if (have_transparent_objs == TRUE)
    {
	
#if 0
	gl_render_transparent_subtree(r,&xfrm,&view,w,h,projection,&trans_vec);
#endif
	
#if 0
	composite_buckets();
#endif
    }
#if 0
				/* need to rework cursor code */
    clear_render_cursor();
#endif
    

    gl_flush_output();

    return(CHILL);
}

int
init_native_renderer(renderer_struct *r)
{
    r->init_output_func = gl_init_func;
    r->render_func = gl_render_func;
    r->shutdown_output_func = gl_shutdown_func;

    r->set_camera_func = gl_camera_func;
    
    /* we may want to try to support something other than 24bit
       images at some point.  hmmmm.   25 jan 95 */
    r->ndisplay_options = 1;
    r->selected_display_option = 0;
/*    kstrcpy(r->display_options_txt[0],sDEFAULT_STRING); */
}

int
gl_min_config()
{
    /**
      * this routine will return a 1 if a minimum hardware configuration
      * is detected in the present system (pointed to by $DISPLAY) or a 0
      * otherwise.
      *
      * presently (25 Jan 95) the minimum acceptable configuration is
      * "can this machine do RGB single-buffered mode", which ain't much.
    **/
    
    int nbits;

    /**
      * from the getgdesc() manpage,
      * Number of bitplanes available in the normal framebuffer to store
      * red, green, and blue in single buffered RGB mode.  If any of these
      * are 0, then single buffered RGB mode is not available.
    **/

    nbits = getgdesc(GD_BITS_NORM_SNG_RED);
    if (nbits > 0)
	return(1);
    else
	return(0);
}

#define DEGREES_TO_RADIANS(a) (PI*(a)/180.)
#define RADIANS_TO_DEGREES(a) (180.*(a)/PI)

int
gl_camera_func()
{
    vertex_3d l_eye,l_at,l_up,y_ref,eye_at_vector;
    float l_fov,l_hither,l_yon,l_zmin,l_zproj,dot;
    int l_proj;
    double ddot;
    double mag;
    extern double acos();
    int i;
    
    Coord vx,vy,vz,px,py,pz;
    Angle twist;
    Angle fovy;
    float aspect;
    Coord near,far;
    
    get_eye(&l_eye);
    get_at(&l_at);
    get_up(&l_up);
    get_fov(&l_fov);

				/* hither/yon code needs to be changed
				 4/3/95 */
#ifdef THIS_DOESNT_WORK_RIGHT
    get_hither(&l_hither);
    get_yon(&l_yon);
#endif
    get_projection(&l_proj);

    px = l_at.v[0];
    py = l_at.v[1];
    pz = l_at.v[2];
    
    vx = l_eye.v[0];
    vy = l_eye.v[1];
    vz = l_eye.v[2];

    y_ref.v[0] = y_ref.v[2] = 0.;
    y_ref.v[1] = 1.;
    nvertex_dot(&l_up,&y_ref,&dot,1);
    ddot = (double)dot;

    twist = (Angle)acos(ddot);
    twist = RADIANS_TO_DEGREES(twist);
    twist *= 10.;

/*    lookat(vx,vy,vz,px,py,pz,twist); */

    for (i=0;i<3;i++)
	eye_at_vector.v[i] = l_eye.v[i] - l_at.v[i];

    vertex_mag(&eye_at_vector,&mag);
    near = mag - l_hither;
    far = mag + l_yon;
    if (l_proj == KPROJECTION_PERSPECTIVE)
    {
	fovy = l_fov*10.0;
	aspect = 1.0;		/* for now */
	reshapeviewport();
	perspective(fovy,aspect,near,far); 
	lookat(vx,vy,vz,px,py,pz,twist); 
    }
    else
    {
	Coord left,right,top,bottom,near,far;
#if 0
	/* need to finish/test stuff for orthographic projections */
	ortho();
#endif
    }
    
}

static void
gl_render_opaque_subtree(rmonsterobj *r,
			 matrix4x4 *xfrm,
			 matrix4x4 *view,
			 int w,int h,
			 int projection,
			 vertex_3d *tv)

    /* postmultiply object transformation with the current xform matrix. */
    /** transformation on the current level is composed of:
      
      1. -center
      2. scale*rotate
      3 +center+translate.
      
    **/

    /**
      * to do for GL:
      * 1. check out all this matrix crap.  i don't think it works
      * correctly at present.  5 mar 95, wes.
      *
      * 2. push all object transformations off into hardware.  at present,
      * only the drawing is done in hardware.  the transformations are done
      * in rmonster software.
    **/
{
    int status;
    int display_status,opaque_status;
    int nprims,i;
    matrix4x4 m;
    vertex_3d trans_vec;
    rmonster_prim *p;
    vertex_3d *v,*n2, *norm;
    vertex_3d *obj_space,*v2,*view_space;
    vertex_3d work;
    float *radii;
    double mag;
    float fmag;
    int prim_type;
    float radius_xy_scale,radius_depth_scale;

    mmul_4x4(xfrm,&(r->xfrm),&m);

    if (r->nchildren == 0) /* a leaf node */
    {
	get_object_display_status(r,&display_status);
	opaque_status = is_opaque(r);
	if ((display_status == TRUE) && (opaque_status == TRUE))
	{
	    nprims = r->nprims;
	    for (i=0;i<nprims;i++)
	    {
		p = r->prims+i;
		n2 = NULL;
		radii = NULL;

		/* create space for the vertices: one copy for the
		   object space (transformed) vertices, one for the
		   view space vertices. */
		
		v = p->verts;
		obj_space = v2 = (vertex_3d *)kmalloc(sizeof(vertex_3d)*p->nverts);
		view_space = (vertex_3d *)kmalloc(sizeof(vertex_3d)*p->nverts);

		if (p->type != KGEOM_SPHERES)
		{
		    norm = p->prim_specifics.normals;
		    if (norm)
			n2 = (vertex_3d *)kmalloc(sizeof(vertex_3d)*p->nthings);
		}
		else
		{
		    radii = p->prim_specifics.radii;
		    if (radii)
		    {
			radii = (float *)kmalloc(sizeof(float)*p->nthings);
			memcpy((char *)radii,(char *)(p->prim_specifics.radii),
			       sizeof(float)*p->nthings);
		    }
		}

		/**
		  * apply the geometric transformations in object space
		**/
		geom_xform_points(&(r->xfrm),&(r->translate_vect),&(r->center),
				  v,obj_space,xfrm,tv,p->nverts); 
		
		/* transform the normals, if there are any. note: the
		   transformation of the normals does not involve any
		   translational component, so there is a specific
		   routine to deal with this transformation. */
		if (p->type != KGEOM_SPHERES)
		{
		    nnormal_xfrm(norm,&m,n2,p->nthings);
		    /* the normals are not run thru the view transformation
		       matrix since 1. this coordinate system is not
		       necessarily orthonormal to the world coord system,
		       and 2. lighting calculations are performed in the
		       world coord system. */
		    nnormal_unit(n2,n2,p->nthings);
		}
		else
		{
#if 0
		    /* the radii values must be scaled by an amount which
		       is the maximum of the scale components of the
		       object transformation matrix. */
		    work.v[0] = m.m[0][0] * view->m[0][0];
		    work.v[1] = m.m[1][1] * view->m[1][1];
		    work.v[2] = m.m[2][2] * view->m[2][2];
		    vertex_mag(&work,&mag);
		    fmag = mag;
#endif
		    get_world_to_view_scale(&radius_xy_scale,&radius_depth_scale);
		    scale_vector(radii,radius_xy_scale,radii,p->nthings,1);
		}

		/* now, do the viewing transformation */
		npoint_xfrm(&(obj_space->v[0]),view,&(view_space->v[0]),p->nverts);

		/* at this point, we have polygons with vertices
		   in the a normalized space. */

		prim_type = map_to_gl_renderprims(p->type);
		(*gl_primfuncs[prim_type])(p,w,h,obj_space,view_space,n2,radii,projection,opaque_status,r);
		kfree(obj_space);
		kfree(view_space);
		if (radii)
		    kfree(radii);
		if (n2)
		    kfree(n2);
		    
	    }
	}
    }
    else
    {
	matrix4x4 minusC,SR,C,composite;
	
	for (i=0;i<3;i++)
	    trans_vec.v[i] = tv->v[i] + r->translate_vect.v[i];

	/**
	  * build composite transformation matrix:
	  * M = -CSRCT, where
	  *    C = object's center point,
	  *    SR = scale and rotate components.
	  *    T = translate vector.
	  *
	**/
	identity_4x4(&minusC);
	identity_4x4(&SR);
	identity_4x4(&C);
	
	identity_4x4(&composite);
	
	minusC.m[3][0] = -1. * r->center.v[0];
	minusC.m[3][1] = -1. * r->center.v[1];
	minusC.m[3][2] = -1. * r->center.v[2];
	
	matrix_4x4copy(&SR,&(r->xfrm));
	
	C.m[3][0] = r->center.v[0];
	C.m[3][1] = r->center.v[1];
	C.m[3][2] = r->center.v[2];
	
	mmul_4x4(&minusC,&SR,&composite);
	mmul_4x4(&composite,&C,&composite);

	mmul_4x4(xfrm,&composite,&m);

	for (i=0;i<r->nchildren;i++)
	{
	    gl_render_opaque_subtree(r->children[i],&m,view,w,h,projection,&trans_vec);
	}
    }
}

static
int map_to_gl_renderprims(int ktype)
{
    /* convert from khoros primitve type to one of the rmonster
       supported types. */
    int val;
    
    switch (ktype)
    {
    case KGEOM_POLYLINE_DISJOINT:
	val = POLYLIN_DIS;
	break;
    case KGEOM_POLYLINE_CONNECTED:
	val = POLYLIN_CON;
	break;
    case KGEOM_TRIANGLES_DISJOINT:
	val = POLYTRI_DIS;
	break;
    case KGEOM_TRIANGLES_CONNECTED:
	val = POLYTRI_CON;
	break;
    case KGEOM_SPHERES:
	val = SPHERE;
	break;
    case KGEOM_QUADMESH:
	val = QMESH;
	break;
    case KGEOM_OCTMESH:
	val = OMESH;
	break;

	/* everything else isn't supported yet. */
    default:
	val = NO_PRIM;
	break;
    }
    return(val);
}

static void
gl_noprim ()
{
}

static void
gl_polytri_dis ()
{
}

static void
gl_polytri_con ()
{
}

static void
gl_polyline_dis(rmonster_prim *p,
		int xs,int ys,
		vertex_3d *obj_space_verts,
		vertex_3d *view_space_verts,
		vertex_3d *norms,
		float *unused,
		int projection,
		int opaque_status,
		rmonsterobj *r,
		int hither,
		int yon)
{
}

static void
gl_polyline_con(rmonster_prim *p,
	     int xs, int ys,
	     vertex_3d *obj_space_verts,
	     vertex_3d *view_space_verts,
	     vertex_3d *norms,
	     float *unused,
	     int projection,
	     int opaque_status,
	     rmonsterobj *r,
	     int hither,
	     int yon)
{
    int i;
    vertex_3d *v;
    
    RGBcolor((short)255,(short)255,(short)255);
    
    v = p->verts;
    
    bgnline();
    for (i=0;i<p->nverts;i++,v++)
    {
	v3f((float *)v);
    }
    endline();
}

static void
gl_qmesh()
{
}

static void
gl_omesh()
{
}

static void
gl_polyhedron()
{
}

static void
gl_sphere()
{
}

static void
gl_dirpoint()
{
}

static void
gl_text()
{
}

static void
gl_flush_output()
{
    gflush();
}
#endif
#endif
