 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Form Info Structure for rmonster Form
   >>>> 
   >>>>    Written By: conductor -name rmonster -l 3
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 15, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _form_info_h_
#define _form_info_h_

#include <xvinclude.h>

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

/*
 * Pane Info Struct for 'Objects' Pane
 */
typedef struct _RenderMonster_Objects{

int          current_object;          /* int value of 'current_object'*/
char         *current_object_label;   /* label representing int value of 'current_object'*/
kform_struct *current_object_struct;  /* pass to xvf_set_attributes() */
int          current_object_selected; /* TRUE on <cr> for 'current_object' */
int          current_object_optsel;   /* TRUE if optional box of 'current_object' is ON */

int          object_shader;          /* int value of 'object_shader'*/
char         *object_shader_label;   /* label representing int value of 'object_shader'*/
kform_struct *object_shader_struct;  /* pass to xvf_set_attributes() */
int          object_shader_selected; /* TRUE on <cr> for 'object_shader' */
int          object_shader_optsel;   /* TRUE if optional box of 'object_shader' is ON */

int          post_obj;          /* boolean value of 'post_obj'*/
char         *post_obj_label;   /* label assoc w/ value of 'post_obj'*/
kform_struct *post_obj_struct;  /* pass to xvf_set_attributes() */
int          post_obj_selected; /* TRUE on <cr> for 'post_obj' */
int          post_obj_optsel;   /* TRUE if optional box of 'post_obj' is ON */

float        obj_red;          /* float value of 'obj_red'*/
kform_struct *obj_red_struct;  /* pass to xvf_set_attributes() */
int          obj_red_selected; /* TRUE on <cr> for 'obj_red' */
int          obj_red_optsel;   /* TRUE if optional box of 'obj_red' is ON */

float        obj_green;          /* float value of 'obj_green'*/
kform_struct *obj_green_struct;  /* pass to xvf_set_attributes() */
int          obj_green_selected; /* TRUE on <cr> for 'obj_green' */
int          obj_green_optsel;   /* TRUE if optional box of 'obj_green' is ON */

float        obj_blue;          /* float value of 'obj_blue'*/
kform_struct *obj_blue_struct;  /* pass to xvf_set_attributes() */
int          obj_blue_selected; /* TRUE on <cr> for 'obj_blue' */
int          obj_blue_optsel;   /* TRUE if optional box of 'obj_blue' is ON */

float        obj_alpha;          /* float value of 'obj_alpha'*/
kform_struct *obj_alpha_struct;  /* pass to xvf_set_attributes() */
int          obj_alpha_selected; /* TRUE on <cr> for 'obj_alpha' */
int          obj_alpha_optsel;   /* TRUE if optional box of 'obj_alpha' is ON */

float        obj_ambient;          /* float value of 'obj_ambient'*/
kform_struct *obj_ambient_struct;  /* pass to xvf_set_attributes() */
int          obj_ambient_selected; /* TRUE on <cr> for 'obj_ambient' */
int          obj_ambient_optsel;   /* TRUE if optional box of 'obj_ambient' is ON */

float        obj_diffuse;          /* float value of 'obj_diffuse'*/
kform_struct *obj_diffuse_struct;  /* pass to xvf_set_attributes() */
int          obj_diffuse_selected; /* TRUE on <cr> for 'obj_diffuse' */
int          obj_diffuse_optsel;   /* TRUE if optional box of 'obj_diffuse' is ON */

float        obj_spec;          /* float value of 'obj_spec'*/
kform_struct *obj_spec_struct;  /* pass to xvf_set_attributes() */
int          obj_spec_selected; /* TRUE on <cr> for 'obj_spec' */
int          obj_spec_optsel;   /* TRUE if optional box of 'obj_spec' is ON */

float        obj_spec_exp;          /* float value of 'obj_spec_exp'*/
kform_struct *obj_spec_exp_struct;  /* pass to xvf_set_attributes() */
int          obj_spec_exp_selected; /* TRUE on <cr> for 'obj_spec_exp' */
int          obj_spec_exp_optsel;   /* TRUE if optional box of 'obj_spec_exp' is ON */

float        obj_spec_metal;          /* float value of 'obj_spec_metal'*/
kform_struct *obj_spec_metal_struct;  /* pass to xvf_set_attributes() */
int          obj_spec_metal_selected; /* TRUE on <cr> for 'obj_spec_metal' */
int          obj_spec_metal_optsel;   /* TRUE if optional box of 'obj_spec_metal' is ON */

int          object_info;          /* TRUE when user clicks on 'object_info'*/
kform_struct *object_info_struct;  /* pass to xvf_set_attributes() */

int          action1;          /* TRUE when user clicks on 'action1'*/
kform_struct *action1_struct;  /* pass to xvf_set_attributes() */

kform_struct *object_properties_struct; /* pass to xvf_set_attributes() */

} RenderMonster_Objects;

/*
 * Pane Info Struct for 'Cameras' Pane
 */
typedef struct _RenderMonster_Cameras{

int          projection_cycle;          /* int value of 'projection_cycle'*/
char         *projection_cycle_label;   /* label representing int value of 'projection_cycle'*/
kform_struct *projection_cycle_struct;  /* pass to xvf_set_attributes() */
int          projection_cycle_selected; /* TRUE on <cr> for 'projection_cycle' */
int          projection_cycle_optsel;   /* TRUE if optional box of 'projection_cycle' is ON */

float        eye_x;          /* float value of 'eye_x'*/
kform_struct *eye_x_struct;  /* pass to xvf_set_attributes() */
int          eye_x_selected; /* TRUE on <cr> for 'eye_x' */
int          eye_x_optsel;   /* TRUE if optional box of 'eye_x' is ON */

float        up_x;          /* float value of 'up_x'*/
kform_struct *up_x_struct;  /* pass to xvf_set_attributes() */
int          up_x_selected; /* TRUE on <cr> for 'up_x' */
int          up_x_optsel;   /* TRUE if optional box of 'up_x' is ON */

float        at_x;          /* float value of 'at_x'*/
kform_struct *at_x_struct;  /* pass to xvf_set_attributes() */
int          at_x_selected; /* TRUE on <cr> for 'at_x' */
int          at_x_optsel;   /* TRUE if optional box of 'at_x' is ON */

float        eye_y;          /* float value of 'eye_y'*/
kform_struct *eye_y_struct;  /* pass to xvf_set_attributes() */
int          eye_y_selected; /* TRUE on <cr> for 'eye_y' */
int          eye_y_optsel;   /* TRUE if optional box of 'eye_y' is ON */

float        up_y;          /* float value of 'up_y'*/
kform_struct *up_y_struct;  /* pass to xvf_set_attributes() */
int          up_y_selected; /* TRUE on <cr> for 'up_y' */
int          up_y_optsel;   /* TRUE if optional box of 'up_y' is ON */

float        at_y;          /* float value of 'at_y'*/
kform_struct *at_y_struct;  /* pass to xvf_set_attributes() */
int          at_y_selected; /* TRUE on <cr> for 'at_y' */
int          at_y_optsel;   /* TRUE if optional box of 'at_y' is ON */

float        eye_z;          /* float value of 'eye_z'*/
kform_struct *eye_z_struct;  /* pass to xvf_set_attributes() */
int          eye_z_selected; /* TRUE on <cr> for 'eye_z' */
int          eye_z_optsel;   /* TRUE if optional box of 'eye_z' is ON */

float        up_z;          /* float value of 'up_z'*/
kform_struct *up_z_struct;  /* pass to xvf_set_attributes() */
int          up_z_selected; /* TRUE on <cr> for 'up_z' */
int          up_z_optsel;   /* TRUE if optional box of 'up_z' is ON */

float        at_z;          /* float value of 'at_z'*/
kform_struct *at_z_struct;  /* pass to xvf_set_attributes() */
int          at_z_selected; /* TRUE on <cr> for 'at_z' */
int          at_z_optsel;   /* TRUE if optional box of 'at_z' is ON */

float        hither_clip_form_loc;          /* float value of 'hither_clip_form_loc'*/
kform_struct *hither_clip_form_loc_struct;  /* pass to xvf_set_attributes() */
int          hither_clip_form_loc_selected; /* TRUE on <cr> for 'hither_clip_form_loc' */
int          hither_clip_form_loc_optsel;   /* TRUE if optional box of 'hither_clip_form_loc' is ON */

float        yon_clip_form_loc;          /* float value of 'yon_clip_form_loc'*/
kform_struct *yon_clip_form_loc_struct;  /* pass to xvf_set_attributes() */
int          yon_clip_form_loc_selected; /* TRUE on <cr> for 'yon_clip_form_loc' */
int          yon_clip_form_loc_optsel;   /* TRUE if optional box of 'yon_clip_form_loc' is ON */

int          back_clip_form_on_off;          /* boolean value of 'back_clip_form_on_off'*/
char         *back_clip_form_on_off_label;   /* label assoc w/ value of 'back_clip_form_on_off'*/
kform_struct *back_clip_form_on_off_struct;  /* pass to xvf_set_attributes() */
int          back_clip_form_on_off_selected; /* TRUE on <cr> for 'back_clip_form_on_off' */
int          back_clip_form_on_off_optsel;   /* TRUE if optional box of 'back_clip_form_on_off' is ON */

float        fov_input;          /* float value of 'fov_input'*/
kform_struct *fov_input_struct;  /* pass to xvf_set_attributes() */
int          fov_input_selected; /* TRUE on <cr> for 'fov_input' */
int          fov_input_optsel;   /* TRUE if optional box of 'fov_input' is ON */

float        aspect;          /* float value of 'aspect'*/
kform_struct *aspect_struct;  /* pass to xvf_set_attributes() */
int          aspect_selected; /* TRUE on <cr> for 'aspect' */
int          aspect_optsel;   /* TRUE if optional box of 'aspect' is ON */

int          normalize_cam;          /* TRUE when user clicks on 'normalize_cam'*/
kform_struct *normalize_cam_struct;  /* pass to xvf_set_attributes() */

int          reset_camera;          /* TRUE when user clicks on 'reset_camera'*/
kform_struct *reset_camera_struct;  /* pass to xvf_set_attributes() */

kform_struct *normalize_camera_struct; /* pass to xvf_set_attributes() */

kform_struct *blank1_struct; /* pass to xvf_set_attributes() */

kform_struct *blank2_struct; /* pass to xvf_set_attributes() */

kform_struct *blank3_struct; /* pass to xvf_set_attributes() */

kform_struct *blank4_struct; /* pass to xvf_set_attributes() */

} RenderMonster_Cameras;

/*
 * Pane Info Struct for 'Lights' Pane
 */
typedef struct _RenderMonster_Lights{

int          light_list;          /* int value of 'light_list'*/
char         *light_list_label;   /* label representing int value of 'light_list'*/
kform_struct *light_list_struct;  /* pass to xvf_set_attributes() */
int          light_list_selected; /* TRUE on <cr> for 'light_list' */
int          light_list_optsel;   /* TRUE if optional box of 'light_list' is ON */

int          light_onoff;          /* boolean value of 'light_onoff'*/
char         *light_onoff_label;   /* label assoc w/ value of 'light_onoff'*/
kform_struct *light_onoff_struct;  /* pass to xvf_set_attributes() */
int          light_onoff_selected; /* TRUE on <cr> for 'light_onoff' */
int          light_onoff_optsel;   /* TRUE if optional box of 'light_onoff' is ON */

int          light_type_list;          /* int value of 'light_type_list'*/
char         *light_type_list_label;   /* label representing int value of 'light_type_list'*/
kform_struct *light_type_list_struct;  /* pass to xvf_set_attributes() */
int          light_type_list_selected; /* TRUE on <cr> for 'light_type_list' */
int          light_type_list_optsel;   /* TRUE if optional box of 'light_type_list' is ON */

char         *light_position_string;         /* string for 'light_position_string'*/
kform_struct *light_position_string_struct;  /* pass to xvf_set_attributes() */
int          light_position_string_selected; /* TRUE on <cr> for 'light_position_string' */
int          light_position_string_optsel;   /* TRUE if optional box of 'light_position_string' is ON */

char         *light_direction_string;         /* string for 'light_direction_string'*/
kform_struct *light_direction_string_struct;  /* pass to xvf_set_attributes() */
int          light_direction_string_selected; /* TRUE on <cr> for 'light_direction_string' */
int          light_direction_string_optsel;   /* TRUE if optional box of 'light_direction_string' is ON */

char         *current_light_color_string;         /* string for 'current_light_color_string'*/
kform_struct *current_light_color_string_struct;  /* pass to xvf_set_attributes() */
int          current_light_color_string_selected; /* TRUE on <cr> for 'current_light_color_string' */
int          current_light_color_string_optsel;   /* TRUE if optional box of 'current_light_color_string' is ON */

char         *ambient_light_color_string;         /* string for 'ambient_light_color_string'*/
kform_struct *ambient_light_color_string_struct;  /* pass to xvf_set_attributes() */
int          ambient_light_color_string_selected; /* TRUE on <cr> for 'ambient_light_color_string' */
int          ambient_light_color_string_optsel;   /* TRUE if optional box of 'ambient_light_color_string' is ON */

} RenderMonster_Lights;

/*
 * Pane Info Struct for 'Imaging' Pane
 */
typedef struct _RenderMonster_Imaging{

int          image_width;          /* int for 'image_width'*/
kform_struct *image_width_struct;  /* pass to xvf_set_attributes() */
int          image_width_selected; /* TRUE on <cr> for 'image_width' */
int          image_width_optsel;   /* TRUE if optional box of 'image_width' is ON */

int          image_height;          /* int for 'image_height'*/
kform_struct *image_height_struct;  /* pass to xvf_set_attributes() */
int          image_height_selected; /* TRUE on <cr> for 'image_height' */
int          image_height_optsel;   /* TRUE if optional box of 'image_height' is ON */

int          image_display_choice;          /* int value of 'image_display_choice'*/
char         *image_display_choice_label;   /* label representing int value of 'image_display_choice'*/
kform_struct *image_display_choice_struct;  /* pass to xvf_set_attributes() */
int          image_display_choice_selected; /* TRUE on <cr> for 'image_display_choice' */
int          image_display_choice_optsel;   /* TRUE if optional box of 'image_display_choice' is ON */

float        red_background;          /* float value of 'red_background'*/
kform_struct *red_background_struct;  /* pass to xvf_set_attributes() */
int          red_background_selected; /* TRUE on <cr> for 'red_background' */
int          red_background_optsel;   /* TRUE if optional box of 'red_background' is ON */

float        green_background;          /* float value of 'green_background'*/
kform_struct *green_background_struct;  /* pass to xvf_set_attributes() */
int          green_background_selected; /* TRUE on <cr> for 'green_background' */
int          green_background_optsel;   /* TRUE if optional box of 'green_background' is ON */

float        blue_background;          /* float value of 'blue_background'*/
kform_struct *blue_background_struct;  /* pass to xvf_set_attributes() */
int          blue_background_selected; /* TRUE on <cr> for 'blue_background' */
int          blue_background_optsel;   /* TRUE if optional box of 'blue_background' is ON */

int          renderer_choice;          /* int value of 'renderer_choice'*/
char         *renderer_choice_label;   /* label representing int value of 'renderer_choice'*/
kform_struct *renderer_choice_struct;  /* pass to xvf_set_attributes() */
int          renderer_choice_selected; /* TRUE on <cr> for 'renderer_choice' */
int          renderer_choice_optsel;   /* TRUE if optional box of 'renderer_choice' is ON */

int          transparency_choice;          /* int value of 'transparency_choice'*/
char         *transparency_choice_label;   /* label representing int value of 'transparency_choice'*/
kform_struct *transparency_choice_struct;  /* pass to xvf_set_attributes() */
int          transparency_choice_selected; /* TRUE on <cr> for 'transparency_choice' */
int          transparency_choice_optsel;   /* TRUE if optional box of 'transparency_choice' is ON */

int          invoke_renderer;          /* boolean value of 'invoke_renderer'*/
char         *invoke_renderer_label;   /* label assoc w/ value of 'invoke_renderer'*/
kform_struct *invoke_renderer_struct;  /* pass to xvf_set_attributes() */
int          invoke_renderer_selected; /* TRUE on <cr> for 'invoke_renderer' */
int          invoke_renderer_optsel;   /* TRUE if optional box of 'invoke_renderer' is ON */

int          antialias;          /* boolean value of 'antialias'*/
char         *antialias_label;   /* label assoc w/ value of 'antialias'*/
kform_struct *antialias_struct;  /* pass to xvf_set_attributes() */
int          antialias_selected; /* TRUE on <cr> for 'antialias' */
int          antialias_optsel;   /* TRUE if optional box of 'antialias' is ON */

kform_struct *render_controls_label_struct; /* pass to xvf_set_attributes() */

kform_struct *blank1_struct; /* pass to xvf_set_attributes() */

} RenderMonster_Imaging;

/*
 * Pane Info Struct for 'Transformations' Pane
 */
typedef struct _RenderMonster_Transformations{

float        x_rotate;          /* float value of 'x_rotate'*/
kform_struct *x_rotate_struct;  /* pass to xvf_set_attributes() */
int          x_rotate_selected; /* TRUE on <cr> for 'x_rotate' */
int          x_rotate_optsel;   /* TRUE if optional box of 'x_rotate' is ON */

float        y_rotate;          /* float value of 'y_rotate'*/
kform_struct *y_rotate_struct;  /* pass to xvf_set_attributes() */
int          y_rotate_selected; /* TRUE on <cr> for 'y_rotate' */
int          y_rotate_optsel;   /* TRUE if optional box of 'y_rotate' is ON */

float        z_rotate;          /* float value of 'z_rotate'*/
kform_struct *z_rotate_struct;  /* pass to xvf_set_attributes() */
int          z_rotate_selected; /* TRUE on <cr> for 'z_rotate' */
int          z_rotate_optsel;   /* TRUE if optional box of 'z_rotate' is ON */

char         *center_point_string;         /* string for 'center_point_string'*/
kform_struct *center_point_string_struct;  /* pass to xvf_set_attributes() */
int          center_point_string_selected; /* TRUE on <cr> for 'center_point_string' */
int          center_point_string_optsel;   /* TRUE if optional box of 'center_point_string' is ON */

char         *translate_vector_string;         /* string for 'translate_vector_string'*/
kform_struct *translate_vector_string_struct;  /* pass to xvf_set_attributes() */
int          translate_vector_string_selected; /* TRUE on <cr> for 'translate_vector_string' */
int          translate_vector_string_optsel;   /* TRUE if optional box of 'translate_vector_string' is ON */

char         *xyz_scale_string;         /* string for 'xyz_scale_string'*/
kform_struct *xyz_scale_string_struct;  /* pass to xvf_set_attributes() */
int          xyz_scale_string_selected; /* TRUE on <cr> for 'xyz_scale_string' */
int          xyz_scale_string_optsel;   /* TRUE if optional box of 'xyz_scale_string' is ON */

int          transformation_mode;          /* boolean value of 'transformation_mode'*/
char         *transformation_mode_label;   /* label assoc w/ value of 'transformation_mode'*/
kform_struct *transformation_mode_struct;  /* pass to xvf_set_attributes() */
int          transformation_mode_selected; /* TRUE on <cr> for 'transformation_mode' */
int          transformation_mode_optsel;   /* TRUE if optional box of 'transformation_mode' is ON */

} RenderMonster_Transformations;

/*
 * Pane Info Struct for 'Input' Pane
 */
typedef struct _RenderMonster_Input{

char         *input_object_1;         /* filename for 'input_object_1'*/
kform_struct *input_object_1_struct;  /* pass to xvf_set_attributes() */
int          input_object_1_selected; /* TRUE on <cr> for 'input_object_1' */
int          input_object_1_optsel;   /* TRUE if optional box of 'input_object_1' is ON */

char         *input_object_2;         /* filename for 'input_object_2'*/
kform_struct *input_object_2_struct;  /* pass to xvf_set_attributes() */
int          input_object_2_selected; /* TRUE on <cr> for 'input_object_2' */
int          input_object_2_optsel;   /* TRUE if optional box of 'input_object_2' is ON */

char         *input_object_3;         /* filename for 'input_object_3'*/
kform_struct *input_object_3_struct;  /* pass to xvf_set_attributes() */
int          input_object_3_selected; /* TRUE on <cr> for 'input_object_3' */
int          input_object_3_optsel;   /* TRUE if optional box of 'input_object_3' is ON */

char         *input_object_4;         /* filename for 'input_object_4'*/
kform_struct *input_object_4_struct;  /* pass to xvf_set_attributes() */
int          input_object_4_selected; /* TRUE on <cr> for 'input_object_4' */
int          input_object_4_optsel;   /* TRUE if optional box of 'input_object_4' is ON */

} RenderMonster_Input;

/*
 * Pane Info Struct for 'Output' Pane
 */
typedef struct _RenderMonster_Output{

char         *output_image_fname;         /* filename for 'output_image_fname'*/
kform_struct *output_image_fname_struct;  /* pass to xvf_set_attributes() */
int          output_image_fname_selected; /* TRUE on <cr> for 'output_image_fname' */
int          output_image_fname_optsel;   /* TRUE if optional box of 'output_image_fname' is ON */

} RenderMonster_Output;

/*
 * Subform Info Struct for 'RenderMonster' Subform
 */
typedef struct _Master_RenderMonster {

kform_struct *license_struct; /* pass to xvf_set_attributes() */

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Quit' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

int          refresh;          /* TRUE when user clicks on 'refresh'*/
kform_struct *refresh_struct;  /* pass to xvf_set_attributes() */

kform_struct *b0_struct; /* pass to xvf_set_attributes() */

RenderMonster_Objects  *Objects;          /* ptr to Pane Info struct for pane 'Objects' */
int                   Objects_selected;          /* TRUE if input was from pane 'Objects' */
kform_struct          *Objects_struct;          /* pass to xvf_set_attributes() */

RenderMonster_Cameras  *Cameras;          /* ptr to Pane Info struct for pane 'Cameras' */
int                   Cameras_selected;          /* TRUE if input was from pane 'Cameras' */
kform_struct          *Cameras_struct;          /* pass to xvf_set_attributes() */

RenderMonster_Lights  *Lights;          /* ptr to Pane Info struct for pane 'Lights' */
int                  Lights_selected;          /* TRUE if input was from pane 'Lights' */
kform_struct         *Lights_struct;          /* pass to xvf_set_attributes() */

RenderMonster_Imaging  *Imaging;          /* ptr to Pane Info struct for pane 'Imaging' */
int                   Imaging_selected;          /* TRUE if input was from pane 'Imaging' */
kform_struct          *Imaging_struct;          /* pass to xvf_set_attributes() */

RenderMonster_Transformations  *Transformations;          /* ptr to Pane Info struct for pane 'Transformations' */
int                           Transformations_selected;          /* TRUE if input was from pane 'Transformations' */
kform_struct                  *Transformations_struct;          /* pass to xvf_set_attributes() */

RenderMonster_Input  *Input;          /* ptr to Pane Info struct for pane 'Input' */
int                 Input_selected;          /* TRUE if input was from pane 'Input' */
kform_struct        *Input_struct;          /* pass to xvf_set_attributes() */

RenderMonster_Output  *Output;          /* ptr to Pane Info struct for pane 'Output' */
int                  Output_selected;          /* TRUE if input was from pane 'Output' */
kform_struct         *Output_struct;          /* pass to xvf_set_attributes() */

}  Master_RenderMonster;

/*
 * Form Info Struct for 'Master' form
 */
typedef struct _gui_info_struct {

Master_RenderMonster  *RenderMonster;
int RenderMonster_selected;
kform_struct *RenderMonster_struct;


 } gui_info_struct; 

        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void _xvf_free_Master PROTO((gui_info_struct *));
void _xvf_get_Master  PROTO((gui_info_struct *));

int  _xvf_init_Master PROTO((kform *, gui_info_struct *));
void run_Master       PROTO((kform *, ksubform *, kaddr));

void run_RenderMonster      PROTO((Master_RenderMonster *));
void _xvf_get_RenderMonster PROTO((Master_RenderMonster *));
void RenderMonster_refresh	PROTO((Master_RenderMonster *));

void run_Objects      PROTO((RenderMonster_Objects *));
void _xvf_get_Objects PROTO((RenderMonster_Objects *));
void Objects_current_object	PROTO((RenderMonster_Objects *));
void Objects_object_shader	PROTO((RenderMonster_Objects *));
void Objects_post_obj	PROTO((RenderMonster_Objects *));
void Objects_obj_red	PROTO((RenderMonster_Objects *));
void Objects_obj_green	PROTO((RenderMonster_Objects *));
void Objects_obj_blue	PROTO((RenderMonster_Objects *));
void Objects_obj_alpha	PROTO((RenderMonster_Objects *));
void Objects_obj_ambient	PROTO((RenderMonster_Objects *));
void Objects_obj_diffuse	PROTO((RenderMonster_Objects *));
void Objects_obj_spec	PROTO((RenderMonster_Objects *));
void Objects_obj_spec_exp	PROTO((RenderMonster_Objects *));
void Objects_obj_spec_metal	PROTO((RenderMonster_Objects *));
void Objects_object_info	PROTO((RenderMonster_Objects *));
void Objects_action1	PROTO((RenderMonster_Objects *));

void run_Cameras      PROTO((RenderMonster_Cameras *));
void _xvf_get_Cameras PROTO((RenderMonster_Cameras *));
void Cameras_projection_cycle	PROTO((RenderMonster_Cameras *));
void Cameras_eye_x	PROTO((RenderMonster_Cameras *));
void Cameras_up_x	PROTO((RenderMonster_Cameras *));
void Cameras_at_x	PROTO((RenderMonster_Cameras *));
void Cameras_eye_y	PROTO((RenderMonster_Cameras *));
void Cameras_up_y	PROTO((RenderMonster_Cameras *));
void Cameras_at_y	PROTO((RenderMonster_Cameras *));
void Cameras_eye_z	PROTO((RenderMonster_Cameras *));
void Cameras_up_z	PROTO((RenderMonster_Cameras *));
void Cameras_at_z	PROTO((RenderMonster_Cameras *));
void Cameras_hither_clip_form_loc	PROTO((RenderMonster_Cameras *));
void Cameras_yon_clip_form_loc	PROTO((RenderMonster_Cameras *));
void Cameras_back_clip_form_on_off	PROTO((RenderMonster_Cameras *));
void Cameras_fov_input	PROTO((RenderMonster_Cameras *));
void Cameras_aspect	PROTO((RenderMonster_Cameras *));
void Cameras_normalize_cam	PROTO((RenderMonster_Cameras *));
void Cameras_reset_camera	PROTO((RenderMonster_Cameras *));

void run_Lights      PROTO((RenderMonster_Lights *));
void _xvf_get_Lights PROTO((RenderMonster_Lights *));
void Lights_light_list	PROTO((RenderMonster_Lights *));
void Lights_light_onoff	PROTO((RenderMonster_Lights *));
void Lights_light_type_list	PROTO((RenderMonster_Lights *));
void Lights_light_position_string	PROTO((RenderMonster_Lights *));
void Lights_light_direction_string	PROTO((RenderMonster_Lights *));
void Lights_current_light_color_string	PROTO((RenderMonster_Lights *));
void Lights_ambient_light_color_string	PROTO((RenderMonster_Lights *));

void run_Imaging      PROTO((RenderMonster_Imaging *));
void _xvf_get_Imaging PROTO((RenderMonster_Imaging *));
void Imaging_image_width	PROTO((RenderMonster_Imaging *));
void Imaging_image_height	PROTO((RenderMonster_Imaging *));
void Imaging_image_display_choice	PROTO((RenderMonster_Imaging *));
void Imaging_red_background	PROTO((RenderMonster_Imaging *));
void Imaging_green_background	PROTO((RenderMonster_Imaging *));
void Imaging_blue_background	PROTO((RenderMonster_Imaging *));
void Imaging_renderer_choice	PROTO((RenderMonster_Imaging *));
void Imaging_transparency_choice	PROTO((RenderMonster_Imaging *));
void Imaging_invoke_renderer	PROTO((RenderMonster_Imaging *));
void Imaging_antialias	PROTO((RenderMonster_Imaging *));

void run_Transformations      PROTO((RenderMonster_Transformations *));
void _xvf_get_Transformations PROTO((RenderMonster_Transformations *));
void Transformations_x_rotate	PROTO((RenderMonster_Transformations *));
void Transformations_y_rotate	PROTO((RenderMonster_Transformations *));
void Transformations_z_rotate	PROTO((RenderMonster_Transformations *));
void Transformations_center_point_string	PROTO((RenderMonster_Transformations *));
void Transformations_translate_vector_string	PROTO((RenderMonster_Transformations *));
void Transformations_xyz_scale_string	PROTO((RenderMonster_Transformations *));
void Transformations_transformation_mode	PROTO((RenderMonster_Transformations *));

void run_Input      PROTO((RenderMonster_Input *));
void _xvf_get_Input PROTO((RenderMonster_Input *));
void Input_input_object_1	PROTO((RenderMonster_Input *));
void Input_input_object_2	PROTO((RenderMonster_Input *));
void Input_input_object_3	PROTO((RenderMonster_Input *));
void Input_input_object_4	PROTO((RenderMonster_Input *));

void run_Output      PROTO((RenderMonster_Output *));
void _xvf_get_Output PROTO((RenderMonster_Output *));
void Output_output_image_fname	PROTO((RenderMonster_Output *));




#endif /* _form_info_h_ */ 
/* Don't add after this point */
