 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane Imaging
   >>>> 
   >>>>  Private: 
   >>>> 	Imaging_image_width
   >>>> 	Imaging_image_height
   >>>> 	Imaging_image_display_choice
   >>>> 	Imaging_red_background
   >>>> 	Imaging_green_background
   >>>> 	Imaging_blue_background
   >>>> 	Imaging_renderer_choice
   >>>> 	Imaging_transparency_choice
   >>>> 	Imaging_invoke_renderer
   >>>> 	Imaging_antialias
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "rmonster.h"
#include "imaging.h"

/*-----------------------------------------------------------
| 
|  Routine Name: Imaging_image_width
| 
|       Purpose: Do routine which is called when
|                  integer selection image_width is used
| 
|         Input: Imaging_info - ptr to PaneInfo struct for Imaging pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Imaging_image_width(
     RenderMonster_Imaging *Imaging_info)
{
	/* PUT YOUR CODE HERE ! */
    change_image_width(Imaging_info->image_width);
}


/*-----------------------------------------------------------
| 
|  Routine Name: Imaging_image_height
| 
|       Purpose: Do routine which is called when
|                  integer selection image_height is used
| 
|         Input: Imaging_info - ptr to PaneInfo struct for Imaging pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Imaging_image_height(
     RenderMonster_Imaging *Imaging_info)
{
	/* PUT YOUR CODE HERE ! */
    change_image_height(Imaging_info->image_height);
}


/*-----------------------------------------------------------
| 
|  Routine Name: Imaging_image_display_choice
| 
|       Purpose: Do routine which is called when
|                  list selection image_display_choice is used
| 
|         Input: Imaging_info - ptr to PaneInfo struct for Imaging pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Imaging_image_display_choice(
     RenderMonster_Imaging *Imaging_info)
{
	/* PUT YOUR CODE HERE ! */
    int new_val;
    /* new_val = Imaging_info->image_display_choice - 1; */
    new_val = Imaging_info->image_display_choice;
    set_image_display_choice(new_val);
    init_render_buffers();
    reinit_output_object(TRUE, FALSE);

    /* -- sad if geometry takes long to render, but better then befuddled
       users staring at the screen waiting -- */
    renderer_invoke_func();
}


/*-----------------------------------------------------------
| 
|  Routine Name: Imaging_red_background
| 
|       Purpose: Do routine which is called when
|                  float selection red_background is used
| 
|         Input: Imaging_info - ptr to PaneInfo struct for Imaging pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Imaging_red_background(
     RenderMonster_Imaging *Imaging_info)
{
	/* PUT YOUR CODE HERE ! */
    float r,g,b,t;
    get_background_color(&r,&g,&b);
    t = Imaging_info->red_background;
    set_background_color(t,g,b);
}


/*-----------------------------------------------------------
| 
|  Routine Name: Imaging_green_background
| 
|       Purpose: Do routine which is called when
|                  float selection green_background is used
| 
|         Input: Imaging_info - ptr to PaneInfo struct for Imaging pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Imaging_green_background(
     RenderMonster_Imaging *Imaging_info)
{
	/* PUT YOUR CODE HERE ! */
    float r,g,b;
    get_background_color(&r,&g,&b);
    g = Imaging_info->green_background;
    set_background_color(r,g,b);
}


/*-----------------------------------------------------------
| 
|  Routine Name: Imaging_blue_background
| 
|       Purpose: Do routine which is called when
|                  float selection blue_background is used
| 
|         Input: Imaging_info - ptr to PaneInfo struct for Imaging pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Imaging_blue_background(
     RenderMonster_Imaging *Imaging_info)
{
	/* PUT YOUR CODE HERE ! */
    float r,g,b;
    get_background_color(&r,&g,&b);
    b = Imaging_info->blue_background;
    set_background_color(r,g,b);
}


/*-----------------------------------------------------------
| 
|  Routine Name: Imaging_renderer_choice
| 
|       Purpose: Do routine which is called when
|                  list selection renderer_choice is used
| 
|         Input: Imaging_info - ptr to PaneInfo struct for Imaging pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Imaging_renderer_choice(
     RenderMonster_Imaging *Imaging_info)
{
	/* PUT YOUR CODE HERE ! */
    int i,active;
    i = Imaging_info->renderer_choice - 1;

    /* check to see if the new renderer choice is different from the
       currently active renderer. */
    active = get_active_renderer();

    /* if so, shut down the old one */
    if (i != active)
    {
        renderer_shutdown_func();

        /* and fire up the new one */
        set_active_renderer(i);
        renderer_init_func();
/*      init_imaging_pane(Imaging_info); */
    }
}


/*-----------------------------------------------------------
| 
|  Routine Name: Imaging_transparency_choice
| 
|       Purpose: Do routine which is called when
|                  list selection transparency_choice is used
| 
|         Input: Imaging_info - ptr to PaneInfo struct for Imaging pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Imaging_transparency_choice(
     RenderMonster_Imaging *Imaging_info)
{
	/* PUT YOUR CODE HERE ! */
}


/*-----------------------------------------------------------
| 
|  Routine Name: Imaging_invoke_renderer
| 
|       Purpose: Do routine which is called when
|                  logical selection invoke_renderer is used
| 
|         Input: Imaging_info - ptr to PaneInfo struct for Imaging pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Imaging_invoke_renderer(
     RenderMonster_Imaging *Imaging_info)
{
	/* PUT YOUR CODE HERE ! */
}


/*-----------------------------------------------------------
| 
|  Routine Name: Imaging_antialias
| 
|       Purpose: Do routine which is called when
|                  logical selection antialias is used
| 
|         Input: Imaging_info - ptr to PaneInfo struct for Imaging pane
| 
|        Output: None
|    Written By: 
|          Date: Apr 11, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void Imaging_antialias(
     RenderMonster_Imaging *Imaging_info)
{
	/* PUT YOUR CODE HERE ! */
}

init_imaging_pane(RenderMonster_Imaging *im)
{
    float r,g,b;
    int display_mode,w,h;
    int n,i, depth;
    renderer_struct **rndr,*rnd;

    get_background_color(&r,&g,&b);

    /* set RGB background sliders to init values. */
    xvf_set_attribute(im->red_background_struct,
                   XVF_FLOAT_VAL,
                   r);

    xvf_set_attribute(im->green_background_struct,
                   XVF_FLOAT_VAL,
                   g);


    xvf_set_attribute(im->blue_background_struct,
                   XVF_FLOAT_VAL,
                   b);

    /**
      * set the renderer choices UI list.
    **/

    get_all_renderers_info(&n,&rndr);

    /* we'll assume (naively) for now that the default renderer is
       in r[0], and set up the UI to reflect that fact. */

    xvf_set_attribute(im->renderer_choice_struct,
                      XVF_LIST_DELETEALL,
                      TRUE);  /* wipe the list clean */

    for (i=0;i<n;i++)
        xvf_set_attribute(im->renderer_choice_struct,
                          XVF_LIST_ADD,
                          rndr[i]->renderer_name);

    if (n > 1)
        xvf_set_attribute(im->renderer_choice_struct,
                          XVF_ACTIVATE,TRUE);
    else
        xvf_set_attribute(im->renderer_choice_struct,
                          XVF_ACTIVATE,FALSE);

    /* set image display mode for the current active renderer  */

    n = get_active_renderer();

    xvf_set_attribute(im->image_display_choice_struct,
                      XVF_LIST_DELETEALL,
                      TRUE);  /* wipe the list clean */

    get_display_depth(&depth);

    /* -- add all the displays, but don't add 24 bit if we can't do it -- */
    for (i=0;i<rndr[n]->ndisplay_options;i++)
    {
       if (i == s24_DISPLAY && depth != 24) 
       {
	  xvf_set_attribute(im->image_display_choice_struct,
			    XVF_LIST_ADD, "DISPLAY DOESN'T SUPPORT 24 BIT");
	  i++;
       }
       
       xvf_set_attribute(im->image_display_choice_struct,
			       XVF_LIST_ADD,
			 rndr[n]->display_options_txt[i]);
    }


    /* at some point, we might want per-renderer display options,
     but for now (14 march 95) all renderers will display their images
     in the same way, as much as is possible.  see also imaging.h.  */

/*    display_mode = rndr[n]->selected_display_option; */
    get_image_display_choice(&display_mode);

    if (display_mode > 0)
    {
       xvf_set_attribute(im->image_display_choice_struct,
			 XVF_LIST_VAL, 
			 display_mode);

       im->image_display_choice = display_mode;
    }


    get_image_dims(&w,&h);
    xvf_set_attribute(im->image_width_struct,
                      XVF_INT_VAL,
                      w);

    xvf_set_attribute(im->image_height_struct,
                      XVF_INT_VAL,
                      h);

    /* disable various things that aren't ready yet. */

    xvf_set_attribute(im->transparency_choice_struct,
                      XVF_ACTIVATE,FALSE);

    xvf_set_attribute(im->antialias_struct,
                      XVF_ACTIVATE,FALSE);

    xvf_set_attribute(im->invoke_renderer_struct,
                      XVF_ACTIVATE,FALSE);

    /** call routine to determine if graphics hardware is available on this
      machine.  if not, disable the "renderer_choice" field.  in the future,
      we may want to allow more options than just "hardware" and "software" **/
#if 0
    if (have_graphics_hardware() == FALSE)
    {
        xvf_set_attribute(im->renderer_choice_struct,
                          XVF_ACTIVATE, FALSE);
    }
    else
    {
        xvf_set_attribute(im->renderer_choice_struct,
                          XVF_ACTIVATE,TRUE);
    }
#endif
   return(CHILL);
}

int
repaint_imaging_pane()
{
    RenderMonster_Imaging *t;

    /* a good way to break this code is to rearrange the GUI for rmonster. */
    t = gui_info->RenderMonster->Imaging;
    init_imaging_pane(t);
    return(CHILL);
}
