
/*####################################################################

Copyright (C) 1994, 1995 Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus is is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory

  "this software is nearly 100% hand-crafted by a human being in the USA"

####################################################################*/
 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


#include "internals.h"

/****************************************************************
* 
*  Routine Name: lset_common_geom_attributes()
* 
*       Purpose: keep common set_attribute calls in one place, to be
*                used when opening geom objects
*         Input: kobject - the target object for set attribute calls
*        Output: none
*       Returns: CHILL
*  Restrictions: 
*    Written By: wes
*          Date: 8 aug 94
*      Verified: 
*  Side Effects: The settings done here must be valid for both read and
*                write operations (ie, don't blow a hole in your foot).
* Modifications:
*
*      Comments: attributes set:
*                KGEOM_LOCATION_SIZE, 3
*                KGEOM_LOCATION_DATA_TYPE, KFLOAT
*                KGEOM_COLOR_DATA_TYPE, KFLOAT
*                KGEOM_RADIUS_DATA_TYPE, KFLOAT
*                KGEOM_COLORSPACE, KRGB
*                KGEOM_TEXTURE_COORD_SIZE - KFLOAT
*
*
****************************************************************/
/* -library_def */
int lset_common_geom_attributes(kobject k)
/* -library_def_end */

/* -library_code */
{
    /* location data */
    kgeom_set_attribute(k,KGEOM_OBJECT,KGEOM_LOCATION_DATA_TYPE,KFLOAT);
    kgeom_set_attribute(k,KGEOM_OBJECT,KGEOM_LOCATION_SIZE,3);
    
    /* color data */
    kgeom_set_attribute(k,KGEOM_OBJECT,KGEOM_COLOR_DATA_TYPE,KFLOAT);
    kgeom_set_attribute(k,KGEOM_OBJECT,KGEOM_COLORSPACE,KRGB);

    /* radius data */
    kgeom_set_attribute(k,KGEOM_OBJECT,KGEOM_RADIUS_DATA_TYPE,KFLOAT);

    /* normals */
    kgeom_set_attribute(k,KGEOM_OBJECT,KGEOM_NORMAL_DATA_TYPE,KFLOAT); 

    /* texture coords */
    kgeom_set_attribute(k,KGEOM_OBJECT,KGEOM_TEXTURE_COORD_DATA_TYPE,KFLOAT);
/*    kgeom_set_attribute(k,KGEOM_OBJECT,KGEOM_TEXTURE_COORD_SIZE,0); */

    return(TRUE);
}
