 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Library Routine for glinecolor
   >>>> 
   >>>>  Private: 
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 	lglinecolor
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"

/* -library_includes */
#include "geometry/vis_cmap.h"
static void get_colored_segments	PROTO((int, kfile *, kobject , int ,
		     			       vertex_3d *, vertex_3d *,
		     			       vis_cmap *));
/* -library_includes_end */


/****************************************************************
* 
*  Routine Name: lglinecolor - *
* 
*       Purpose: This should be a complete description that anyone
*                could understand;  it should have acceptable grammar
*                and correct spelling.
*
*         Input: argument1 - explanation
*                argument2 - explanation
*                argument3 - explanation
*
*        Output: argument4 - explanation
*                argument5 - explanation
*
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions: Restrictions on data or input as applicable
*    Written By: 
*          Date: Apr 13, 1995
*      Verified: 
*  Side Effects: 
* Modifications: 
****************************************************************/
/* -library_def */
int lglinecolor(kfile *infile,
		kobject vis_cmap_obj,
		kobject outobj,
		char *name)
/* -library_def_end */

/* -library_code */
{
    int nsegs,seq_no;
    int i,result;
    vertex_3d bmin,bmax,center;
    vis_cmap lmap;

    /* try to convert the vis_cmap_obj to a vis_map */
    result = lkobj_to_vismap(vis_cmap_obj,&lmap);
    if (result == WHACKED)  /* assume the library routne barked at the user */
	return(WHACKED);
    
    /* set up the output object */
    kgeom_set_attribute(outobj,KGEOM_OBJECT,KGEOM_NAME,name);
    kgeom_create_primitive_list(outobj);
    kgeom_set_attribute(outobj,KGEOM_OBJECT,KGEOM_NUMBER_PRIMITIVES,1);
    kgeom_set_attribute(outobj,KGEOM_OBJECT,KGEOM_LAYOUT,KPER_VERTEX);
    kgeom_set_attribute(outobj,KGEOM_OBJECT,KGEOM_HAS_ALPHA,TRUE);
    
    lset_common_geom_attributes(outobj);

    kfscanf(infile,"%d",&nsegs);
    seq_no = 0;

    for (i=0;i<3;i++)
    {
	bmin.v[i] = KGEOM_BIGNUM;
	bmax.v[i] = KGEOM_SMALLNUM;
    }
    
    while (!kfeof(infile))
    {
	get_colored_segments(nsegs,infile,outobj,seq_no,&bmin,&bmax,&lmap);
	kfscanf(infile,"%d",&nsegs);
	seq_no++;
    }

    for (i=0;i<3;i++)
	center.v[i] = bmin.v[i] + (bmax.v[i] - bmin.v[i]) * 0.5;


    kgeom_set_attribute(outobj,KGEOM_OBJECT,KGEOM_BOUNDING_BOX,&(bmin.v[0]),&(bmax.v[0]));
    kgeom_set_attribute(outobj,KGEOM_OBJECT,KGEOM_CENTER,&(center.v[0]));

    return TRUE;
}

static void
get_colored_segments(int nverts,
		     kfile *infile,
		     kobject outobj,
		     int prim_no,
		     vertex_3d *min,
		     vertex_3d *max,
		     vis_cmap *lmap)
{
    int i,j;
    vertex_3d *v,*v1;
    float *c,*c1;
    float scalar;
    int index;

    v = v1 = kmalloc(sizeof(vertex_3d)*nverts);
    c = c1 = kmalloc(sizeof(float)*nverts*4);
    
    for (i=0;i<nverts;i++,v++,c+=4)
    {
	kfscanf(infile,"%f %f %f %f",&(v->v[0]),&(v->v[1]),&(v->v[2]),&scalar);
	for (j=0;j<3;j++)
	{
	    if (v->v[j] > max->v[j])
		max->v[j] = v->v[j];
	    if (v->v[j] < min->v[j])
		min->v[j] = v->v[j];
	}

	index = lget_map_index(lmap,&scalar);
	lget_map_rgba(lmap,index,c,c+1,c+2,c+3);
    }
    
    kgeom_set_attribute(outobj,KGEOM_OBJECT,KGEOM_NUMBER_PRIMITIVES,prim_no+1);
    kgeom_set_attribute(outobj,KGEOM_POLYLINE_CONNECTED,KGEOM_NUMBER_VERTICES,nverts);
    kgeom_put_data(outobj,KGEOM_POLYLINE_CONNECTED,v1,c1);

    kfree(v1);
    kfree(c1);
}
/* -library_code_end */
