 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Library Routine for gcolorize
   >>>> 
   >>>>  Private: 
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 	lgcolorize
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"

/* -library_includes */
/* -library_includes_end */


/****************************************************************
* 
*  Routine Name: lgcolorize - *
* 
*       Purpose: This function is used to map value data from an input
*                data object through a vis colormap.  Each value in
*                the input value segment will be used as an index into
*                the vis colormap.  The output value element vectors
*                will be replaced with the indexed map vectors from
*                the vis colormap.  This routine is somewhat old and
*		 
*
*         Input: 
*        Output: *
*       Returns: CHILL (1) on success, WHACKED (0) on failure
*  Restrictions: 
*    Written By: Steve Kubica
*          Date: Apr 13, 1995
*      Verified: 
*  Side Effects: 
* Modifications: 
****************************************************************/
/* -library_def */
int lgcolorize (
   kobject input,
   kobject map_object,
   kobject output)
/* -library_def_end */

/* -library_code */
{
   vis_cmap *map;
   int oldw, oldh, oldd, oldt, olde, newe;
   float *fdata = NULL, *f;
   int    ind; 
   int num_elements, i;
   float *odata;
   float *r, *g, *b, *a;

   map = (vis_cmap *) kmalloc(sizeof(vis_cmap));

   /* -- retreive vis_cmap structure from data object -- */
   if (lkobj_to_vismap(map_object, map) == WHACKED)
   {
      kerror("geometry","lgcolorize",
             "Unable to convert map kobject into visualization colormap");
      return(WHACKED);
   }
   if (!map)
   {
      kerror("geometry","lgcolorize",
             "Visualization colormap is Whacked.");
      return(WHACKED);
   }

   if (!kpds_query_value(input))
   {
      kerror("geometry","lgcolorize",
             "Input object must contain value data.");
      return(WHACKED);
   }


   /* -- retrieve all value data as integers -- */
   kpds_set_attribute(input,KPDS_VALUE_DATA_TYPE, KFLOAT);

   /* -- get size of value segment -- */
   kpds_get_attribute(input,KPDS_VALUE_SIZE,
		      &oldw, &oldh, &oldd, &oldt, &olde);

   /* -- expand esize by 4 - enough for RGBa per element -- */
   newe = olde * 4;  

   /* -- tell vis stuff that we have RGBalpha */
   kcolor_set_attribute(output, KCOLOR_COLORSPACE, KRGB);
   kcolor_set_attribute(output, KCOLOR_HAS_ALPHA, TRUE);

   /* -- set output size -- */
   kpds_set_attribute(output,KPDS_VALUE_SIZE, 
                             oldw, oldh, oldd, oldt, newe );

   /* -- output data type will match the data type of the vis_cmap -- */
   kpds_set_attribute(output,KPDS_VALUE_DATA_TYPE, KFLOAT);

   /* -- get all the value data -- */
   fdata = kpds_get_data(input, KPDS_VALUE_ALL, NULL); 

   num_elements = oldw*oldh*oldd*oldt;
   
   /* -- space in which to put output data -- */
   odata = kmalloc(num_elements*olde*4* kdata_size(KFLOAT));

   r = odata;
   g = r + num_elements;
   b = g + num_elements;
   a = b + num_elements;
   
   for (i = 0, f = fdata; i < num_elements*olde; i++, f++)
   {
      int blah = lget_map_index(map, f);
      float rv, gv, bv, av;
      
      lget_map_rgba(map,blah,&rv,&gv,&bv,&av);

      *r++ = rv;
      *g++ = gv;
      *b++ = bv;
      *a++ = av;
   }

   kpds_put_data(output, KPDS_VALUE_ALL, odata); 

   /* -- xvisual needs these --*/
   kdms_copy_attributes(map_object, output, NULL,
			KCOLOR_ALPHA_MIN, KCOLOR_ALPHA_MAX, NULL);

   return(CHILL);
}
/* -library_code_end */
