 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for gtubeness
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "gtubeness.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Replace Lines with Tesselated Cylinders
|
|       Purpose: main program for gtubeness
|
|         Input:
|		char *clui_info->i_file; {Input geometry object.}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {Tube-ified geometry object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		float clui_info->scale_float; {A scalar which indicates the radius of the tube.}
|		int   clui_info->scale_flag; {TRUE if -scale specified}
|
|		int clui_info->subdivisions_int; {number onumber of sides for each tube will be 2 << (subdivisions - 1).}
|		int clui_info->subdivisions_flag; {TRUE if -subdivisions specified}
|
|		int   clui_info->cap_style_list; {A list of choices for possible methods for capping the tubes.}
|		char *clui_info->cap_style_label;
|		int   clui_info->cap_style_flag; {TRUE if -cap_style specified}
|
|        Output:
|       Returns:
|
|    Written By: wes
|          Date: Apr 13, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject input,output;
	int status;
	char *name=NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "GEOMETRY");
	kexit_handler(gtubeness_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "GEOMETRY", "gtubeness",
		gtubeness_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	gtubeness_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	input = kgeom_open_object(clui_info->i_file,KOBJ_READ);
	status = kgeom_get_attribute(input,KGEOM_OBJECT,KGEOM_NAME,&name);
	if (status == FALSE)
	{
	    kerror(NULL,"gtubeness","Can't get the NAME attribute from the input object <%s>.  Maybe it's not a GEOM file?\n",clui_info->i_file);
	    kpds_close_object(input);
	    kexit(KEXIT_FAILURE);
	}

	output = kgeom_open_output_object(clui_info->o_file);
/* -main_before_lib_call_end */

/* -main_library_call */
	lgtubeness(input,output,clui_info->scale_float,
		   clui_info->subdivisions_int,
		   clui_info->cap_style_list);
/* -main_library_call_end */

/* -main_after_lib_call */
	kpds_close_object(input);
	kpds_close_object(output);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: gtubeness_usage_additions
| 
|       Purpose: Prints usage additions in gtubeness_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gtubeness
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void gtubeness_usage_additions(void)
{
	kfprintf(kstderr, "\tReplace Lines with Tesselated Cylinders\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: gtubeness_free_args
| 
|       Purpose: Frees CLUI struct allocated in gtubeness_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gtubeness
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
gtubeness_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
	kfree(clui_info->cap_style_label);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
