 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for gprgeom
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "gprgeom.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Print ASCII Report of Geometry Input
|
|       Purpose: main program for gprgeom
|
|         Input:
|		char *clui_info->i_file; {input geometry object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		int clui_info->att_logic; {print attributes?}
|		int clui_info->att_flag; {TRUE if -att specified}
|
|		int clui_info->loc_flag; {TRUE if -loc specified}
|
|		int clui_info->color_flag; {TRUE if -color specified}
|
|		int clui_info->normrad_flag; {TRUE if -normrad specified}
|
|		int clui_info->tc_flag; {TRUE if -tc specified}
|
|		char *clui_info->o_file; {output ASCII text file}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 13, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
    kobject input;
    kfile *output;
    int do_loc,do_norm_radii,do_color,do_att,do_texture_coords;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "GEOMETRY");
	kexit_handler(gprgeom_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "GEOMETRY", "gprgeom",
		gprgeom_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	gprgeom_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
    input = kgeom_open_object(clui_info->i_file,KOBJ_READ);
    if (clui_info->o_flag)
	output = kfopen(clui_info->o_file,"w");
    else
	output = kstdout;
    do_att = clui_info->att_logic;

    do_loc = clui_info->loc_flag;
    do_color = clui_info->color_flag;
    do_norm_radii = clui_info->normrad_flag;
    do_texture_coords = clui_info->tc_flag;
/* -main_before_lib_call_end */

/* -main_library_call */
    kprgeom_util(input,output,do_att,do_loc,do_color,do_norm_radii,do_texture_coords);
/* -main_library_call_end */

/* -main_after_lib_call */
    kgeom_close_object(input);

    if (output != kstdout)
	kfclose(output);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: gprgeom_usage_additions
| 
|       Purpose: Prints usage additions in gprgeom_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gprgeom
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void gprgeom_usage_additions(void)
{
	kfprintf(kstderr, "\tPrint ASCII Report of Geometry Input\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: gprgeom_free_args
| 
|       Purpose: Frees CLUI struct allocated in gprgeom_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gprgeom
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
gprgeom_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
