 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for gflipnorms
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "gflipnorms.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Flip all Normals in a Geometry Object.
|
|       Purpose: main program for gflipnorms
|
|         Input:
|		char *clui_info->i_file; {input object containing normals}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {resulting output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 13, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject in;
	kobject out;

	float *normals = NULL;
	float *n;
	
	int *size;
	int  pres_size[4] = {1,1,1,1};
	int  beg[4] = {0,0,0,0};
	int  end[4] = {0,0,0,0};
	int  i;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "GEOMETRY");
	kexit_handler(gflipnorms_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "GEOMETRY", "gflipnorms",
		gflipnorms_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	gflipnorms_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	in  = kdms_open(clui_info->i_file, KOBJ_READ);
	out = kdms_open(clui_info->o_file, KOBJ_WRITE);

	if (in == NULL)
	{
	   kerror(NULL, "gflipnorms", "Unable to open input %s",
		  clui_info->i_file);
	   kexit(KEXIT_FAILURE);
	}

	if (out == NULL)
	{
	   kerror(NULL, "gflipnorms", "Unable to open output %s",
		  clui_info->o_file);
	   kexit(KEXIT_FAILURE);
	}
/* -main_before_lib_call_end */

/* -main_library_call */
	/*
	 *
	 *  WARNING : This code uses low-level data management services
	 *            and is difficult to read, and possibly flaky.
	 *            it capitalizes on the internal storage form of
	 *            geometry data and by-passes geometry data services.
	 *
	 *  Apologies .. this code is a test to see if this will work,
	 *               and is included in the release only because 
	 *               it is useful .. in the future this code will
	 *               be dramatically cleaned up ... possibly 
	 *               a segment-based interface to geometry services
	 */

	/* -- copy over all the input source data -- */
	if (!kdms_copy_object(in, out, TRUE, TRUE))
	{
	   kerror(NULL, "gflipnorms", "Failed to propogate input to output");
	   kexit(KEXIT_FAILURE);
	}
	   
	/* -- if we don't have normals, then we're done, aren't we? ;-) -- */
	if (!kdms_query_segment(in, "normal"))
	{
	   kdms_close(in);
	   kdms_close(out);
	   kexit(KEXIT_SUCCESS);
	}

	/* -- process input as floating point -- */
	kdms_set_attribute(in, "normal", KDMS_DATA_TYPE, KFLOAT);

	/* -- get the input size -- */
	kdms_get_attribute(in, "normal", KDMS_SIZE, &size);

	/* -- proces as 3-tuples -- */
	pres_size[0] = 3;
	pres_size[1] = size[1]; /* don't change */
	kdms_set_attribute(in, "normal", KDMS_SIZE, pres_size);
	
	/* -- get the normal data -- */
	beg[0] = 0;  end[0] = size[0] - 1; 
	beg[1] = 0;  end[1] = size[1] - 1;
	normals = kdms_get_data(in, "normal", beg, end, NULL);

	if (normals == NULL)
	{
	   kdms_close(in);
	   kdms_close(out);
	   kerror(NULL, "gflipnorms", "Unable to retrieve normal data");
	   kexit(KEXIT_FAILURE);
	}

	
	for (i = 0, n = normals; i < size[1]*size[0]; i++, n++)
	{
	   /* -- really naive way to flip normals :-[ -- */
	   *n *= -1;
	}

	/* -- store the flipped normals -- */
	kdms_put_data(out, "normal", beg, end, normals);
/* -main_library_call_end */

/* -main_after_lib_call */
	kdms_close(in);
	kdms_close(out);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: gflipnorms_usage_additions
| 
|       Purpose: Prints usage additions in gflipnorms_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gflipnorms
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void gflipnorms_usage_additions(void)
{
	kfprintf(kstderr, "\tFlip all Normals in a Geometry Object.\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: gflipnorms_free_args
| 
|       Purpose: Frees CLUI struct allocated in gflipnorms_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname gflipnorms
|          Date: Apr 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
gflipnorms_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
