
/*********************************************************************

Copyright (C) 1993, 1994 Lawrence Berkeley Laboratory.  All Rights
Reserved.  Permission to copy and modify this software and its
documentation (if any) is hereby granted, provided that this notice
is retained thereon and on all copies.  

This software is provided as a professional academic contribution
for joint exchange.   Thus is is experimental and scientific
in nature, undergoing development, and is provided "as is" with
no warranties of any kind whatsoever, no support, promise of
updates or printed documentation.

This work is supported by the U. S. Department of Energy under 
contract number DE-AC03-76SF00098 between the U. S. Department 
of Energy and the University of California.


	Author: Wes Bethel
		Lawrence Berkeley Laboratory

  "this software is nearly 100% hand-crafted by a human being in the USA"

*********************************************************************/
/**
  * this header file contains the structure definition for
  * a "visualization" colormap.  this colormap has not only
  * color data, but also information necessary for mapping from
  * data space to an index in this color table.
  *
  * for now, the "vis" colormap is in RGBA space. 
  *
  * the data-to-color information consists of a list of
  * values which form "bracket" values.  if the number of
  * colors in a map is N, then N+1 bracket values are required.
  *
  * future work:
  *
  * use khoros data types instead of plain old "float", etc.
  *
  *
  * may 1993
  *
  * january 1995
  *   - fixed vis_cmap.bracket off by one.  kevin
  *
  * w.bethel
  * berkeley, california
**/

#ifndef _geometry_vis_cmap_h_
#define _geometry_vis_cmap_h_

#include <design.h>

#define MAX_VIS_CMAP_ENTRIES 512

static char vis_map_cookie[]={"khoros_visualization_colormap 1.0"};

typedef struct vis_cmap
{
    int nentries;
    float r[MAX_VIS_CMAP_ENTRIES];
    float g[MAX_VIS_CMAP_ENTRIES];
    float b[MAX_VIS_CMAP_ENTRIES];
    float a[MAX_VIS_CMAP_ENTRIES];
    float bracket[MAX_VIS_CMAP_ENTRIES+1];
} vis_cmap;

/** routine proto's for going to/from this structure to VIFF **/
int	lvismap_to_kobj	PROTO ((vis_cmap *, kobject)); 
int	lkobj_to_vismap	PROTO ((kobject, vis_cmap *));

/** utility routines **/
int lget_map_index PROTO ((vis_cmap *, float *));
void lget_map_rgba PROTO ((vis_cmap *, int, float *, float *, float *, float *));

#endif  /* _geometry_vis_cmap_h_ */
/* Don't add after this point */
