 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for xprism
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "xprism.h"

clui_info_struct *clui_info = NULL;

gui_info_struct *gui_info;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Interactive 2D & 3D Plotting
|
|       Purpose: main program for xprism
|
|         Input:
|		char *clui_info->i1_file; {Input plot 1}
|		int   clui_info->i1_flag; {TRUE if -i1 specified}
|
|		char *clui_info->i2_file; {Input plot 2}
|		int   clui_info->i2_flag; {TRUE if -i2 specified}
|
|		char *clui_info->i3_file; {Input plot 3}
|		int   clui_info->i3_flag; {TRUE if -i3 specified}
|
|		char *clui_info->i4_file; {Input plot 4}
|		int   clui_info->i4_flag; {TRUE if -i4 specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *form;            /* form tree representing *.form file */
	char   *form_filestring; /* *.form file for xprism    */ 
	char   *form_pathname;   /* location of xprism.form   */
	char   *form_fullpath;   /* expanded xprism.form path */
	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "ENVISION");
	kexit_handler(xprism_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_XVROUTINE, "ENVISION", "xprism",
		xprism_usage_additions);

	xprism_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

	/*
	 * Initialize xvwidgets lib
	 */
	if (!(xvw_initialize(XVW_MENUS_XVFORMS)))
	{
	     kinfo(KSTANDARD, "Could not open connection to server");
	     kexit(KEXIT_FAILURE);
	}

	/*
	 * Set location of xprism.form
	 */
	if (clui_info->form_flag)
	{
	    form_filestring = kstrdup(clui_info->form_file);
	    form_pathname   = NULL;
	}
	else
	{
	    form_filestring = kstrdup("xprism.form");
	    form_pathname   = kstrdup("$TOOLBOX/objects/xvroutine/xprism/uis");
	}
	form_fullpath   = kfullpath(form_filestring, form_pathname, NULL);

	/*
	 * Allocate the GUI Info structure 
	 */
	gui_info = (gui_info_struct *)
				kcalloc (1, sizeof (gui_info_struct));
	/*
	 * Create the forms for xprism 
	 */
	form = xvf_create_form(form_fullpath, NONE, run_xprism, gui_info,
				clui_info->x_int, clui_info->y_int,
				XVF_PARTIAL_EDIT);
	if (form == NULL)
	   kexit(KEXIT_FAILURE);

	/*
	 * Initialize the GUI Info structure 
	 */
	if (!(_xvf_init_xprism(form, gui_info)))
	    kexit(KEXIT_FAILURE);

/* -main_before_lib_call */

	/*
	 * set up function pane GUI according to 2D/3D
	 */
	set_function_pane_gui();

	/*
	 * need to set area_list, plot_list to NULL on quit
	 */
	area_list = gui_info->Options->options->area_list_struct;
	plot_list = gui_info->Options->options->plot_list_struct;
	xvf_add_extra_call(gui_info->quit_struct, quit_cleanup,
			   NULL, XVF_CALL_FIRST);

	/*
	 *  set up tacking
	 */
        xvw_set_attribute(gui_info->workspace, XVW_TACK_EDGE,
                          KMANAGER_TACK_BOTTOM | KMANAGER_TACK_RIGHT);
	xvw_set_attributes(xvw_parent(gui_info->workspace),
                           XVW_MINIMUM_WIDTH,  525,
                           XVW_MINIMUM_HEIGHT, 260,
                           NULL);
	/*
	 *  create layout object to be parent of area objects;
	 *  install callback to change the area.
	 */
	layout = xvw_create_layout(gui_info->workspace, "layout");
	xvw_set_attributes(layout,
		           XVW_TACK_EDGE,    KMANAGER_TACK_ALL,
		           XVW_BORDER_WIDTH, 0,
		           NULL);
	xvw_insert_callback(layout, XVW_LAYOUT_CALLBACK,
			    FALSE, change_area, NULL);

	
	/*
	 * input files from CLUI if necessary
	 */
	if (clui_info->i1_file) input_file(clui_info->i1_file);
	if (clui_info->i2_file) input_file(clui_info->i2_file);
	if (clui_info->i3_file) input_file(clui_info->i3_file);
	if (clui_info->i4_file) input_file(clui_info->i4_file);
/* -main_before_lib_call_end */

/* -main_library_call */
	xvf_run_form();
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */

	kfree(form_filestring);
	kfree(form_pathname);
	kfree(form_fullpath);

	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: xprism_usage_additions
| 
|       Purpose: Prints usage additions in xprism_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname xprism
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void xprism_usage_additions(void)
{
	kfprintf(kstderr, "\tInteractive 2D & 3D Plotting\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: xprism_free_args
| 
|       Purpose: Frees CLUI struct allocated in xprism_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname xprism
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
xprism_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
		kfree(clui_info->form_file);
	kfree(clui_info->i1_file);
	kfree(clui_info->i2_file);
	kfree(clui_info->i3_file);
	kfree(clui_info->i4_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
