 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	FormInfo Extraction Routines
   >>>> 
   >>>>  Private: 
   >>>> 	_xvf_get_xprism
   >>>> 
   >>>>   Static: 
   >>>> 	_xvf_get_Plot
   >>>> 	_xvf_get_file
   >>>> 	_xvf_get_function
   >>>> 	_xvf_get_plot_control
   >>>> 	_xvf_get_Options
   >>>> 	_xvf_get_options
   >>>> 	_xvf_get_Print
   >>>> 	_xvf_get_screen_dump
   >>>> 	_xvf_get_Colormap
   >>>> 	_xvf_get_colormap
   >>>> 	_xvf_get_Deflts
   >>>> 	_xvf_get_deflts
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "xprism.h"


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_xprism
| 
|       Purpose: Extracts information from GUI
| 
|         Input: forminfo - pointer to gui_info_struct
| 
|        Output: none
|    Written By: conductor -name xprism -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_xprism(
     gui_info_struct *forminfo)
{
	kselection *selection;
	ksubform   *subform;
	if (forminfo->quit_struct != NULL)
	{
	    selection = forminfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->quit));

	}

	if (forminfo->workspace_struct != NULL)
	{
	    selection = forminfo->workspace_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(forminfo->workspace));
	    }

	}

	if (forminfo->reset_wcs_struct != NULL)
	{
	    selection = forminfo->reset_wcs_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->reset_wcs));

	}

	if (forminfo->add_indicator_struct != NULL)
	{
	    selection = forminfo->add_indicator_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->add_indicator));

	}

	if (forminfo->remove_area_struct != NULL)
	{
	    selection = forminfo->remove_area_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->remove_area));

	}

	if (forminfo->refresh_area_struct != NULL)
	{
	    selection = forminfo->refresh_area_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->refresh_area));

	}

	if (forminfo->clear_layout_struct != NULL)
	{
	    selection = forminfo->clear_layout_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->clear_layout));

	}

	if (forminfo->layout_menu_struct != NULL)
	{
	    selection = forminfo->layout_menu_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->layout_menu));

	}

	if (forminfo->Plot_struct != NULL)
	{
	    subform = forminfo->Plot_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->Plot_selected));
	    _xvf_get_Plot(forminfo->Plot);

	}
	if (forminfo->Options_struct != NULL)
	{
	    subform = forminfo->Options_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->Options_selected));
	    _xvf_get_Options(forminfo->Options);

	}
	if (forminfo->Print_struct != NULL)
	{
	    subform = forminfo->Print_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->Print_selected));
	    _xvf_get_Print(forminfo->Print);

	}
	if (forminfo->Colormap_struct != NULL)
	{
	    subform = forminfo->Colormap_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->Colormap_selected));
	    _xvf_get_Colormap(forminfo->Colormap);

	}
	if (forminfo->Deflts_struct != NULL)
	{
	    subform = forminfo->Deflts_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->Deflts_selected));
	    _xvf_get_Deflts(forminfo->Deflts);

	}

}

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_Plot
| 
|       Purpose: Extracts information from Plot subform
| 
|         Input: subforminfo - pointer to xprism_Plot structure
| 
|        Output: none
|    Written By: conductor -name xprism -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_Plot(
     xprism_Plot *subforminfo)
{
	kselection *selection;
	kcontrol   *pane;
	if (subforminfo->quit_struct != NULL)
	{
	    selection = subforminfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->quit));

	}

	if (subforminfo->file_struct != NULL)
	{
	    pane = subforminfo->file_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->file_selected));
	    _xvf_get_file(subforminfo->file);
	}

	if (subforminfo->function_struct != NULL)
	{
	    pane = subforminfo->function_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->function_selected));
	    _xvf_get_function(subforminfo->function);
	}

	if (subforminfo->plot_control_struct != NULL)
	{
	    pane = subforminfo->plot_control_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->plot_control_selected));
	    _xvf_get_plot_control(subforminfo->plot_control);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_file
| 
|       Purpose: Extracts information from file pane
| 
|         Input: paneinfo - pointer to Plot_file structure
| 
|        Output: none
|    Written By: conductor -name xprism -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_file(
     Plot_file *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'xprism->Plot->file' Pane Info structure
	 */

	if (paneinfo->input_file_struct != NULL)
	{
	    selection = paneinfo->input_file_struct->Selptr;
	    if (selection->modified)
	    {
		if (paneinfo->input_file != NULL) kfree(paneinfo->input_file);
		kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
		                  &(paneinfo->input_file));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->input_file_selected));
	    }
	}

	if (paneinfo->plot_where_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->plot_where_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->plot_where_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->plot_where_val = atoi(value_string);
	    kfree(value_string);
	    }

	}

	if (paneinfo->object_type_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->object_type_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->object_type_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->object_type_val = atoi(value_string);
	    kfree(value_string);
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_function
| 
|       Purpose: Extracts information from function pane
| 
|         Input: paneinfo - pointer to Plot_function structure
| 
|        Output: none
|    Written By: conductor -name xprism -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_function(
     Plot_function *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'xprism->Plot->function' Pane Info structure
	 */

	if (paneinfo->plot_dim_struct != NULL)
	{
	    selection = paneinfo->plot_dim_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_CYCLE_VAL,
	                    &(paneinfo->plot_dim));
	    if (paneinfo->plot_dim_label != NULL) kfree(paneinfo->plot_dim_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_CYCLE_LABEL,
	                    &(paneinfo->plot_dim_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->plot_dim_selected));
	    }

	}

	if (paneinfo->func_3D_struct != NULL)
	{
	    selection = paneinfo->func_3D_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->func_3D != NULL) kfree(paneinfo->func_3D);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->func_3D));
	    }

	}

	if (paneinfo->func_2D_struct != NULL)
	{
	    selection = paneinfo->func_2D_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->func_2D != NULL) kfree(paneinfo->func_2D);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->func_2D));
	    }

	}

	if (paneinfo->x_min_struct != NULL)
	{
	    selection = paneinfo->x_min_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->x_min != NULL) kfree(paneinfo->x_min);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->x_min));
	    }

	}

	if (paneinfo->x_max_struct != NULL)
	{
	    selection = paneinfo->x_max_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->x_max != NULL) kfree(paneinfo->x_max);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->x_max));
	    }

	}

	if (paneinfo->xnum_pts_struct != NULL)
	{
	    selection = paneinfo->xnum_pts_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->xnum_pts != NULL) kfree(paneinfo->xnum_pts);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->xnum_pts));
	    }

	}

	if (paneinfo->y_min_struct != NULL)
	{
	    selection = paneinfo->y_min_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->y_min != NULL) kfree(paneinfo->y_min);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->y_min));
	    }

	}

	if (paneinfo->y_max_struct != NULL)
	{
	    selection = paneinfo->y_max_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->y_max != NULL) kfree(paneinfo->y_max);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->y_max));
	    }

	}

	if (paneinfo->ynum_pts_struct != NULL)
	{
	    selection = paneinfo->ynum_pts_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->ynum_pts != NULL) kfree(paneinfo->ynum_pts);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->ynum_pts));
	    }

	}

	if (paneinfo->where_plot_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->where_plot_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->where_plot_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->where_plot_val = atoi(value_string);
	    kfree(value_string);
	    }

	}

	if (paneinfo->plot_function_struct != NULL)
	{
	    selection = paneinfo->plot_function_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->plot_function));

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_plot_control
| 
|       Purpose: Extracts information from plot_control pane
| 
|         Input: paneinfo - pointer to Plot_plot_control structure
| 
|        Output: none
|    Written By: conductor -name xprism -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_plot_control(
     Plot_plot_control *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'xprism->Plot->plot_control' Pane Info structure
	 */

	if (paneinfo->plot2d_type_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->plot2d_type_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->plot2d_type_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->plot2d_type_val = atoi(value_string);
	    kfree(value_string);
	    }

	}

	if (paneinfo->plot3d_type_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->plot3d_type_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->plot3d_type_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->plot3d_type_val = atoi(value_string);
	    kfree(value_string);
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_Options
| 
|       Purpose: Extracts information from Options subform
| 
|         Input: subforminfo - pointer to xprism_Options structure
| 
|        Output: none
|    Written By: conductor -name xprism -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_Options(
     xprism_Options *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->options_struct != NULL)
	{
	    pane = subforminfo->options_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->options_selected));
	    _xvf_get_options(subforminfo->options);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_options
| 
|       Purpose: Extracts information from options pane
| 
|         Input: paneinfo - pointer to Options_options structure
| 
|        Output: none
|    Written By: conductor -name xprism -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_options(
     Options_options *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'xprism->Options->options' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->area_list_struct != NULL)
	{
	    selection = paneinfo->area_list_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->area_list));
	    if (paneinfo->area_list_label != NULL) kfree(paneinfo->area_list_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->area_list_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->area_list_selected));
	    }

	}

	if (paneinfo->plot_list_struct != NULL)
	{
	    selection = paneinfo->plot_list_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->plot_list));
	    if (paneinfo->plot_list_label != NULL) kfree(paneinfo->plot_list_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->plot_list_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->plot_list_selected));
	    }

	}

	if (paneinfo->open_area_struct != NULL)
	{
	    selection = paneinfo->open_area_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->open_area));

	}

	if (paneinfo->open_plot_struct != NULL)
	{
	    selection = paneinfo->open_plot_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->open_plot));

	}

	if (paneinfo->delete_area_struct != NULL)
	{
	    selection = paneinfo->delete_area_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->delete_area));

	}

	if (paneinfo->delete_plot_struct != NULL)
	{
	    selection = paneinfo->delete_plot_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->delete_plot));

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_Print
| 
|       Purpose: Extracts information from Print subform
| 
|         Input: subforminfo - pointer to xprism_Print structure
| 
|        Output: none
|    Written By: conductor -name xprism -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_Print(
     xprism_Print *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->screen_dump_struct != NULL)
	{
	    pane = subforminfo->screen_dump_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->screen_dump_selected));
	    _xvf_get_screen_dump(subforminfo->screen_dump);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_screen_dump
| 
|       Purpose: Extracts information from screen_dump pane
| 
|         Input: paneinfo - pointer to Print_screen_dump structure
| 
|        Output: none
|    Written By: conductor -name xprism -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_screen_dump(
     Print_screen_dump *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'xprism->Print->screen_dump' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->dump_what_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->dump_what_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->dump_what_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->dump_what_val = atoi(value_string);
	    kfree(value_string);
	    }

	}

	if (paneinfo->display_file_struct != NULL)
	{
	    selection = paneinfo->display_file_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->display_file != NULL) kfree(paneinfo->display_file);
	    kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
	                    &(paneinfo->display_file));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->display_file_selected));
	    }
	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_Colormap
| 
|       Purpose: Extracts information from Colormap subform
| 
|         Input: subforminfo - pointer to xprism_Colormap structure
| 
|        Output: none
|    Written By: conductor -name xprism -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_Colormap(
     xprism_Colormap *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->colormap_struct != NULL)
	{
	    pane = subforminfo->colormap_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->colormap_selected));
	    _xvf_get_colormap(subforminfo->colormap);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_colormap
| 
|       Purpose: Extracts information from colormap pane
| 
|         Input: paneinfo - pointer to Colormap_colormap structure
| 
|        Output: none
|    Written By: conductor -name xprism -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_colormap(
     Colormap_colormap *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'xprism->Colormap->colormap' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->wksp1_struct != NULL)
	{
	    selection = paneinfo->wksp1_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(paneinfo->wksp1));
	    }

	}

	if (paneinfo->wksp2_struct != NULL)
	{
	    selection = paneinfo->wksp2_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(paneinfo->wksp2));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_Deflts
| 
|       Purpose: Extracts information from Deflts subform
| 
|         Input: subforminfo - pointer to xprism_Deflts structure
| 
|        Output: none
|    Written By: conductor -name xprism -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_Deflts(
     xprism_Deflts *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->deflts_struct != NULL)
	{
	    pane = subforminfo->deflts_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->deflts_selected));
	    _xvf_get_deflts(subforminfo->deflts);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_deflts
| 
|       Purpose: Extracts information from deflts pane
| 
|         Input: paneinfo - pointer to Deflts_deflts structure
| 
|        Output: none
|    Written By: conductor -name xprism -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_deflts(
     Deflts_deflts *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'xprism->Deflts->deflts' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->new_plot_struct != NULL)
	{
	    selection = paneinfo->new_plot_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->new_plot));
	    if (paneinfo->new_plot_label != NULL) kfree(paneinfo->new_plot_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->new_plot_label));
	    }

	}

	if (paneinfo->display_title_struct != NULL)
	{
	   selection = paneinfo->display_title_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_VAL,
	                    &(paneinfo->display_title));
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_LABEL,
	                    &(paneinfo->display_title_label));
	    }

	}

	if (paneinfo->display_date_struct != NULL)
	{
	   selection = paneinfo->display_date_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_VAL,
	                    &(paneinfo->display_date));
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_LABEL,
	                    &(paneinfo->display_date_label));
	    }

	}

	if (paneinfo->background_struct != NULL)
	{
	    selection = paneinfo->background_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->background != NULL) kfree(paneinfo->background);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->background));
	    }

	}

	if (paneinfo->foreground_struct != NULL)
	{
	    selection = paneinfo->foreground_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->foreground != NULL) kfree(paneinfo->foreground);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->foreground));
	    }

	}

}


