 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>         Global variables for spectrum
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "spectrum.h"

/*
 *  image kobject data
 */
kobject  spc_image;      /* image being displayed                            */
int      spc_image_type;  /* data type of image coming in */

/*
 *  general info about map columns
 */
double   **spc_maps;               /* map data representing codebook         */
unsigned long spc_map_contents;    /* map contents                           */

int     spc_map_colnum;            /* number of map columns = (rowsize)      */
int     spc_map_rowsize;           /* size of map rows      = # columns)     */
int     spc_map_rownum;            /* number of map rows    = (colsize       */
int     spc_map_colsize;           /* size of map columns   = #rows          */

int     spc_unique_values;         /* unique values in the map data          */

double ***spc_covar_matrix;        /* stores the covariance matrix           */
int       spc_matrix_size;         /* # cols in the covariance matrix        */
double  **spc_covar_diag;          /* stores the covariance diagonal         */
int       spc_diag_size;           /* # cols in the covariance diagonal      */

int     *spc_classes;       /* cluster as index, class it belongs to as elem */
int     *spc_count;         /* count (histogram) array                       */

int spc_max_colors;         /* max # colors that can be displayed            */

/*
 *  workspaces in which things are displayed
 */
xvobject legend_workspace; /* object in which legend is displayed            */
xvobject legend_pseudo;    /* pseudocolor bars on legend display             */
xvobject zoom_workspace;   /* object in which zoom is displayed              */


/*
 *  book-keeping for legend, classes
 */
LegendEntry  *spc_legend_list;    /* list of legend entries                  */
LegendEntry **spc_legend_lookup;  /* fast lookup of legend entries           */
LegendEntry  *spc_current_class;  /* current legend entry                    */

char  **spc_mapcol_names;         /* names assigned to map cols by user      */ 
int     spc_legend_classnum;      /* current number of classes               */ 
int     *spc_unused_classnums;    /* saves unused class #'s (holes)          */
int     spc_num_unused_classnums; /* number of holes (size of array)         */

/*
 *  structure associated w/ spectral curve
 */
SpectralCurveStruct *spc_curve; /* pointer to curve info                     */

/*
 *  structure associated w/ scatter plot
 */
ScatterPlotStruct *spc_scatter; /* pointer to scatterplot info               */

/*
 *  info associated with functions, columns being displayed, normalization
 */
ImageDisplayStruct *spc_display; /* pointer to info assoc. w/ image display  */

/*
 *  info associated with statistics display, class contents display subform
 */
InfoStruct *spc_info; /* pointer to info assoc. w/ info display */

/*
 *  structure associated with transformation definitions read in
 *  from the display environment ascii file
 */
TransformStruct **spc_trans_info;
int              spc_trans_num;

/*
 *  pixel value used for background color of legend colorbox of 
 *  class with no clusters assigned to it.
 */
Pixel white;
