 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane scatter
   >>>> 
   >>>>  Private: 
   >>>> 	scatter_x_column
   >>>> 	scatter_y_column
   >>>> 	scatter_x_func
   >>>> 	scatter_y_func
   >>>> 	scatter_prop
   >>>> 	scatter_reset
   >>>> 	scatter_set
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "spectrum.h"

/*-----------------------------------------------------------
| 
|  Routine Name: scatter_x_column
| 
|       Purpose: Do routine which is called when
|                  pane action button x_column is used
| 
|         Input: scatter_info - ptr to PaneInfo struct for scatter pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Oct 11, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void scatter_x_column(
     Scatter_scatter *scatter_info)
{
	spc_change_plot_col(scatter_info->xcol_blank_struct, SPC_X);
}


/*-----------------------------------------------------------
| 
|  Routine Name: scatter_y_column
| 
|       Purpose: Do routine which is called when
|                  pane action button y_column is used
| 
|         Input: scatter_info - ptr to PaneInfo struct for scatter pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Oct 11, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void scatter_y_column(
     Scatter_scatter *scatter_info)
{
	spc_change_plot_col(scatter_info->ycol_blank_struct, SPC_Y);
}


/*-----------------------------------------------------------
| 
|  Routine Name: scatter_x_func
| 
|       Purpose: Do routine which is called when
|                  string selection x_func is used
| 
|         Input: scatter_info - ptr to PaneInfo struct for scatter pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Aug 10, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void scatter_x_func(
     Scatter_scatter *scatter_info)
{
	spc_apply_plot_function(scatter_info->x_func, SPC_X);
}


/*-----------------------------------------------------------
| 
|  Routine Name: scatter_y_func
| 
|       Purpose: Do routine which is called when
|                  string selection y_func is used
| 
|         Input: scatter_info - ptr to PaneInfo struct for scatter pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Aug 10, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void scatter_y_func(
     Scatter_scatter *scatter_info)
{
	spc_apply_plot_function(scatter_info->x_func, SPC_X);
}


/*-----------------------------------------------------------
| 
|  Routine Name: scatter_prop
| 
|       Purpose: Do routine which is called when
|                  logical selection prop is used
| 
|         Input: scatter_info - ptr to PaneInfo struct for scatter pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Aug 10, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* 
ARGSUSED 
void scatter_prop(
     Scatter_scatter *scatter_info)
{
	if (scatter_info->prop == SPC_NONPROP)
	    xvw_set_attribute(spc_scatter->axis, XVW_GRAPHICS_PROPORTIONAL,
			      KGRAPHICS_NONPROP);

	else if (scatter_info->prop == SPC_PROP_WINDOWED)
            xvw_set_attribute(spc_scatter->axis, XVW_GRAPHICS_PROPORTIONAL, 
                              KGRAPHICS_PROP_WINDOWED);

	else if (scatter_info->prop == SPC_PROP_NONWINDOWED)
            xvw_set_attribute(spc_scatter->axis, XVW_GRAPHICS_PROPORTIONAL, 
			      KGRAPHICS_PROP_NONWINDOWED);
}
*/


/*-----------------------------------------------------------
| 
|  Routine Name: scatter_reset
| 
|       Purpose: Do routine which is called when
|                  pane action button reset is used
| 
|         Input: scatter_info - ptr to PaneInfo struct for scatter pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Nov 04, 1993
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void scatter_reset(
     Scatter_scatter *scatter_info)
{
        xvw_set_attributes(spc_scatter->axis,
                           XVW_GRAPHICS_WCMIN_X, spc_scatter->wcxmin,
                           XVW_GRAPHICS_WCMAX_X, spc_scatter->wcxmax,
                           XVW_GRAPHICS_WCMIN_Y, spc_scatter->wcymin,
                           XVW_GRAPHICS_WCMAX_Y, spc_scatter->wcymax,
                           NULL);
}


/*-----------------------------------------------------------
| 
|  Routine Name: scatter_set
| 
|       Purpose: Do routine which is called when
|                  pane action button set is used
| 
|         Input: scatter_info - ptr to PaneInfo struct for scatter pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Aug 10, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void scatter_set(
     Scatter_scatter *scatter_info)
{
	int          id, x, y; 
	double       xmin, xmax, ymin, ymax;
	Coord        c1, c2;
	unsigned int w, h;

	/* 
	 *  busy window is up over the plot window because
	 *  of the "Set Zoom" buttonpress action.   need to
	 *  unbusy the window if the getextent() routine is to work.
         *  also remove event handlers to reduce confusion
	 */
	xvw_remove_event(spc_scatter->area, ButtonMotionMask,
                         spc_paint_from_plot, NULL);
        xvw_remove_event(spc_scatter->area, PointerMotionMask,
                         spc_update_plot_position, NULL);

	if (gui_info->Curve->curve->update_mode == SPC_CONTINOUS_SINGLE)
            xvw_remove_event(spc_scatter->area, PointerMotionMask,
                             spc_update_spectral_curve, NULL);
	else xvw_remove_event(spc_scatter->area, ButtonPressMask,
                             spc_update_spectral_curve, NULL);

        xvw_remove_event(spc_scatter->area, PointerMotionMask,
                         spc_update_cluster_stats, NULL);

	xvw_busy(NULL, FALSE);

	/* 
	 * use xvw_getextent_rectangle to let the user rubber band the 
	 * area on which to zoom 
         */
	if (!xvw_getextent_rectangle(spc_scatter->area, TRUE, &x, &y, &w, &h))
	    return;

	if ((w == 0) || (h == 0))
	{
	    kerror(NULL, "scatter_set", "After clicking on the 'Set Zoom' button, please move the pointer into the scatter plot and rubberband the area on which you want to zoom.  Click on the upper left corner of the desired area; *holding the button down*, 'drag' the pointer so that the desired area is appears within the rubberbanded rectangle.  When you release the button, the data within that area of the scatter plot will be expanded to fill the entire scatterplot display.");
            return;
	}

	/* 
	 * convert the two corners to world coordinates 
	 */
	id = (int) (xvw_widget(spc_scatter->plot));
	X2D_convert_point_dc_to_wc(id, (Real) x,   (Real) y,   &c1);
        X2D_convert_point_dc_to_wc(id, (Real) (x+w), (Real) (y+h), &c2);

	xmin = kmin(c1.x, c2.x);
	xmax = kmax(c1.x, c2.x);
	ymin = kmin(c1.y, c2.y);
	ymax = kmax(c1.y, c2.y);

	xvw_set_attributes(spc_scatter->axis, 
			   XVW_GRAPHICS_WCMIN_X, xmin,
			   XVW_GRAPHICS_WCMAX_X, xmax,
			   XVW_GRAPHICS_WCMIN_Y, ymin,
			   XVW_GRAPHICS_WCMAX_Y, ymax,
			   NULL);

	/*
	 * put back event handlers
	 */
	xvw_add_event(spc_scatter->area, ButtonMotionMask,
                      spc_paint_from_plot, NULL);
        xvw_add_event(spc_scatter->area, PointerMotionMask,
                      spc_update_plot_position, NULL);

	if (gui_info->Curve->curve->update_mode == SPC_CONTINOUS_SINGLE)
            xvw_add_event(spc_scatter->area, PointerMotionMask,
                          spc_update_spectral_curve, NULL);
	else xvw_add_event(spc_scatter->area, ButtonPressMask,
                          spc_update_spectral_curve, NULL);
        xvw_add_event(spc_scatter->area, PointerMotionMask,
                      spc_update_cluster_stats, NULL);

}



