 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */


/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>           Spectral Curve Routines
 >>>>
 >>>>           spc_update_spectral_curve()
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#include "spectrum.h"

/*-----------------------------------------------------------
|
|  Routine Name: spc_update_spectral_curve
|
|       Purpose: updates the spectral curve display, on which the
|                color of the class of the cluster is displayed,
|                along with the cluster number and the plot
|                representing each of the feature values for that cluster.
|
|         Input: object      - main image workspace, 
|			       zoom workspace, or scatterplot
|		 client_data - not used
|		 event       - the PointerMotion event
|		 dispatch    - whether or not to propogate event (not used)
|        Output: None
|       Returns: None
|    Written By: Danielle Argiro
|          Date: May 12, 1993
| Modifications:
|
------------------------------------------------------------*/

/* ARGSUSED */
void spc_update_spectral_curve(
    xvobject  object,
    kaddr     client_data,
    XEvent    *event,
    int       *dispatch)
{
	Coord *coords;
	int   i, cluster, point_index;
	char  temp[KLENGTH];
	unsigned long fg;
	double tmp_double;

	if (!xvw_check_visible(spc_curve->parent))
	    return;

	/* 
	 * here, the event came from the scatter plot.  if we can't identify
	 * the device coordinate as a point in the plot, just return;  if
	 * so, then get the pixel (cluster) value represented by the point.
	 */
	if (object == spc_scatter->area)
	{
            if (!(spc_identify_plot_point(event->xbutton.x,
                                          event->xbutton.y,
                                          &cluster, &point_index)))
                return;

	}

	/*
	 * event came from the main spectrum workspace or the 
	 * zoom window. get pixel value at that point.
	 */
	else 
	{
	     xvw_get_attribute(object, XVW_IMAGE_VALUE,  &tmp_double);
             cluster = (int) tmp_double;
	}
	     
	/*
	 *  update label to indicate cluster number, associated class (if any)
	 */
	if ((spc_legend_lookup != NULL) && 
            (spc_legend_lookup[cluster] != NULL))
	    ksprintf(temp,  "    Cluster Number %d, member of class '%s'", 
		     cluster, (spc_legend_lookup[cluster])->classname);
	else ksprintf(temp, "    Cluster Number %d, not member of class", 
                     cluster);
	xvw_set_attribute(spc_curve->label, XVW_LABEL, temp);
	xvw_set_attribute(spc_curve->colorbox, XVW_COLORCELL_INDEX, cluster);
	xvw_get_attribute(spc_curve->colorbox, XVW_BACKGROUND, &fg);

	/*
	 *  compute coordinate array for the new plot
	 */
        coords = (Coord *) kmalloc(spc_map_colnum * sizeof(Coord)); 
        for (i = 0; i < spc_map_colnum; i++)
        {
            coords[i].x = i+1;
            coords[i].y = spc_maps[cluster][i];
        }
	
	/*
	 * we are in continous, single-plot mode
	 */
	if (gui_info->Curve->curve->update_mode == SPC_CONTINOUS_SINGLE)
	{
	    xvw_set_attributes(spc_curve->plot,
			       XVW_PLOT2D_POINTS,        coords,
			       XVW_PLOT2D_PLOTSIZE,      spc_map_colnum,
			       XVW_FOREGROUND,           fg,
			       XVW_GRAPHICS_RESET_WORLD, FALSE,
			       NULL);

            xvw_set_attributes(spc_curve->xaxis,
                           XVW_AXIS_LABELING_MODE,   KAXIS_SET_LABELED_INTERVAL,
                           XVW_AXIS_LABELED_INTERVAL,1.0,
                           NULL);
	}

	/*
	 * we are in buttonpress, multi-plot mode
	 */
	else
	{
	    spc_curve->plots = (xvobject *) krealloc(spc_curve->plots, 
				(spc_curve->plotnum+1)*sizeof(xvobject));
	    ksprintf(temp, "spectralcurve%d", spc_curve->plotnum);
	    spc_curve->plots[spc_curve->plotnum] = 
			xvw_create_plot2d(spc_curve->area, temp);
	    xvw_set_attributes(spc_curve->plots[spc_curve->plotnum], 
			       XVW_PLOT2D_POINTS,        coords,
			       XVW_PLOT2D_PLOTSIZE,      spc_map_colnum,
			       XVW_AREA_ATTACH,          spc_curve->area,
			       XVW_GRAPHICS_RESET_WORLD, FALSE,
			       XVW_FOREGROUND,           fg,
			       NULL);
	    spc_curve->plotnum++;
	    *dispatch = FALSE;
	}

	kfree(coords);
}


/*-----------------------------------------------------------
|
|  Routine Name: spc_find_spectral_min_max
|
|       Purpose: Finds the min's and max's of the map columns
|         Input: none
|        Output: mapcol_min - minimum over all the map columns
|                mapcol_max - maximum over all the map columns
|       Returns:
|    Written By: Danielle Argiro
|          Date: Oct 29, 1993
| Modifications:
|
------------------------------------------------------------*/
void spc_find_spectral_min_max(
    double *mapcol_min,
    double *mapcol_max)
{
        int i, j;

        *mapcol_min = spc_maps[0][0];
        *mapcol_max = spc_maps[0][0];

        for (i = 0; i < spc_map_rownum; i++)
        {
	     for (j = 0; j < spc_map_colnum; j++)
	     {
                 if (spc_maps[i][j] > *mapcol_max) 
		    *mapcol_max = spc_maps[i][j];
                 if (spc_maps[i][j] < *mapcol_min) 
		    *mapcol_min= spc_maps[i][j];
	     }
        }
	*mapcol_max = ceil(*mapcol_max);
	*mapcol_min = floor(*mapcol_min);
}


