 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	FormInfo Extraction Routines
   >>>> 
   >>>>  Private: 
   >>>> 	_xvf_get_form
   >>>> 
   >>>>   Static: 
   >>>> 	_xvf_get_subform
   >>>> 	_xvf_get_pane
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "extractor.h"


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_form
| 
|       Purpose: Extracts information from GUI
| 
|         Input: forminfo - pointer to gui_info_struct
| 
|        Output: none
|    Written By: conductor -name extractor -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_form(
     gui_info_struct *forminfo)
{
	kselection *selection;
	ksubform   *subform;
	if (forminfo->quit_struct != NULL)
	{
	    selection = forminfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->quit));

	}

	if (forminfo->wksp_struct != NULL)
	{
	    selection = forminfo->wksp_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(forminfo->wksp));
	    }

	}

	if (forminfo->subform_struct != NULL)
	{
	    subform = forminfo->subform_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->subform_selected));
	    _xvf_get_subform(forminfo->subform);

	}

}

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_subform
| 
|       Purpose: Extracts information from subform subform
| 
|         Input: subforminfo - pointer to form_subform structure
| 
|        Output: none
|    Written By: conductor -name extractor -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_subform(
     form_subform *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->pane_struct != NULL)
	{
	    pane = subforminfo->pane_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->pane_selected));
	    _xvf_get_pane(subforminfo->pane);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_pane
| 
|       Purpose: Extracts information from pane pane
| 
|         Input: paneinfo - pointer to subform_pane structure
| 
|        Output: none
|    Written By: conductor -name extractor -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_pane(
     subform_pane *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'form->subform->pane' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->i_struct != NULL)
	{
	    selection = paneinfo->i_struct->Selptr;
	    if (selection->modified)
	    {
		if (paneinfo->i != NULL) kfree(paneinfo->i);
		kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
		                  &(paneinfo->i));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->i_selected));
	    }
	}

	if (paneinfo->o_struct != NULL)
	{
	    selection = paneinfo->o_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->o != NULL) kfree(paneinfo->o);
	    kvf_get_attribute(selection->back_kformstruct, KVF_FILE_NAME,
	                    &(paneinfo->o));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->o_selected));
	    }
	}

	if (paneinfo->policy_struct != NULL)
	{
	    selection = paneinfo->policy_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->policy));
	    if (paneinfo->policy_label != NULL) kfree(paneinfo->policy_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->policy_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->policy_selected));
	    }

	}

	if (paneinfo->disp_struct != NULL)
	{
	   selection = paneinfo->disp_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_VAL,
	                    &(paneinfo->disp));
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_LABEL,
	                    &(paneinfo->disp_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->disp_selected));
	    }

	}

	if (paneinfo->mult_struct != NULL)
	{
	   selection = paneinfo->mult_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_VAL,
	                    &(paneinfo->mult));
	    kvf_get_attribute(selection->back_kformstruct, KVF_LOGIC_LABEL,
	                    &(paneinfo->mult_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->mult_selected));
	    }

	}

	if (paneinfo->pres_struct != NULL)
	{
	    selection = paneinfo->pres_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->pres));
	    if (paneinfo->pres_label != NULL) kfree(paneinfo->pres_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->pres_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->pres_selected));
	    }

	}

	if (paneinfo->shape_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->shape_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->shape_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->shape_val = atoi(value_string);
	    kfree(value_string);
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->shape_selected));
	    }

	}

	if (paneinfo->mode_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->mode_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->mode_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->mode_val = atoi(value_string);
	    kfree(value_string);
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->mode_selected));
	    }

	}

	if (paneinfo->line_x1_struct != NULL)
	{
	    selection = paneinfo->line_x1_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->line_x1));
	    }
	}

	if (paneinfo->circle_x_struct != NULL)
	{
	    selection = paneinfo->circle_x_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->circle_x));
	    }
	}

	if (paneinfo->ellipse_x_struct != NULL)
	{
	    selection = paneinfo->ellipse_x_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->ellipse_x));
	    }
	}

	if (paneinfo->rect_x_struct != NULL)
	{
	    selection = paneinfo->rect_x_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->rect_x));
	    }
	}

	if (paneinfo->line_x2_struct != NULL)
	{
	    selection = paneinfo->line_x2_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->line_x2));
	    }
	}

	if (paneinfo->circle_radius_struct != NULL)
	{
	    selection = paneinfo->circle_radius_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->circle_radius));
	    }
	}

	if (paneinfo->ellipse_a_struct != NULL)
	{
	    selection = paneinfo->ellipse_a_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->ellipse_a));
	    }
	}

	if (paneinfo->rect_width_struct != NULL)
	{
	    selection = paneinfo->rect_width_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->rect_width));
	    }
	}

	if (paneinfo->extract_struct != NULL)
	{
	    selection = paneinfo->extract_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->extract));

	}

	if (paneinfo->line_y1_struct != NULL)
	{
	    selection = paneinfo->line_y1_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->line_y1));
	    }
	}

	if (paneinfo->circle_y_struct != NULL)
	{
	    selection = paneinfo->circle_y_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->circle_y));
	    }
	}

	if (paneinfo->ellipse_y_struct != NULL)
	{
	    selection = paneinfo->ellipse_y_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->ellipse_y));
	    }
	}

	if (paneinfo->rect_y_struct != NULL)
	{
	    selection = paneinfo->rect_y_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->rect_y));
	    }
	}

	if (paneinfo->line_y2_struct != NULL)
	{
	    selection = paneinfo->line_y2_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->line_y2));
	    }
	}

	if (paneinfo->ellipse_b_struct != NULL)
	{
	    selection = paneinfo->ellipse_b_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->ellipse_b));
	    }
	}

	if (paneinfo->rect_height_struct != NULL)
	{
	    selection = paneinfo->rect_height_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_INT_VAL,
	                    &(paneinfo->rect_height));
	    }
	}

}


