 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane zoom
   >>>> 
   >>>>  Private: 
   >>>> 	zoom_zoomfactor
   >>>> 	zoom_update_mode
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */



#include "editimage.h"

/*-----------------------------------------------------------
| 
|  Routine Name: zoom_zoomfactor
| 
|       Purpose: Called when float selection zoomfactor is used
| 
|         Input: zoom_info - ptr to PaneInfo struct for zoom pane
| 
|        Output: None
|    Written By: 
|          Date: Fri Feb 12 13:17:16 1993
| Modifications: 
| 
------------------------------------------------------------*/
void zoom_zoomfactor(
     Zoom_zoom *zoom_info)
{
	xvw_set_attribute(zoom, XVW_ZOOM_FACTOR, zoom_info->zoomfactor);
}

/*-----------------------------------------------------------
| 
|  Routine Name: zoom_update_mode
| 
|       Purpose: Called when logical selection update_mode is used
| 
|         Input: zoom_info - ptr to PaneInfo struct for zoom pane
| 
|        Output: None
|    Written By: 
|          Date: Fri Feb 12 13:17:16 1993
| Modifications: 
| 
------------------------------------------------------------*/
void zoom_update_mode(
     Zoom_zoom *zoom_info)
{
	int update_mode;

	if (!zoom_info->update_mode)
	   update_mode = KZOOM_UM_CONTINUOUS;
	else update_mode = KZOOM_UM_BUTTON_PRESS;

	xvw_set_attribute(zoom, XVW_ZOOM_UPDATEMODE, update_mode);
}
