 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/* 
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane mapvals
   >>>> 
   >>>>  Private: 
   >>>> 	mapvals_update_mode
   >>>> 	mapvals_policy
   >>>> 	mapvals_display_width
   >>>> 	mapvals_display_height
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "editimage.h"

/*-----------------------------------------------------------
| 
|  Routine Name: mapvals_update_mode
| 
|       Purpose: Do routine which is called when
|                  logical selection update_mode is used
| 
|         Input: mapvals_info - ptr to PaneInfo struct for mapvals pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Jun 26, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void mapvals_update_mode(
     MapValues_mapvals *mapvals_info)
{
	int update_mode;

	if (!mapvals_info->update_mode)
	   update_mode = KPRINTMAPVAL_UM_CONTINUOUS;
	else update_mode = KPRINTMAPVAL_UM_BUTTON_PRESS;

	xvw_set_attribute(printmapval, XVW_PRINTMAPVAL_UPDATEMODE, update_mode);
}
/*-----------------------------------------------------------
| 
|  Routine Name: mapvals_policy
| 
|       Purpose: Do routine which is called when
|                  cycle selection policy is used
| 
|         Input: mapvals_info - ptr to PaneInfo struct for mapvals pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Oct 27, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void mapvals_policy(
     MapValues_mapvals *mapvals_info)
{
	xvw_set_attribute(printmapval, XVW_PRINTMAPVAL_POLICY, 
			  mapvals_info->policy);
}


/*-----------------------------------------------------------
| 
|  Routine Name: mapvals_display_width
| 
|       Purpose: Do routine which is called when
|                  integer selection display_width is used
| 
|         Input: mapvals_info - ptr to PaneInfo struct for mapvals pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Oct 27, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void mapvals_display_width(
     MapValues_mapvals *mapvals_info)
{
	xvw_set_attribute(printmapval, XVW_PRINTMAPVAL_WIDTH, 
			  mapvals_info->display_width);
}


/*-----------------------------------------------------------
| 
|  Routine Name: mapvals_display_height
| 
|       Purpose: Do routine which is called when
|                  integer selection display_height is used
| 
|         Input: mapvals_info - ptr to PaneInfo struct for mapvals pane
| 
|        Output: None
|    Written By: Danielle Argiro
|          Date: Oct 27, 1994
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void mapvals_display_height(
     MapValues_mapvals *mapvals_info)
{
	xvw_set_attribute(printmapval, XVW_PRINTMAPVAL_HEIGHT, 
			  mapvals_info->display_height);
}


