 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>         Utility routines for editimage
   >>>>
   >>>>  Private:
   >>>>         edimg_init_autocolor_display
   >>>>
   >>>>   Static:
   >>>>         autocolor_list_cb
   >>>>         operation_list_cb
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */



#include "editimage.h"

static void autocolor_list_cb PROTO((xvobject, kaddr, kaddr));
static void operation_list_cb PROTO((xvobject, kaddr, kaddr));

/*-----------------------------------------------------------
|
|  Routine Name: edimg_init_autocolor_display
|
|       Purpose: On input of the first image, gets the autocolor
|                list and the colormap operations list, and
|                sets up the two lists on the colormap display
|                with callbacks that will change the colormap
|                when the user selects one.
|
|         Input: data_object - the first image to be initialized
|        Output: none
|    Written By: Danielle Argiro
|          Date: Aug 03, 1994
| Modifications:
|
------------------------------------------------------------*/
void edimg_init_autocolor_display(
    kobject data_object)
{
        char     **operations, **autocolors;
        int      autocolor_num, operation_num;
        xvobject parent, actual_list;

        parent = gui_info->options->colormap->wksp1;
        autocolor_list = xvw_create_list(parent, "autocolorlist");
        xvw_set_attributes(autocolor_list,
                           XVW_RESIZABLE,     TRUE,
                           XVW_CHAR_HEIGHT,   10.0,
                           XVW_CHAR_WIDTH,    22.0,
                           NULL);
        actual_list = xvw_retrieve_list(autocolor_list);

        kcolor_get_attribute(data_object, KCOLOR_MAP_AUTOCOLOR_LIST,
                             &autocolors, &autocolor_num);
        xvw_change_list(actual_list, autocolors,
                        autocolor_num, FALSE);
        xvw_add_callback(actual_list, XVW_LIST_ITEM_SELECT,
                         autocolor_list_cb, NULL);
        xvw_set_attribute(actual_list, XVW_LIST_HIGHLT_ELEM, 0);

        parent = gui_info->options->colormap->wksp2;
        cmap_op_list = xvw_create_list(parent, "cmapoplist");
        xvw_set_attributes(cmap_op_list,
                           XVW_RESIZABLE,     TRUE,
                           XVW_CHAR_HEIGHT,   10.0,
                           XVW_CHAR_WIDTH,    22.0,
                           NULL);
        actual_list = xvw_retrieve_list(cmap_op_list);
        kcolor_get_attribute(data_object, KCOLOR_MAP_OPERATION_LIST,
                             &operations, &operation_num);
        xvw_change_list(actual_list, operations,
                        operation_num, FALSE);
        xvw_add_callback(actual_list, XVW_LIST_ITEM_SELECT,
                         operation_list_cb, NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: autocolor_list_cb
|
|       Purpose: Updates the image with the autocolor procedure
|                selected from the list of autocolor procedures.
|         Input:
|        Output:
|    Written By: Danielle Argiro
|          Date: Jul 03, 1994
| Modifications:
|
------------------------------------------------------------*/
static void autocolor_list_cb(
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
        int indx;
        xvw_list_struct *list = (xvw_list_struct *) call_data;

        kcolor_set_attribute(current_image, KCOLOR_MAP_AUTOCOLOR,
                             list->list_index);
}

/*-----------------------------------------------------------
|
|  Routine Name: operation_list_cb
|
|       Purpose: Updates the image with the colormap operation
|                selected from the list of colormap operations.
|         Input:
|        Output:
|    Written By: Danielle Argiro
|          Date: Jul 03, 1994
| Modifications:
|
------------------------------------------------------------*/
static void operation_list_cb(
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
        int             indx;
        xvw_list_struct *list = (xvw_list_struct *) call_data;

        /* #defines for autocolor operations start at 100 */
        indx = list->list_index+100;
        kcolor_set_attribute(current_image, KCOLOR_MAP_OPERATION, indx);
}


