 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Form Info Structure for animate Form
   >>>> 
   >>>>    Written By: conductor -name animate -l 3
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 18, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _form_info_h_
#define _form_info_h_

#include <xvinclude.h>

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

/*
 * Pane Info Struct for 'file' Pane
 */
typedef struct _File_file{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

char         *c;         /* filename for 'c'*/
kform_struct *c_struct;  /* pass to xvf_set_attributes() */
int          c_selected; /* TRUE on <cr> for 'c' */

char         *cmap;         /* filename for 'cmap'*/
kform_struct *cmap_struct;  /* pass to xvf_set_attributes() */
int          cmap_selected; /* TRUE on <cr> for 'cmap' */

char         *o;         /* filename for 'o'*/
kform_struct *o_struct;  /* pass to xvf_set_attributes() */
int          o_selected; /* TRUE on <cr> for 'o' */

char         *i;         /* filename for 'i'*/
kform_struct *i_struct;  /* pass to xvf_set_attributes() */
int          i_selected; /* TRUE on <cr> for 'i' */
int          i_optsel;   /* TRUE if optional box of 'i' is ON */

char         *b;         /* string for 'b'*/
kform_struct *b_struct;  /* pass to xvf_set_attributes() */
int          b_selected; /* TRUE on <cr> for 'b' */
int          b_optsel;   /* TRUE if optional box of 'b' is ON */

kform_struct *blk1_struct; /* pass to xvf_set_attributes() */

kform_struct *blk2_struct; /* pass to xvf_set_attributes() */

kform_struct *blk3_struct; /* pass to xvf_set_attributes() */

kform_struct *blk4_struct; /* pass to xvf_set_attributes() */

kform_struct *blk5_struct; /* pass to xvf_set_attributes() */

} File_file;

/*
 * Subform Info Struct for 'File' Subform
 */
typedef struct _animate_File {

File_file   *file;          /* ptr to Pane Info struct for pane 'file' */
int        file_selected;          /* TRUE if input was from pane 'file' */
kform_struct *file_struct;          /* pass to xvf_set_attributes() */

}  animate_File;

/*
 * Pane Info Struct for 'attributes' Pane
 */
typedef struct _options_attributes{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          control_val;      /* value of toggle 'control'*/
int          control_num;      /* number of toggle member selected (1-N) */
kform_struct *control_struct;  /* pass to xvf_set_attributes() */
int          control_selected; /* TRUE on <cr> for 'control' */

int           elements;         /* TRUE if the box for 'elements' is ON */
kform_struct *elements_struct;  /* pass to xvf_set_attributes() */
int          elements_selected; /* TRUE for value change of 'elements' */


int           depth;         /* TRUE if the box for 'depth' is ON */
kform_struct *depth_struct;  /* pass to xvf_set_attributes() */
int          depth_selected; /* TRUE for value change of 'depth' */


int           time;         /* TRUE if the box for 'time' is ON */
kform_struct *time_struct;  /* pass to xvf_set_attributes() */
int          time_selected; /* TRUE for value change of 'time' */


int          show_framenum;          /* boolean value of 'show_framenum'*/
char         *show_framenum_label;   /* label assoc w/ value of 'show_framenum'*/
kform_struct *show_framenum_struct;  /* pass to xvf_set_attributes() */
int          show_framenum_selected; /* TRUE on <cr> for 'show_framenum' */

float        speed;          /* float value of 'speed'*/
kform_struct *speed_struct;  /* pass to xvf_set_attributes() */
int          speed_selected; /* TRUE on <cr> for 'speed' */

kform_struct *image_band_label_struct; /* pass to xvf_set_attributes() */

} options_attributes;

/*
 * Pane Info Struct for 'display' Pane
 */
typedef struct _options_display{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          norm_type;          /* int value of 'norm_type'*/
char         *norm_type_label;   /* label representing int value of 'norm_type'*/
kform_struct *norm_type_struct;  /* pass to xvf_set_attributes() */
int          norm_type_selected; /* TRUE on <cr> for 'norm_type' */

int          norm_method_val;      /* value of toggle 'norm_method'*/
int          norm_method_num;      /* number of toggle member selected (1-N) */
kform_struct *norm_method_struct;  /* pass to xvf_set_attributes() */
int          norm_method_selected; /* TRUE on <cr> for 'norm_method' */

int          red_mapcol;          /* TRUE when user clicks on 'red_mapcol'*/
kform_struct *red_mapcol_struct;  /* pass to xvf_set_attributes() */

int          green_mapcol;          /* TRUE when user clicks on 'green_mapcol'*/
kform_struct *green_mapcol_struct;  /* pass to xvf_set_attributes() */

int          blue_mapcol;          /* TRUE when user clicks on 'blue_mapcol'*/
kform_struct *blue_mapcol_struct;  /* pass to xvf_set_attributes() */

char         *red_function;         /* string for 'red_function'*/
kform_struct *red_function_struct;  /* pass to xvf_set_attributes() */
int          red_function_selected; /* TRUE on <cr> for 'red_function' */

char         *green_function;         /* string for 'green_function'*/
kform_struct *green_function_struct;  /* pass to xvf_set_attributes() */
int          green_function_selected; /* TRUE on <cr> for 'green_function' */

char         *blue_function;         /* string for 'blue_function'*/
kform_struct *blue_function_struct;  /* pass to xvf_set_attributes() */
int          blue_function_selected; /* TRUE on <cr> for 'blue_function' */

kform_struct *blank1_struct; /* pass to xvf_set_attributes() */

kform_struct *blank2_struct; /* pass to xvf_set_attributes() */

} options_display;

/*
 * Pane Info Struct for 'lists' Pane
 */
typedef struct _options_lists{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          animate_list;          /* int value of 'animate_list'*/
char         *animate_list_label;   /* label representing int value of 'animate_list'*/
kform_struct *animate_list_struct;  /* pass to xvf_set_attributes() */
int          animate_list_selected; /* TRUE on <cr> for 'animate_list' */

int          band_list;          /* int value of 'band_list'*/
char         *band_list_label;   /* label representing int value of 'band_list'*/
kform_struct *band_list_struct;  /* pass to xvf_set_attributes() */
int          band_list_selected; /* TRUE on <cr> for 'band_list' */

} options_lists;

/*
 * Pane Info Struct for 'colormap' Pane
 */
typedef struct _options_colormap{

kform_struct *help_struct; /* pass to xvf_set_attributes() */

xvobject     wksp1;          /* address of workspace 'wksp1'*/
kform_struct *wksp1_struct;  /* pass to xvf_set_attributes() */

xvobject     wksp2;          /* address of workspace 'wksp2'*/
kform_struct *wksp2_struct;  /* pass to xvf_set_attributes() */

kform_struct *b1_struct; /* pass to xvf_set_attributes() */

kform_struct *b2_struct; /* pass to xvf_set_attributes() */

} options_colormap;

/*
 * Pane Info Struct for 'function' Pane
 */
typedef struct _options_function{

int          create;          /* TRUE when user clicks on 'create'*/
kform_struct *create_struct;  /* pass to xvf_set_attributes() */

kform_struct *help_struct; /* pass to xvf_set_attributes() */

char         *expr;         /* string for 'expr'*/
kform_struct *expr_struct;  /* pass to xvf_set_attributes() */

double       wbegin;          /* double value of 'wbegin'*/
kform_struct *wbegin_struct;  /* pass to xvf_set_attributes() */
int          wbegin_optsel;   /* TRUE if optional box of 'wbegin' is ON */

double       wend;          /* double value of 'wend'*/
kform_struct *wend_struct;  /* pass to xvf_set_attributes() */
int          wend_optsel;   /* TRUE if optional box of 'wend' is ON */

int          wsize;          /* int for 'wsize'*/
kform_struct *wsize_struct;  /* pass to xvf_set_attributes() */
int          wsize_optsel;   /* TRUE if optional box of 'wsize' is ON */

double       hbegin;          /* double value of 'hbegin'*/
kform_struct *hbegin_struct;  /* pass to xvf_set_attributes() */
int          hbegin_optsel;   /* TRUE if optional box of 'hbegin' is ON */

double       hend;          /* double value of 'hend'*/
kform_struct *hend_struct;  /* pass to xvf_set_attributes() */
int          hend_optsel;   /* TRUE if optional box of 'hend' is ON */

int          hsize;          /* int for 'hsize'*/
kform_struct *hsize_struct;  /* pass to xvf_set_attributes() */
int          hsize_optsel;   /* TRUE if optional box of 'hsize' is ON */

double       dbegin;          /* double value of 'dbegin'*/
kform_struct *dbegin_struct;  /* pass to xvf_set_attributes() */
int          dbegin_optsel;   /* TRUE if optional box of 'dbegin' is ON */

double       dend;          /* double value of 'dend'*/
kform_struct *dend_struct;  /* pass to xvf_set_attributes() */
int          dend_optsel;   /* TRUE if optional box of 'dend' is ON */

int          dsize;          /* int for 'dsize'*/
kform_struct *dsize_struct;  /* pass to xvf_set_attributes() */
int          dsize_optsel;   /* TRUE if optional box of 'dsize' is ON */

double       tbegin;          /* double value of 'tbegin'*/
kform_struct *tbegin_struct;  /* pass to xvf_set_attributes() */
int          tbegin_optsel;   /* TRUE if optional box of 'tbegin' is ON */

double       tend;          /* double value of 'tend'*/
kform_struct *tend_struct;  /* pass to xvf_set_attributes() */
int          tend_optsel;   /* TRUE if optional box of 'tend' is ON */

int          tsize;          /* int for 'tsize'*/
kform_struct *tsize_struct;  /* pass to xvf_set_attributes() */
int          tsize_optsel;   /* TRUE if optional box of 'tsize' is ON */

double       ebegin;          /* double value of 'ebegin'*/
kform_struct *ebegin_struct;  /* pass to xvf_set_attributes() */
int          ebegin_optsel;   /* TRUE if optional box of 'ebegin' is ON */

double       eend;          /* double value of 'eend'*/
kform_struct *eend_struct;  /* pass to xvf_set_attributes() */
int          eend_optsel;   /* TRUE if optional box of 'eend' is ON */

int          esize;          /* int for 'esize'*/
kform_struct *esize_struct;  /* pass to xvf_set_attributes() */
int          esize_optsel;   /* TRUE if optional box of 'esize' is ON */

int          type;          /* int value of 'type'*/
char         *type_label;   /* label representing int value of 'type'*/
kform_struct *type_struct;  /* pass to xvf_set_attributes() */
int          type_optsel;   /* TRUE if optional box of 'type' is ON */

kform_struct *blank1_struct; /* pass to xvf_set_attributes() */

kform_struct *blank2_struct; /* pass to xvf_set_attributes() */

kform_struct *blank3_struct; /* pass to xvf_set_attributes() */

kform_struct *blank4_struct; /* pass to xvf_set_attributes() */

kform_struct *blank5_struct; /* pass to xvf_set_attributes() */

} options_function;

/*
 * Subform Info Struct for 'options' Subform
 */
typedef struct _animate_options {

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Close' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

options_attributes  *attributes;          /* ptr to Pane Info struct for pane 'attributes' */
int                attributes_selected;          /* TRUE if input was from pane 'attributes' */
kform_struct       *attributes_struct;          /* pass to xvf_set_attributes() */

options_display  *display;          /* ptr to Pane Info struct for pane 'display' */
int             display_selected;          /* TRUE if input was from pane 'display' */
kform_struct    *display_struct;          /* pass to xvf_set_attributes() */

options_lists  *lists;          /* ptr to Pane Info struct for pane 'lists' */
int           lists_selected;          /* TRUE if input was from pane 'lists' */
kform_struct  *lists_struct;          /* pass to xvf_set_attributes() */

options_colormap  *colormap;          /* ptr to Pane Info struct for pane 'colormap' */
int              colormap_selected;          /* TRUE if input was from pane 'colormap' */
kform_struct     *colormap_struct;          /* pass to xvf_set_attributes() */

options_function  *function;          /* ptr to Pane Info struct for pane 'function' */
int              function_selected;          /* TRUE if input was from pane 'function' */
kform_struct     *function_struct;          /* pass to xvf_set_attributes() */

}  animate_options;

/*
 * Form Info Struct for 'animate' form
 */
typedef struct _gui_info_struct {

kform_struct *license_struct; /* pass to xvf_set_attributes() */

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Quit' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

int          reverse;          /* TRUE when user clicks on 'reverse'*/
kform_struct *reverse_struct;  /* pass to xvf_set_attributes() */

int          previous;          /* TRUE when user clicks on 'previous'*/
kform_struct *previous_struct;  /* pass to xvf_set_attributes() */

int          stop;          /* TRUE when user clicks on 'stop'*/
kform_struct *stop_struct;  /* pass to xvf_set_attributes() */

int          next;          /* TRUE when user clicks on 'next'*/
kform_struct *next_struct;  /* pass to xvf_set_attributes() */

int          forward;          /* TRUE when user clicks on 'forward'*/
kform_struct *forward_struct;  /* pass to xvf_set_attributes() */

xvobject     object;          /* address of workspace 'object'*/
kform_struct *object_struct;  /* pass to xvf_set_attributes() */

kform_struct *b0_struct; /* pass to xvf_set_attributes() */

animate_File  *File;
int File_selected;
kform_struct *File_struct;

animate_options  *options;
int options_selected;
kform_struct *options_struct;


kform_struct *animate_struct;


 } gui_info_struct; 

        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void animate_reverse	PROTO((gui_info_struct *));
void animate_previous	PROTO((gui_info_struct *));
void animate_stop	PROTO((gui_info_struct *));
void animate_next	PROTO((gui_info_struct *));
void animate_forward	PROTO((gui_info_struct *));
void _xvf_free_animate PROTO((gui_info_struct *));
void _xvf_get_animate  PROTO((gui_info_struct *));

int  _xvf_init_animate PROTO((kform *, gui_info_struct *));
void run_animate       PROTO((kform *, ksubform *, kaddr));

void run_File      PROTO((animate_File *));
void _xvf_get_File PROTO((animate_File *));

void run_file      PROTO((File_file *));
void _xvf_get_file PROTO((File_file *));
void file_c	PROTO((File_file *));
void file_cmap	PROTO((File_file *));
void file_o	PROTO((File_file *));
void file_i	PROTO((File_file *));
void file_b	PROTO((File_file *));

void run_options      PROTO((animate_options *));
void _xvf_get_options PROTO((animate_options *));

void run_attributes      PROTO((options_attributes *));
void _xvf_get_attributes PROTO((options_attributes *));
void attributes_control	PROTO((options_attributes *));
void attributes_elements	PROTO((options_attributes *));
void attributes_depth	PROTO((options_attributes *));
void attributes_time	PROTO((options_attributes *));
void attributes_show_framenum	PROTO((options_attributes *));
void attributes_speed	PROTO((options_attributes *));

void run_display      PROTO((options_display *));
void _xvf_get_display PROTO((options_display *));
void display_norm_type	PROTO((options_display *));
void display_norm_method	PROTO((options_display *));
void display_red_mapcol	PROTO((options_display *));
void display_green_mapcol	PROTO((options_display *));
void display_blue_mapcol	PROTO((options_display *));
void display_red_function	PROTO((options_display *));
void display_green_function	PROTO((options_display *));
void display_blue_function	PROTO((options_display *));

void run_lists      PROTO((options_lists *));
void _xvf_get_lists PROTO((options_lists *));
void lists_animate_list	PROTO((options_lists *));
void lists_band_list	PROTO((options_lists *));

void run_colormap      PROTO((options_colormap *));
void _xvf_get_colormap PROTO((options_colormap *));

void run_function      PROTO((options_function *));
void _xvf_get_function PROTO((options_function *));
void function_create	PROTO((options_function *));




#endif /* _form_info_h_ */ 
/* Don't add after this point */
