 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane function
   >>>> 
   >>>>  Private: 
   >>>> 	function_create
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "animate.h"

/*-----------------------------------------------------------
| 
|  Routine Name: function_create
| 
|       Purpose: Do routine which is called when
|                  pane action button create is used
| 
|         Input: function_info - ptr to PaneInfo struct for function pane
| 
|        Output: None
|    Written By: Mark Young
|          Date: Jan 01, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void function_create(
     options_function *function_info)
{
	int	type;
	kobject dest;

	/* Create the output object */
	if ((dest = kpds_create_object()) == NULL)
	{
	   kerror(NULL, "function_create",
		  "Failed to create temporary output object");
	   return;
	}
	kpds_create_value(dest);
	type = kdatatype_to_define(function_info->type_label);
	kpds_set_attribute(dest, KPDS_VALUE_DATA_TYPE, type);

	/*
	 *  Call the kapu_exprn_generate() routine to generate our data
	 *  object.
	 */
	if (!kapu_exprn_generate(function_info->expr,
		function_info->wsize,  function_info->hsize,
		function_info->dsize,  function_info->tsize,
		function_info->esize,  function_info->wbegin,
		function_info->hbegin, function_info->dbegin,
		function_info->tbegin, function_info->ebegin,
		function_info->wend,   function_info->hend,
		function_info->dend,   function_info->tend,
		function_info->eend,   TRUE, dest))
	{
	   kerror(NULL, "function_create",
		  "Failed to generate output data object");
	   return;
	}

	/*
	 *  Go ahead and display it
	 */
	current_image = dest;
	if (numimages == 0)
	   init_colormap_display(current_image);
 
	/*
	 *  go ahead and add the object to our image list
	 */
	images = (kobject *) karray_add((char **) images, current_image,
	                                numimages++);
 
	/*
	 *  set all animate displays to have their objects associated
	 *  with the data object associated with the file just read in,
	 *  so that we are animating, etc all on the same info.  (currently
	 *  this is only
	 */
	xvw_set_attribute(animate, XVW_IMAGE_IMAGEOBJ, current_image);
	xvw_set_attribute(panicon, XVW_IMAGE_IMAGEOBJ, current_image);
	update_animate_list(numimages-1);
}
