 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for animate
   >>>> 
   >>>>    Written By: 
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _animate_h_
#define _animate_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <envision.h>
#include <xvinclude.h>
#include "form_info.h"

/* -include_includes */
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$ENVISION/objects/xvroutine/animate/uis/animate.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Alternate UIS file (optional infile)
 */
char	*form_file;	/* Alternate UIS file FILENAME */
int	 form_flag;	/* Alternate UIS file FLAG */

/*
 *  (x,y) position for automatic GUI placement */

int	 x_int;		/* x position INT */
int	 x_flag;	/* x position FLAG */

int	 y_int;		/* y position INT */
int	 y_flag;	/* y position FLAG */

/*----- optional ME group ----*/
/*
 *  Filename of Input Object Containing Multiple Images (optional infile)
 */
char	*i_file;	/* Filename of Input Object Containing Multiple Images FILENAME */
int	 i_flag;	/* Filename of Input Object Containing Multiple Images FLAG */

/*
 *  Basename for a Set of Image Files (optional string)
 */
char	*base_string;	/* Basename for a Set of Image Files STRING */
int	 base_flag;   	/* Basename for a Set of Image Files FLAG */

/*-- optional ME group end ---*/

/*
 *  Filename of Input Object with Clip Mask (optional infile)
 */
char	*c_file;	/* Filename of Input Object with Clip Mask FILENAME */
int	 c_flag;	/* Filename of Input Object with Clip Mask FLAG */

/*
 *  Filename of Input Object with Alternate Colormap (optional infile)
 */
char	*cmap_file;	/* Filename of Input Object with Alternate Colormap FILENAME */
int	 cmap_flag;	/* Filename of Input Object with Alternate Colormap FLAG */

/*
 *  Use colormap? (optional logical)
 */
int	 use_cmap_logic;	/* Use colormap? LOGIC */
int	 use_cmap_flag;  	/* Use colormap? FLAG */

/*
 *  initial update time (optional float)
 */
float	 update_float;	/* initial update time FLOAT */
int	 update_flag;   	/* initial update time FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
extern gui_info_struct *gui_info;

/* -include_variables */
extern xvobject animate;
extern xvobject panicon;
extern xvobject framenum;

extern int     numimages;
extern kobject *images, current_image;
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void animate_get_args PROTO((kform *));
void animate_usage_additions PROTO((void));
void animate_free_args PROTO((int, kaddr));

/* -include_routines */
void input_newimage        PROTO((char *));
void input_newbasename     PROTO((char *));
void startup_from_clui     PROTO((void));
void update_framenum       PROTO((xvobject, kaddr, kaddr));
void init_colormap_display PROTO((kobject));
void update_animate_list   PROTO((int));
void update_band_list	   PROTO((void));
/* -include_routines_end */

#endif
