#include <xvinclude.h>

xvobject area, axis, plot;
Coord  data[4000];

void  recompute_points PROTO((xvobject, kaddr, XEvent *, int *));

/*
 * This example demonstrates how an area object can be used to provide
 * a coordinated world coordinate system for a plot and a set of axes.
 * It creates an area object, with a 2D plot and a set of 2D axes within
 * it;  it attaches the plot and the axes to the area object, so they
 * have a coordinated world coordinate view, and keep that coordinated
 * view even when the range of the plot changes.
 *
 * Click on the image to invoke the event handler which re-computes the
 * sin curve plotted to a new range;  the plot and the axis system will
 * update together.
 */
#define PTNUM 10
void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject parent, axis, plot, xaxis, yaxis;
	int    i, degrees;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* initialize xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
	   kerror(NULL, "main", "Cannot open display");
	   kexit(KEXIT_FAILURE);
        }

	/*
	 *  Generate initial sin curve to be plotted
	 */
	for (i = 0, degrees = 9; i < PTNUM; i++, degrees++)
	{
	   data[i].x = i;
	   data[i].y = sin((double) kdegrees_radians(degrees));
	}

	/*
	 * create a parent for the area
	 */
	parent = xvw_create_manager(NULL, "parent");
	xvw_set_attributes(parent, 
			   XVW_WIDTH,  300, 
			   XVW_HEIGHT, 200, 
			   NULL);
        /*
         * create a coordinated axis and plot object in an area object
	 */
	area = xvw_create_area(parent, "area");
	xvw_set_attributes( area,
                     XVW_AREA_DISPLAY_DATE,	FALSE,
                     XVW_AREA_DISPLAY_TITLE,	TRUE,
                     XVW_AREA_TITLE_STRING,	"2D Plot",
		     XVW_TACK_EDGE,             KMANAGER_TACK_ALL,
		     XVW_GRAPHICS_VIEWPORT_MIN_X, 0.2,
                     XVW_GRAPHICS_VIEWPORT_MIN_Y, 0.2,
                     XVW_GRAPHICS_VIEWPORT_MAX_X, 0.9,
                     XVW_GRAPHICS_VIEWPORT_MAX_Y, 0.9,
                     NULL );

	/*
	 *  create the axis system
	 */
	axis = xvw_create_axis2d(area, "axis");
	xvw_set_attribute(axis, XVW_AREA_ATTACH, area);

	/*
	 * The viewport max and mins do not have to be set for the plot
	 * object, since it's attached to the axis object. They will have the
	 * same values as the axis object, since the parent of the axis
         * object is an area object.  This is also true for the world 
         * coordinates; however it is the plot that is dictating these values 
         * (i.e. the maximum and minimum of the data being plotted) and the 
         * axis that is inheriting them.
	 */
	plot = xvw_create_plot2d(area, "plot coordinated");
	xvw_set_attributes(plot,
		XVW_PLOT2D_POINTS,	data,
		XVW_PLOT2D_PLOTSIZE,	PTNUM,
		XVW_AREA_ATTACH,	area,
		NULL);

        xvw_add_event(area, ButtonPressMask, recompute_points, plot);

	xvf_run_form();
}

void  recompute_points(
    xvobject object,
    kaddr    client_data,
    XEvent   *event,
    int      *dispatch)
{
        char       character;
        int        i, degrees;
        static int factor = 2;
	xvobject   plot = (xvobject) client_data;

        /*
         *  Generate a new sin curve to be plotted
         */
        for (i = 0, degrees = 9; i < (PTNUM * factor); i++, degrees++)
        {
            data[i].x = i;
            data[i].y = sin((double) kdegrees_radians(degrees));
        }
        xvw_set_attributes(plot,
                     XVW_PLOT2D_POINTS,         data,
                     XVW_PLOT2D_PLOTSIZE,       (PTNUM * factor),
                     NULL);
        factor++;
        if ( factor > 5 ) factor = 1;
}

