#include <xvinclude.h>


/*
 * This example creates a pixmap directly on the root window, and 
 * makes it wander about the root window using a timeout.  Note that you
 * should iconify extra xterms when running this example, or you might not 
 * see the little pixmap on the rootwindow.
 */
void roam_timeout  PROTO((xvobject, kaddr, int *));

float  roam_time       = 0.05;
int    roam_increment  = 3;
int    WIDTH   = 750;
int    HEIGHT  = 750;

main(
   int  argc,
   char *argv[],
   char *envp[])
{
	char     *filename = "eyeguy.xpm";
	xvobject pixmap, rootwindow;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/*  initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/* use filename specified on cmd line if provided */
	if (argc > 1)
	   filename = argv[1];

	/* create rootwindow object */
	rootwindow = xvw_create_rootwindow("Wander Eye", NULL, NULL);
	xvw_get_attributes(rootwindow,
		           XVW_WIDTH,  &WIDTH,
		           XVW_HEIGHT, &HEIGHT,
		           NULL);

	/* create pixmap with default starting position */
	pixmap = xvw_create_pixmap(rootwindow, "pixmap");
	xvw_set_attributes(pixmap,
		           XVW_PIXMAP_FILENAME, filename,
		           XVW_FORCE_REDISPLAY, TRUE,
		           XVW_XPOSITION,       WIDTH/2,
		           XVW_YPOSITION,       HEIGHT/2,
		           NULL);

	xvw_add_timeout(pixmap, roam_time, roam_timeout, NULL);

	/* display & run */
	xvf_run_form();
}

void roam_timeout(
   xvobject object,
   kaddr    client_data,
   int      *dispatch)
{

	double noise;
	static int direction = 0;
	int    current, x, y, width, height;
	xvobject pixmap = object;

	/*
	 *  Retrieve the current x & y position...
	 *  (note: we could simply keep track of the x & y position, but in case
	 *	 the user moves, we must be able to adjust for this)
	 */
	xvw_get_attributes(pixmap,
		XVW_XPOSITION, &x,
		XVW_YPOSITION, &y,
		XVW_WIDTH,  &width,
		XVW_HEIGHT, &height,
		NULL);

	/*
	 *  assign xposition and yposition, since these are of type Dimension,
	 *  which are unsigned longs.  This causes problems with wrap-around.
	 */
	switch (direction)
	{
	    case  0:
		  x += roam_increment;
		  break;

	    case  1:
		  x += roam_increment;
		  y += roam_increment;
		  break;

	    case  2:
		  y += roam_increment;
		  break;

	    case  3:
		  x -= roam_increment;
		  y += roam_increment;
		  break;

	    case  4:
		  x -= roam_increment;
		  break;

	    case  5:
		  x -= roam_increment;
		  y += roam_increment;
		  break;

	    case  6:
		  y -= roam_increment;
		  break;

	    case  7:
		  x += roam_increment;
		  y -= roam_increment;
		  break;

	    default:
		  kfprintf(kstderr,"Unknown direction (%d).\n", direction);
	}

	/*
	 *  Make sure we are not trying to set the offset past the edge of
	 *  the object.
	 */
	if (x < 0 || x+width  > WIDTH ||
	    y < 0 || y+height > HEIGHT)
	{
	   if ((x+width/2) > WIDTH)
	      x = WIDTH - width/2;
	   if ((x-width/2) < 0)
	      x = width/2;

	   if ((y+height/2) > HEIGHT)
	      y = HEIGHT - height;
	   if ((y-height/2) < 0)
	      y = height/2;

	   kgen_gauss(1,0.0,0.5,&noise);
	   current = ((int) noise) % 8;
	   if (current < 0)
	      current += 8;
	   if (current == 0)
	      current = 1;

	   direction = (direction + current) % 8;
	}

	/*
	 *  Set the newly acquired x & y offset....
	 */
	xvw_set_attributes(pixmap,
		XVW_XPOSITION, x,
		XVW_YPOSITION, y,
		NULL);
}
