#include <xvinclude.h>

/* 
 * This example creates an image; over it is a 2D plot and its axis system.
 */
void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject image, plot2d, axis2d;
	char *filename = "clust:ngl";

	if (argc > 1) filename = argv[1];

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/*  initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/* create the image object */
	image = xvw_create_image(NULL, "image");

	/* set filename which contains image data */
	xvw_set_attribute(image, XVW_IMAGE_IMAGEFILE, filename);

	/* create 2D plot object using image object as parent */
	plot2d = xvw_create_plot2d(image, "Plot2d");
	xvw_set_attributes(plot2d,
		XVW_PLOT2D_PLOTFILE, "plot2d:sine",
		XVW_PLOT2D_PLOTTYPE, KPLOT2D_BARGRAPH,
                XVW_GRAPHICS_VIEWPORT_MIN_X, 0.2,
                XVW_GRAPHICS_VIEWPORT_MIN_Y, 0.2,
                XVW_GRAPHICS_VIEWPORT_MAX_X, 0.9,
                XVW_GRAPHICS_VIEWPORT_MAX_Y, 0.9,
		NULL);

	/* create 2D axis object using image object as parent */
	axis2d = xvw_create_axis2d(image, "Axis2d");
	xvw_set_attributes(axis2d,
                XVW_GRAPHICS_VIEWPORT_MIN_X, 0.2,
                XVW_GRAPHICS_VIEWPORT_MIN_Y, 0.2,
                XVW_GRAPHICS_VIEWPORT_MAX_X, 0.9,
                XVW_GRAPHICS_VIEWPORT_MAX_Y, 0.9,
                NULL);


	/* display & run; there is no way to exit the program but ^C */
	xvf_run_form();
}
