#include <xvinclude.h>

/*
 * This simple program creates an imageicon object from the filename specified.
 * By default, the lizard image is used; alternatively, specify a filename with:
 * % example filename
 */
void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject imageicon;
	char *filename = "image:lizard";

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* Initialize the xvwidgets lib. */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/* create the image icon with a size of (75 x 75) pixels */
	imageicon = xvw_create_imageicon(NULL, "imageicon");
	xvw_set_attributes(imageicon,
		           XVW_IMAGEICON_SIZE,  100,
		           XVW_IMAGE_IMAGEFILE, filename,
		           NULL);

	/* display & run; there is no way to exit the program but ^C */
	xvf_run_form();
}
