#include <xvinclude.h>

float roam_time     = 0.05;
int  roam_increment = 10;
int  data_width, data_height;

void roam_image_timeout PROTO((xvobject, kaddr, int *));


/*
 *  This example displays the large map image, limiting the image window
 *  to a size of 512x512.  It puts up a pan icon, so you can see which 
 *  portion of the image is being displayed in the image window at any given
 *  time.  It then installs a timeout that will be called repeatedly to reset
 *  the area of the image which is being displayed in the image window, causing
 *  a "roaming" effect.  The "roaming" action is reflected by corresponding
 *  movement of the pan box in the pan icon.
 */
void main(
   int  argc,
   char *argv[],
   char *envp[])
{
        kobject  object;
        int      w, h, d, t, e;
        xvobject parent, image, panicon;
        char *filename = "image:USA";

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* initialize the xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror("marker", "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }

	/* open the image */
        if (!(object = kpds_open_input_object(filename)))
           kexit(KEXIT_FAILURE);

	/* get width & height of image */
        kpds_get_attribute(object, KPDS_VALUE_SIZE, 
			   &data_width, &data_height, NULL, NULL, NULL);

	/* create parent for image object & pan icon */
	parent = xvw_create_manager(NULL, "parent");

	/* create the image object, limit height to 512 x 512 */
        image = xvw_create_image(parent, "image");
        xvw_set_attributes(image,
                XVW_IMAGE_IMAGEOBJ, object,
                XVW_IMAGE_BACKING, FALSE,
                XVW_MAXIMUM_WIDTH,  512,
                XVW_MAXIMUM_HEIGHT, 512,
                NULL);

	/* 
	 * add a timeout to roam around the image; this will cause the 
         * roam_image_timeout() routine to be called repeatedly
         * at intervals specified by roam_time
         */
        xvw_add_timeout(image, roam_time, roam_image_timeout, NULL);

	/* put in a pan icon so you can see where you are in the image */
        panicon = xvw_create_panicon(parent, "panicon");
        xvw_set_attribute(panicon, XVW_IMAGE_IMAGEOBJ, object);

	/* display and run */
        xvf_run_form();
}

/*
 *  Here is the timeout that roams around the image.
 */
void roam_image_timeout(
   xvobject object,
   kaddr    client_data,
   int	    *dispatch)
{
	double noise;
	static int direction = 0;
	int    current, x, y, width, height;

	/*
	 *  Retrieve the current x & y offset...
	 *  (note: we could simply keep track of the x & y offset, but in case
	 *	 the user moves the image, we must be able to adjust for this)
	 */
	xvw_get_attributes(object, 
			   XVW_IMAGE_XOFFSET, &x,
			   XVW_IMAGE_YOFFSET, &y,
			   XVW_WIDTH,  &width,
			   XVW_HEIGHT, &height,
			   NULL);

	kgen_gauss(1,0.0,0.5,&noise);
	current = ((int) noise) % 5;
	if (current < 0) current += 8;

	direction = (direction + current) % 8;

	/*
	 *  assign xposition and yposition, since these are of type Dimension,
	 *  which are unsigned longs.  This causes problems with wrap-around.
	 */
	switch (direction)
	{
	    case  0:
		  x += roam_increment;
		  break;

	    case  1:
		  x += roam_increment;
		  y += roam_increment;
		  break;

	    case  2:
		  y += roam_increment;
		  break;

	    case  3:
		  x -= roam_increment;
		  y += roam_increment;
		  break;

	    case  4:
		  x -= roam_increment;
		  break;

	    case  5:
		  x -= roam_increment;
		  y += roam_increment;
		  break;

	    case  6:
		  y -= roam_increment;
		  break;

	    case  7:
		  x += roam_increment;
		  y -= roam_increment;
		  break;

	    default:
		  kfprintf(kstderr,"Unknown direction (%d).\n", direction);
	}

	/*
	 *  Make sure we are not trying to set the offset past the edge of
	 *  the image.
	 */
	if ((x-width/2)  < 0 || (x+width/2) > data_width ||
	    (y-height/2) < 0 || (y+height/2) > data_height)
	{
	   if ((x+width/2) > data_width)
	      x = data_width - width/2;
	   if ((x-width/2) < 0)
	      x = width/2;

	   if ((y+height/2) > data_height)
	      y = data_height - height;
	   if ((y-height/2) < 0)
	      y = height/2;

	   direction = (direction + 4) % 8;
	}

	/*
	 *  Set the newly acquired x & y offset....
	 */
	xvw_set_attributes(object,
		XVW_IMAGE_XOFFSET, x,
		XVW_IMAGE_YOFFSET, y,
		NULL);
}


