#include <xvinclude.h>

/* 
 * This example shows how you can display all the image bands in a sequence
 * at one time;  layout is done automatically with the rowcol object.  The
 * images would take up a very large amount of space, so we create an image 
 * icon from each image band, and then display the set in the rowcol object.
 */
void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	int       i, d, t, e;
	kobject   data_object;
	xvobject  rowcol, image;
	char *filename = "sequence:baby";

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* Initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror("test", "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/* 
	 * use a rowcol object to lay out the image icons in neat rows and
         * columns without any kind of explicit layout specification
	 */
	rowcol = xvw_create_rowcol(NULL, "layout");
	xvw_set_attributes(rowcol,
			   XVW_WIDTH,   1000,
			   XVW_HEIGHT,  400,
			   NULL);

	/*
	 * open the data object to get number of image bands (stored as depth)
	 */
	data_object = kpds_open_object(filename, KOBJ_READ);
	kpds_get_attribute(data_object, KPDS_VALUE_SIZE, 
			   NULL, NULL, &d, &t, &e);

	for (i = 0; i < d * t * e; i++)
	{
	   image = xvw_create_imageicon(rowcol, "image");
	   xvw_set_attributes(image,
		 	      XVW_IMAGE_IMAGEOBJ, data_object,
			      XVW_IMAGE_BANDNUM,  i,
			      NULL);
	}

	/* display & run; there is no way to exit the program but ^C */
	xvf_run_form();
}
