#include <xvinclude.h>

int num = 4;

void  quit_program PROTO((xvobject, kaddr, XEvent *));
void  scramble_img PROTO((xvobject, kaddr, kaddr));

xvobject button1, button2; /* buttons to in/de crement region size */
xvobject label;            /* lists number of regions */

/*
 * This program operates very similarly to the scrambling image example in
 * 09.scramble_image/.  However, this version normalizes each region before
 * it restores the region;  this produces a patchwork effect which is more
 * pronounced with each scrambling/descrambling operation, in contrast to
 * the example in 09.scramble_image/, where the descrambling procedure simply
 * restores the original image.
 */
void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	kobject  data_obj;         /* image data object   */
	xvobject manager;          /* backplane for image & buttons */
        xvobject img_visual_obj;   /* image visual object */
	char     *filename = "image:moon";
	
        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	if (argc > 1)
	   filename = argv[1];

	/* initialize xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }


	/* 
	 *  HERE is the entire difference between this version of the scrambling
	 *  example and that of 09.scramble_image/.  Scaling is set to 
	 *  normalize between 0 and 255.
	 */
	data_obj  = kpds_open_object(filename, KOBJ_READ);
	kpds_set_attributes(data_obj,
		KPDS_VALUE_SCALING,  KNORMALIZE,
                KPDS_VALUE_NORM_MIN, 0.0,
                KPDS_VALUE_NORM_MAX, 255.0,
                NULL);

	/* create a parent for the image & buttons */
	manager = xvw_create_manager(NULL, "parent");

	/* create the image object & associate it with the file specified */
        img_visual_obj = xvw_create_image(manager, "image");
        xvw_set_attributes(img_visual_obj,
		XVW_IMAGE_IMAGEOBJ, data_obj,
		XVW_IMAGE_BACKING,  FALSE,
		NULL);

	/* create button to decrement number of regions */
	button1 = xvw_create_button(manager, "button1");
	xvw_set_attributes(button1, 
			   XVW_LABEL,      " < ",
			   XVW_CHAR_WIDTH,  10.0,
			   XVW_CHAR_HEIGHT, 2.0,
			   XVW_BELOW,       img_visual_obj,
			   XVW_RIGHT_OF,    NULL,
			   NULL);
	xvw_add_callback(button1, XVW_BUTTON_SELECT, scramble_img, data_obj);
			
	/* create button to increment number of regions */
	button2 = xvw_create_button(manager, "button2");
	xvw_set_attributes(button2, 
			   XVW_LABEL,        " > ",
			   XVW_CHAR_WIDTH,    10.0,
			   XVW_CHAR_HEIGHT,   2.0,
			   XVW_BELOW,         img_visual_obj,
			   XVW_LEFT_OF,       NULL,
			   NULL);
	xvw_add_callback(button2, XVW_BUTTON_SELECT, scramble_img, data_obj);
			
	/* create label to display number of regions */
	label = xvw_create_label(manager, "label");
	xvw_set_attributes(label,
			   XVW_LABEL,   "number of regions = 16",
			   XVW_RIGHT_OF, button1,
			   XVW_LEFT_OF,  button2,
			   XVW_BELOW,    img_visual_obj,
			   XVW_ABOVE,    NULL,
			   NULL);
		

	/* add the action handler to quit on KeyPress 'q' */
	xvw_add_action(img_visual_obj, "<Key>q", quit_program,
	               data_obj, TRUE);

	/* add the event handler to scramble image on KeyPress '<' or '>'*/
	xvw_add_event(img_visual_obj, KeyPressMask, scramble_img,
	              data_obj);

	/* display & run */
        xvf_run_form();
}

/*
 *  event handler to quit program on Button Press
 */
void  quit_program(
   xvobject object,
   kaddr    client_data,
   XEvent   *event)
{
	kobject data_obj = (kobject) client_data;

	xvw_destroy(object);
	kpds_close_object(data_obj);
        kexit(KEXIT_SUCCESS);
}

/*
 * callback installed on both buttons to scramble image;
 * callback checks which (globally declared) button called it,
 * so it knows whether to increment or decrement region number.
 */
void  scramble_img(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
	kobject  data_obj;
	char     ch = '\0';
	int      i, j, w, h, d, t, e;
	unsigned char *data1 = NULL, *data2 = NULL;
	char     temp[KLENGTH];

	data_obj = (kobject) client_data;

	/* determine region num: decrement for '<', increment on '>' */
	if (object == button1) 
	{
	   if (num < 4)
	   {
		kerror(NULL, "scramble_img", 
		       "number of regions < 4: use '>'");
		return;
	   }
	}
	else if (object == button2)
	{
	  if (num > 64)
	  {
                kerror(NULL, "scramble_img", 
		       "number of regions > 64: use '<'");
                return;
	  }
	}

	/* get the size of the segment for calculation */
	kpds_get_attribute(data_obj, KPDS_VALUE_SIZE, &w, &h, &d, &t, &e);

	/* set size of each region, given image size & region num */
	kpds_set_attribute(data_obj,
                           KPDS_VALUE_REGION_SIZE, w/num, h/num, d, t, e);

	/* circulate through the image, doing 'num' regions */
	for (i = 0; i < num; i++)
	{
	    for (j = 0; j < num; j++)
	    {
		/* swap and then restore regions */
	        kpds_set_attribute(data_obj,
				   KPDS_VALUE_POSITION, (w-w/num) - i*(w/num),
				   (h-h/num)-j*(h/num), 0, 0, 0);
	        data1 = kpds_get_data(data_obj, KPDS_VALUE_REGION, data1);

	        kpds_set_attribute(data_obj,
			           KPDS_VALUE_POSITION, i*(w/num), 
				   j*(h/num), 0, 0, 0);
	        data2 = kpds_get_data(data_obj, KPDS_VALUE_REGION, data2);

	        kpds_put_data(data_obj, KPDS_VALUE_REGION, data1);
	        kpds_set_attribute(data_obj,
				   KPDS_VALUE_POSITION, (w-w/num) - i*(w/num),
                                   (h-h/num)-j*(h/num), 0, 0, 0);
	        kpds_put_data(data_obj, KPDS_VALUE_REGION, data2);
	    }
	}
	kfree(data1);
	kfree(data2);
	
	if (object == button1)  num /= 2;
	else num *= 2;

	/* update label to reflect number of regions */
	ksprintf(temp, "number of regions = %d  ", num*num);
	xvw_set_attribute(label, XVW_LABEL, temp);

}
