#include <xvinclude.h>

void  quit_program PROTO((xvobject, kaddr, XEvent *));

/*
 * This program reads in the ball image, increases the size of the of ball by
 * doing a first order interpolation, and then displays the enlarged image.
 * Installs an action handler to exit the program when the user presses 'q'.
 */
main(
   int  argc,
   char *argv[],
   char *envp[])
{
	kobject  img_data_obj;   /* the image data object   */
        xvobject img_visual_obj; /* the image visual object */

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* initialize xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }

	/* create the xvobject to display the image */
        img_visual_obj = xvw_create_image(NULL, "image");

	/*
         *  read in the ball image;  double its size through a first order
         *  interpolation.
         */
	img_data_obj = kpds_open_input_object("image:ball");
	kpds_set_attribute(img_data_obj, KPDS_VALUE_SIZE,
			   1024, 1024, 1, 1, 1);
	kpds_set_attribute(img_data_obj, KPDS_VALUE_INTERPOLATE, KFIRST_ORDER);

	/* associate the image we just read in w/ the image xvobject */
        xvw_set_attribute(img_visual_obj, XVW_IMAGE_IMAGEOBJ, img_data_obj);

	/* add an action handler to quit on KeyPress Q or q */
	xvw_add_action(img_visual_obj, "<Key>q", quit_program, 
                       NULL, TRUE);

	/* display & run */
        xvf_run_form();
}

/*
 * action handler allowing the user to quit program
 */
void  quit_program(
   xvobject object,
   kaddr    client_data,
   XEvent   *event)
{
	xvw_destroy(object);
        kexit(KEXIT_SUCCESS);
}
