#include <xvinclude.h>

/*
 * This example displays a pseudocolor object and an image object, both working
 * off the information in one of the Albuquerque images.   A colorcell object, 
 * also working from the same information, is created in upper left hand corner 
 * of the image.  A colorcell object is associated with a pixel value of 10 in 
 * the image;  it is a box filled with the same color as the pixel and labelled  * with the pixel value inside.  The pseudocolor object has a value of 10 added 
 * to its list, so the red, green, and blue * colorbars will simulataneously 
 * update the colorcell and the image.
 *
 *  An event handler is installed on the image so that when you button press
 *  on pixels in the image,  the pseudocolor object is used to change each 
 *  selected pixel to the same color as the pixel value 10.  The pseudocolor
 *  scrollbars can be used to change the color of pixel value 10; all the
 *  other selected pixel values will also take on the new color.
 */

void  image_handler   PROTO((xvobject, kaddr, XEvent *, Boolean *));

void main(
    int  argc,
    char **argv,
    char **envp)
{
        xvobject image, pseudo, colorcell, manager;
	char *filename = "clust:albq1";

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	if (argc > 1)
	    filename = argv[1];

	/* initialize the xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }

	/* create an image object to display the "image:ball" file */
	manager = xvw_create_manager(NULL, "parent");

	image = xvw_create_image(manager, "image");
	xvw_set_attribute(image, XVW_IMAGE_IMAGEFILE, filename);

	/* create a pseudocolor object */
        pseudo = xvw_create_pseudo(NULL, "pseudo");
        xvw_set_attributes(pseudo,
		XVW_COLOR_COLORFILE,     filename,
		XVW_PSEUDO_UPDATE_ONADD, TRUE,
		XVW_PSEUDO_ADD,          10,
		NULL);


	colorcell = xvw_create_colorcell(xvw_parent(image), "colorcell");
	xvw_set_attributes(colorcell,
		XVW_COLOR_COLORFILE,  filename,
		XVW_COLORCELL_INDEX,  10,
		XVW_BELOW,  image,
		NULL);

	xvw_add_event(image, ButtonPressMask, image_handler, pseudo);

	/* display & run */
        xvf_run_form();
}

/*
 *  event handler to
 */
void  image_handler(
    xvobject image,
    kaddr    clientData,
    XEvent   *event,
    Boolean  *dispatch)
{
	double indx;
	xvobject pseudo = (xvobject) clientData;


	xvw_get_attribute(image, XVW_IMAGE_VALUE, &indx);
	xvw_set_attribute(pseudo, XVW_PSEUDO_ADD, (int) indx);
}
