#include <xvinclude.h>

/*
 *  This example simply displays a psuedocolor object working off the 
 *  image information found in the "image:ball" image file.  A pseudocolor
 *  object displays a set of the colorcells found in the image; below the
 *  palette are three scrollbars to control the Red, Green, and Blue elements
 *  of a particular color.  Select a "pseudocolor range" by clicking the
 *  first mouse button on two colorcells in the palette; then, use the Red, 
 *  Green, and Blue scrollbars to change the color displayed by the pixels in 
 *  that range.
 */
void main(
  int argc,
  char **argv,
  char **envp)
{
	kobject  ball;
        xvobject parent, pseudo;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* initialize the xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }

	parent = xvw_create_manager(NULL, "parent");

	/* create a pseudocolor object w/ image:ball as target image */ 
        pseudo = xvw_create_pseudo(parent, "pseudo");
	xvw_set_attributes(pseudo, 
			   XVW_WIDTH,  300,
			   XVW_HEIGHT, 200,
			   NULL);

	/* open data object associated with ball informatin */
        ball = kpds_open_input_object("image:ball");

	/* 
	 * use XVW_COLOR_COLOROBJ to associate the pseudocolor object with
         * the ball data object.  alternatively, we could have used 
         * XVW_COLOR_COLORFILE to specify the "image:ball" file directly
         */
        xvw_set_attribute(pseudo, XVW_COLOR_COLOROBJ, ball);

	/* display and run the program */
        xvf_run_form();
}
