#include <xvinclude.h>

/*
 *
 * This example creates a window with a single line annotation in it.
 *
 * After the manager object parent is put into edit mode (hold down
 * shift key and click the left mouse button), the line can be 
 * interactively moved by "grabbing" it in the middle with the left mouse 
 * button; grabbing it near an end will cause the line to resize.
 *
 * The internal menuform for the line may be displayed by clicking
 * the middle mouse button on the line; the menuform may then be
 * used to set attributes of the line.
 */

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
        xvobject parent;
        xvobject line;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* initialize the xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }

	/*
	 *  create a manager backplane. make it selectable so
         *  the user can put it in edit mode & move the line around.
	 */
	parent = xvw_create_manager(NULL, "parent");
	xvw_set_attributes(parent,
			   XVW_WIDTH,      300,
			   XVW_HEIGHT,     300,
			   XVW_SELECTABLE, TRUE,
			   NULL);

	/*
	 *  create the line object; specify endpoints of line
         *  in world coordinates.  make it menuable so the user
         *  will be able to bring up the internal menuform & set
         *  line attributes.
	 */
        line = xvw_create_line(parent, "line");
        xvw_set_attributes(line,
                           XVW_LINE_XBEGIN, 0.5,
                           XVW_LINE_YBEGIN, 0.5,
                           XVW_LINE_XEND,   0.75,
                           XVW_LINE_YEND,   0.75,
			   XVW_MENUABLE,    TRUE,
                           NULL);
	/* display & run the program */
        xvf_run_form();
}
