#include <xvinclude.h>

void marker_event_handler PROTO((xvobject, kaddr, XEvent *, int *));

/*
 * This is an example of a marker object using an event handler.
 * It creates a single marker annotation, and adds an event handler, so that
 * button press on the marker turns it blue!  Button release turns it red again!
 */

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject marker;
	static   char *colors[] = { "yellow", "red", "blue", "green" };

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* initialize the xvwidget library */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
	}

	/* create the marker in red at (0.5, 0.5) */
	marker = xvw_create_marker(NULL, "marker");
	xvw_set_attributes(marker,
		XVW_MARKER_XPLACEMENT, 0.5,
		XVW_MARKER_YPLACEMENT, 0.5,
		XVW_FOREGROUND_COLOR, colors[1],
		NULL);

	/* 
	 * Add the event handler "marker_event_handler" on the marker, 
         * which will be invoked on both button press & button release 
         * events.  The colors array needs to be passed to the event
         * handler, so send it in as the client data.
	 */
	xvw_add_event(marker, ButtonPressMask | ButtonReleaseMask,
		marker_event_handler, colors);

	/* display and run */
	xvf_run_form();
}

/*
 *  here is the event handler invoked by button press & 
 *  button release events that happen on the marker.
 */
void marker_event_handler(
    xvobject  object,
    kaddr     client_data,
    XEvent    *event,
    int       *dispatch)
{
	char **colors = (char **) client_data;

	if (event->type == ButtonPress)
	{
	   xvw_set_attribute(object, XVW_FOREGROUND_COLOR, colors[2]);
	   kfprintf(kstderr, "Button Press event detected\n");
	   kfprintf(kstderr, "Turning marker %s\n", colors[2]);
	}
	else if (event->type == ButtonRelease)
	{
	   xvw_set_attribute(object, XVW_FOREGROUND_COLOR, colors[1]);
	   kfprintf(kstderr, "Button Release event detected\n");
	   kfprintf(kstderr, "Turning marker %s\n", colors[1]);
	}
}
