 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "runwksp.h"
/*-----------------------------------------------------------
| 
|  Routine Name: runwksp_get_args
| 
|       Purpose: Gets command line args for runwksp
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname runwksp
|          Date: Apr 18, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void runwksp_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for runwksp is out of sync with arguments specified in runwksp's *.pane file; please rerun ghostwriter on runwksp.";


	/*
	 * allocate the runwksp structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_string(pane, "args",
			  &(clui_info->args_string),
			  &(clui_info->args_flag))))
	{
	    kerror(NULL, "runwksp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "hidden",
			  &(clui_info->hidden_flag))))
	{
	    kerror(NULL, "runwksp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "silent",
			  &(clui_info->silent_flag))))
	{
	    kerror(NULL, "runwksp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "showgui",
			  &(clui_info->showgui_flag))))
	{
	    kerror(NULL, "runwksp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "x",
			  &(clui_info->x_int),
			  &(clui_info->x_flag))))
	{
	    kerror(NULL, "runwksp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "width",
			  &(clui_info->width_int),
			  &(clui_info->width_flag))))
	{
	    kerror(NULL, "runwksp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "y",
			  &(clui_info->y_int),
			  &(clui_info->y_flag))))
	{
	    kerror(NULL, "runwksp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "height",
			  &(clui_info->height_int),
			  &(clui_info->height_flag))))
	{
	    kerror(NULL, "runwksp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "wksp",
			  &(clui_info->wksp_file),
			  &(clui_info->wksp_flag))))
	{
	    kerror(NULL, "runwksp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "tb",
			  &(clui_info->tb_string),
			  &(clui_info->tb_flag))))
	{
	    kerror(NULL, "runwksp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "oname",
			  &(clui_info->oname_string),
			  &(clui_info->oname_flag))))
	{
	    kerror(NULL, "runwksp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



