 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for runwksp
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "runwksp.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Execute a saved cantata workspace, with or without GUI
|
|       Purpose: main program for runwksp
|
|         Input:
|		char *clui_info->args_string; {Arguments to be passed to the encapsulated workspace}
|		int   clui_info->args_flag; {TRUE if -args specified}
|
|		int clui_info->hidden_flag; {TRUE if -hidden specified}
|
|		int clui_info->silent_flag; {TRUE if -silent specified}
|
|		int clui_info->showgui_flag; {TRUE if -showgui specified}
|
|		int clui_info->x_int; {x location of GUI}
|		int clui_info->x_flag; {TRUE if -x specified}
|
|		int clui_info->width_int; {The window width}
|		int clui_info->width_flag; {TRUE if -width specified}
|
|		int clui_info->y_int; {y location of GUI}
|		int clui_info->y_flag; {TRUE if -y specified}
|
|		int clui_info->height_int; {The window height}
|		int clui_info->height_flag; {TRUE if -height specified}
|
|		Optional M.E. group:
|		    char *clui_info->wksp_file; {Input workspace file to be run}
|		    int   clui_info->wksp_flag; {TRUE if -wksp specified}
|
|		    M.I. group:
|			char *clui_info->tb_string; {the toolbox in which the encapsulated workspace}
|			int   clui_info->tb_flag; {TRUE if -tb specified}
|
|			char *clui_info->oname_string; {The encapsulated workspace object name}
|			int   clui_info->oname_flag; {TRUE if -oname specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 18, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DESIGN");
	kexit_handler(runwksp_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DESIGN", "runwksp",
		runwksp_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	runwksp_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

	/*
	 * Initialize xvwidgets lib
	 */
	if (!(xvw_initialize(XVW_MENUS_XVFORMS)))
	{
	     kinfo(KSTANDARD, "Could not open connection to server");
	     kexit(KEXIT_FAILURE);
	}

/* -main_before_lib_call */
	create_workspace();
/* -main_before_lib_call_end */

/* -main_library_call */
	xvf_run_form();
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: runwksp_usage_additions
| 
|       Purpose: Prints usage additions in runwksp_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname runwksp
|          Date: Apr 18, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void runwksp_usage_additions(void)
{
	kfprintf(kstderr, "\tExecute a saved cantata workspace, with or without GUI\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: runwksp_free_args
| 
|       Purpose: Frees CLUI struct allocated in runwksp_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname runwksp
|          Date: Apr 18, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
runwksp_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->args_string);
	kfree(clui_info->wksp_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
